/*
 * Decompiled with CFR 0.152.
 */
package de.serviceflow.codegenj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bluez.Adapter1;
import org.bluez.AgentManager1;
import org.bluez.Device1;
import org.bluez.GattCharacteristic1;
import org.bluez.GattService1;

public class ObjectManager {
    private static ObjectManager instance;
    private static final Logger LOGGER;
    private Object _client;
    private final String objectpath;
    private static Map<String, AgentManager1> agentmanager1Map;
    private static Map<String, Adapter1> adapter1Map;
    private static List<ObjectManagerSignalListener> objectManagerSignalListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectManager getInstance() {
        Class<ObjectManager> clazz = ObjectManager.class;
        synchronized (ObjectManager.class) {
            if (instance == null) {
                new ObjectManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static final Logger getLogger() {
        return LOGGER;
    }

    private static final int getLogLevelIntValue() {
        Logger l = LOGGER;
        do {
            Level level;
            if ((level = l.getLevel()) == null) continue;
            return level.intValue();
        } while ((l = l.getParent()) != null);
        return Integer.MAX_VALUE;
    }

    private ObjectManager() {
        this("/");
        instance = this;
        this.initCollectorAPI();
        this._run();
    }

    protected ObjectManager(String objectpath) {
        if (objectpath.length() <= 1 && objectpath.charAt(0) == '/' && instance != null) {
            throw new Error("Use getInstance() to obtain System root instance.");
        }
        if (objectpath.charAt(objectpath.length() - 1) != '/') {
            objectpath = objectpath + "/";
        }
        this._init(objectpath);
        this.objectpath = objectpath;
        if (ObjectManager.getLogger().isLoggable(Level.FINER)) {
            System.out.println("*** ObjectManager : Direct Buffer with NativeReference : " + this._client);
        }
    }

    private native void _init(String var1);

    private native void _run();

    public native void _destroy();

    public String getObjectPath() {
        return this.objectpath;
    }

    public native Object[] getProxyObjects(String var1, boolean var2);

    public native String getObjectPath(Object var1);

    public native void dump();

    public static void addAgentManager1Object(String path, Object proxy) {
        AgentManager1 n = new AgentManager1(proxy);
        if (path == null) {
            path = ObjectManager.getInstance().getObjectPath(proxy);
        }
        agentmanager1Map.put(path, n);
        n.setObjectPath(path);
    }

    public static void removeAgentManager1Object(String path, Object proxy) {
        if (path == null) {
            path = ObjectManager.getInstance().getObjectPath(proxy);
        }
        AgentManager1 n = agentmanager1Map.get(path);
        n._destroy();
        agentmanager1Map.remove(path);
    }

    public static void initializeAgentManager1Mapping() {
        Object[] newProxies;
        agentmanager1Map = Collections.synchronizedMap(new HashMap());
        for (Object proxy : newProxies = ObjectManager.getInstance().getProxyObjects("org.bluez.AgentManager1", true)) {
            ObjectManager.addAgentManager1Object(null, proxy);
        }
        System.out.println("*** agentmanager1Map initialized, count=" + newProxies.length);
    }

    public List<AgentManager1> getAgentManagers() {
        ArrayList<AgentManager1> resultList = new ArrayList<AgentManager1>();
        String prefix = this.objectpath;
        if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) != '/') {
            prefix = prefix + '/';
        }
        for (Map.Entry<String, AgentManager1> entry : agentmanager1Map.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            resultList.add(entry.getValue());
        }
        return resultList;
    }

    public static void addAdapter1Object(String path, Object proxy) {
        Adapter1 n = new Adapter1(proxy);
        if (path == null) {
            path = ObjectManager.getInstance().getObjectPath(proxy);
        }
        adapter1Map.put(path, n);
        n.setObjectPath(path);
    }

    public static void removeAdapter1Object(String path, Object proxy) {
        if (path == null) {
            path = ObjectManager.getInstance().getObjectPath(proxy);
        }
        Adapter1 n = adapter1Map.get(path);
        n._destroy();
        adapter1Map.remove(path);
    }

    public static void initializeAdapter1Mapping() {
        Object[] newProxies;
        adapter1Map = Collections.synchronizedMap(new HashMap());
        for (Object proxy : newProxies = ObjectManager.getInstance().getProxyObjects("org.bluez.Adapter1", true)) {
            ObjectManager.addAdapter1Object(null, proxy);
        }
        System.out.println("*** adapter1Map initialized, count=" + newProxies.length);
    }

    public List<Adapter1> getAdapters() {
        ArrayList<Adapter1> resultList = new ArrayList<Adapter1>();
        String prefix = this.objectpath;
        if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) != '/') {
            prefix = prefix + '/';
        }
        for (Map.Entry<String, Adapter1> entry : adapter1Map.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            resultList.add(entry.getValue());
        }
        return resultList;
    }

    public void initCollectorAPI() {
        System.out.println("*** initCollectorAPI() start");
        Adapter1.initializeDevice1Mapping();
        Device1.initializeGattService1Mapping();
        GattService1.initializeGattCharacteristic1Mapping();
        GattCharacteristic1.initializeGattDescriptor1Mapping();
        ObjectManager.initializeAgentManager1Mapping();
        ObjectManager.initializeAdapter1Mapping();
        System.out.println("*** initCollectorAPI() end");
    }

    public void addObjectToCollection(String objectpath, String interfaceName, Object proxy) {
        if ("org.bluez.Device1".equals(interfaceName)) {
            Adapter1.addDevice1Object(objectpath, proxy);
        }
        if ("org.bluez.GattService1".equals(interfaceName)) {
            Device1.addGattService1Object(objectpath, proxy);
        }
        if ("org.bluez.GattCharacteristic1".equals(interfaceName)) {
            GattService1.addGattCharacteristic1Object(objectpath, proxy);
        }
        if ("org.bluez.GattDescriptor1".equals(interfaceName)) {
            GattCharacteristic1.addGattDescriptor1Object(objectpath, proxy);
        }
        if ("org.bluez.AgentManager1".equals(interfaceName)) {
            ObjectManager.addAgentManager1Object(objectpath, proxy);
        }
        if ("org.bluez.Adapter1".equals(interfaceName)) {
            ObjectManager.addAdapter1Object(objectpath, proxy);
        }
    }

    public void removeObjectFromCollection(String objectpath, String interfaceName, Object proxy) {
        if ("org.bluez.Device1".equals(interfaceName)) {
            Adapter1.removeDevice1Object(objectpath, proxy);
        }
        if ("org.bluez.GattService1".equals(interfaceName)) {
            Device1.removeGattService1Object(objectpath, proxy);
        }
        if ("org.bluez.GattCharacteristic1".equals(interfaceName)) {
            GattService1.removeGattCharacteristic1Object(objectpath, proxy);
        }
        if ("org.bluez.GattDescriptor1".equals(interfaceName)) {
            GattCharacteristic1.removeGattDescriptor1Object(objectpath, proxy);
        }
        if ("org.bluez.AgentManager1".equals(interfaceName)) {
            ObjectManager.removeAgentManager1Object(objectpath, proxy);
        }
        if ("org.bluez.Adapter1".equals(interfaceName)) {
            ObjectManager.removeAdapter1Object(objectpath, proxy);
        }
    }

    protected static void dispatchObjectManagerSignal(String signalname, String objectpath, String interfaceName, Object proxy) {
        if ("object-added".equals(signalname)) {
            for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
                l.objectAdded(ObjectManager.getInstance(), objectpath);
            }
        } else if ("object-removed".equals(signalname)) {
            for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
                l.objectRemoved(ObjectManager.getInstance(), objectpath);
            }
        } else if ("interface-added".equals(signalname)) {
            ObjectManager.getInstance().addObjectToCollection(objectpath, interfaceName, proxy);
            for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
                l.interfaceAdded(ObjectManager.getInstance(), objectpath, interfaceName);
            }
        } else if ("interface-removed".equals(signalname)) {
            for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
                l.interfaceRemoved(ObjectManager.getInstance(), objectpath, interfaceName);
            }
            ObjectManager.getInstance().removeObjectFromCollection(objectpath, interfaceName, proxy);
        }
    }

    public void addObjectManagerSignalListener(ObjectManagerSignalListener l) {
        objectManagerSignalListeners.add(l);
    }

    public void removeObjectManagerSignalListener(ObjectManagerSignalListener l) {
        objectManagerSignalListeners.remove(l);
    }

    static {
        System.loadLibrary("bluezdbus");
        instance = null;
        LOGGER = Logger.getLogger(ObjectManager.class.getName());
        agentmanager1Map = null;
        adapter1Map = null;
        objectManagerSignalListeners = Collections.synchronizedList(new ArrayList());
    }

    public static class DBusInterface {
        private String objectpath;

        protected DBusInterface() {
        }

        public String getObjectPath() {
            return this.objectpath;
        }

        public void setObjectPath(String path) {
            this.objectpath = path;
        }
    }

    public static interface ObjectManagerSignalListener {
        public void interfaceAdded(ObjectManager var1, String var2, String var3);

        public void interfaceRemoved(ObjectManager var1, String var2, String var3);

        public void objectAdded(ObjectManager var1, String var2);

        public void objectRemoved(ObjectManager var1, String var2);
    }
}

