/*
 * Decompiled with CFR 0.152.
 */
package de.serviceflow.codegenj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectManager {
    private static ObjectManager instance;
    private static final Logger LOGGER;
    private Object _client;
    private final String objectpath;
    private static List<ObjectManagerSignalListener> objectManagerSignalListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectManager getInstance() {
        Class<ObjectManager> clazz = ObjectManager.class;
        synchronized (ObjectManager.class) {
            if (instance == null) {
                new ObjectManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static final Logger getLogger() {
        return LOGGER;
    }

    private static final int getLogLevelIntValue() {
        Logger l = LOGGER;
        do {
            Level level;
            if ((level = l.getLevel()) == null) continue;
            return level.intValue();
        } while ((l = l.getParent()) != null);
        return Integer.MAX_VALUE;
    }

    private ObjectManager() {
        this("/");
        instance = this;
        this.initCollectorAPI();
        this._run();
    }

    protected ObjectManager(String objectpath) {
        if (objectpath.length() <= 1 && objectpath.charAt(0) == '/' && instance != null) {
            throw new Error("Use getInstance() to obtain System root instance.");
        }
        if (objectpath.charAt(objectpath.length() - 1) != '/') {
            objectpath = objectpath + "/";
        }
        this._init(objectpath);
        this.objectpath = objectpath;
        if (ObjectManager.getLogger().isLoggable(Level.FINER)) {
            System.out.println("*** ObjectManager : Direct Buffer with NativeReference : " + this._client);
        }
    }

    private native void _init(String var1);

    private native void _run();

    public native void _destroy();

    public String getObjectPath() {
        return this.objectpath;
    }

    public native Object[] getProxyObjects(String var1, boolean var2);

    public native String getObjectPath(Object var1);

    public native void dump();

    public void initCollectorAPI() {
        System.out.println("*** initCollectorAPI() start");
        System.out.println("*** initCollectorAPI() end");
    }

    public void addObjectToCollection(String objectpath, String interfaceName, Object proxy) {
    }

    public void removeObjectFromCollection(String objectpath, String interfaceName, Object proxy) {
    }

    protected static void dispatchObjectManagerSignal(String signalname, String objectpath, String interfaceName, Object proxy) {
        if ("object-added".equals(signalname)) {
            for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
                l.objectAdded(ObjectManager.getInstance(), objectpath);
            }
        } else if ("object-removed".equals(signalname)) {
            for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
                l.objectRemoved(ObjectManager.getInstance(), objectpath);
            }
        } else if ("interface-added".equals(signalname)) {
            ObjectManager.getInstance().addObjectToCollection(objectpath, interfaceName, proxy);
            for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
                l.interfaceAdded(ObjectManager.getInstance(), objectpath, interfaceName);
            }
        } else if ("interface-removed".equals(signalname)) {
            for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
                l.interfaceRemoved(ObjectManager.getInstance(), objectpath, interfaceName);
            }
            ObjectManager.getInstance().removeObjectFromCollection(objectpath, interfaceName, proxy);
        }
    }

    public void addObjectManagerSignalListener(ObjectManagerSignalListener l) {
        objectManagerSignalListeners.add(l);
    }

    public void removeObjectManagerSignalListener(ObjectManagerSignalListener l) {
        objectManagerSignalListeners.remove(l);
    }

    static {
        System.loadLibrary("bluezdbus");
        instance = null;
        LOGGER = Logger.getLogger(ObjectManager.class.getName());
        objectManagerSignalListeners = Collections.synchronizedList(new ArrayList());
    }

    public static class DBusInterface {
        private String objectpath;

        protected DBusInterface() {
        }

        public String getObjectPath() {
            return this.objectpath;
        }

        public void setObjectPath(String path) {
            this.objectpath = path;
        }
    }

    public static interface ObjectManagerSignalListener {
        public void interfaceAdded(ObjectManager var1, String var2, String var3);

        public void interfaceRemoved(ObjectManager var1, String var2, String var3);

        public void objectAdded(ObjectManager var1, String var2);

        public void objectRemoved(ObjectManager var1, String var2);
    }
}

