/* Source generated by codegenj (https://github.com/olir/codegenj) - DO NOT EDIT!
 *
 * https://github.com/olir/codegenj
 *
 * This license does not apply to any contained documentation in the source!
 *
 * This generated output is free and unencumbered software released into the public domain.
 *
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to <http://unlicense.org>
 */
package org.bluez;

import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.Collections;
import de.serviceflow.codegenj.ObjectManager;
import de.serviceflow.codegenj.ObjectManager.DBusInterface;
import java.io.IOException;

/**
 * D-Bus JNI Interface class for org.bluez.GattCharacteristic1
 */  
public class GattCharacteristic1 extends DBusInterface {
    static {
        System.loadLibrary("bluezdbus"); // Load native library libbluezdbus.so at runtime
    }
 
    private Object _proxy;

    public GattCharacteristic1(Object proxy) {
    	_proxy = proxy;
    	_init();
    }

     public native void _init();
     
     public native void _destroy();
 
 
	static private	Map<String, org.bluez.GattDescriptor1> gattdescriptor1Map = null;

    static public void addGattDescriptor1Object(String path, Object proxy) {
   			org.bluez.GattDescriptor1 n = new org.bluez.GattDescriptor1(proxy);
   			if (path==null)
   				path = ObjectManager.getInstance().getObjectPath(proxy);
    		gattdescriptor1Map.put(path, n);
    		n.setObjectPath(path);
	}
	
    static public void removeGattDescriptor1Object(String path, Object proxy) {
   			if (path==null)
   				path = ObjectManager.getInstance().getObjectPath(proxy);
    		org.bluez.GattDescriptor1  n = gattdescriptor1Map.get(path);
    		n._destroy();
    		gattdescriptor1Map.remove(path);
	}
	
    static public void initializeGattDescriptor1Mapping() {
   		gattdescriptor1Map = Collections.synchronizedMap(new HashMap<String, org.bluez.GattDescriptor1>());
    	if (false) {
			Object [] newProxies = ObjectManager.getInstance().getProxyObjects("org.bluez.GattDescriptor1", false);
	    	for (Object proxy : newProxies) {
	   			addGattDescriptor1Object(null, proxy);
	    	}
			System.out.println("*** gattdescriptor1Map initialized, count="+(newProxies.length));
		}
    }

    public List<org.bluez.GattDescriptor1> getDescriptors() {
    	if (!false) {
    		gattdescriptor1Map.clear();
			Object [] newProxies = ObjectManager.getInstance().getProxyObjects("org.bluez.GattDescriptor1", false);
	    	for (Object proxy : newProxies) {
	   			addGattDescriptor1Object(null, proxy);
	    	}
			//System.out.println("*** gattdescriptor1Map updated, count="+(newProxies.length));
		}

		List<org.bluez.GattDescriptor1> resultList = new ArrayList<org.bluez.GattDescriptor1>();
		String prefix = getObjectPath();
		if (prefix.length()>0 && prefix.charAt(prefix.length()-1)!='/') {
			prefix = prefix + '/';
		}
		//System.out.println(" ** gattdescriptor1Map: searching at prefix="+prefix);
		for (Map.Entry<String, org.bluez.GattDescriptor1> entry : gattdescriptor1Map.entrySet()) {
			String key = entry.getKey();
			// System.out.println("  * key="+key);
			if (key.startsWith(prefix)) {
				resultList.add(entry.getValue());
			}
		}
		return resultList;
    }

    


    /**
     * Reads property UUID.
     *
     * 128-bit characteristic UUID. 
     *
     * @return the property value.
     */
    public native String getUUID();



// property signature unsupported: Service



    /**
     * Reads property Value.
     *
     * The cached value of the characteristic. This property gets updated 
			only after a successful read request and when a notification or indication 
			is received, upon which a PropertiesChanged signal will be emitted. 
     *
     * @return the property value.
     */
    public native byte[] getValue();




    /**
     * Reads property Notifying.
     *
     * True, if notifications or indications on this characteristic are currently 
			enabled. 
     *
     * @return the property value.
     */
    public native boolean getNotifying();




    /**
     * Reads property Flags.
     *
     * Defines how the characteristic value can be used. See Core spec "Table 
			3.5: Characteristic Properties bit field", and "Table 3.8: Characteristic 
			Extended Properties bit field". Allowed values: "broadcast" "read" "write-without-response" 
			"write" "notify" "indicate" "authenticated-signed-writes" "reliable-write" 
			"writable-auxiliaries" "encrypt-read" "encrypt-write" "encrypt-authenticated-read" 
			"encrypt-authenticated-write" "secure-read" (Server only) "secure-write" 
			(Server only) 
     *
     * @return the property value.
     */
    public native String[] getFlags();








    /**
     * ReadValue:
     *
     *  Issues a request to read the value of the characteristic and returns 
			the value if the operation was successful. Possible options: "offset": uint16 
			offset "device": Object Device (Server only) Possible Errors: org.bluez.Error.Failed 
			org.bluez.Error.InProgress org.bluez.Error.NotPermitted org.bluez.Error.NotAuthorized 
			org.bluez.Error.NotSupported 
     */
    public native byte[] readValue() throws IOException;

    /**
     * WriteValue:
     *
     *  Issues a request to write the value of the characteristic. Possible 
			options: "offset": Start offset "device": Device path (Server only) Possible 
			Errors: org.bluez.Error.Failed org.bluez.Error.InProgress org.bluez.Error.NotPermitted 
			org.bluez.Error.InvalidValueLength org.bluez.Error.NotAuthorized org.bluez.Error.NotSupported 
     */
    public native void writeValue(byte [] value) throws IOException;

    /**
     * StartNotify:
     *
     *  Starts a notification session from this characteristic if it supports 
			value notifications or indications. Possible Errors: org.bluez.Error.Failed 
			org.bluez.Error.InProgress org.bluez.Error.NotSupported 
     */
    public native void startNotify() throws IOException;

    /**
     * StopNotify:
     *
     *  This method will cancel any previous StartNotify transaction. Note 
			that notifications from a characteristic are shared between sessions thus 
			calling StopNotify will release a single session. 
     */
    public native void stopNotify() throws IOException;

}
