/* Source generated by codegenj (https://github.com/olir/codegenj) - DO NOT EDIT!
 *
 * https://github.com/olir/codegenj
 *
 * This license does not apply to any contained documentation in the source!
 *
 * This generated output is free and unencumbered software released into the public domain.
 *
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to <http://unlicense.org>
 */
package org.bluez;

import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.Collections;
import de.serviceflow.codegenj.ObjectManager;
import de.serviceflow.codegenj.ObjectManager.DBusInterface;
import java.io.IOException;

/**
 * D-Bus JNI Interface class for org.bluez.Device1
 */  
public class Device1 extends DBusInterface {
    static {
        System.loadLibrary("bluezdbus"); // Load native library libbluezdbus.so at runtime
    }
 
    private Object _proxy;

    public Device1(Object proxy) {
    	_proxy = proxy;
    	_init();
    }

     public native void _init();
     
     public native void _destroy();
 
 
	static private	Map<String, org.bluez.GattService1> gattservice1Map = null;

    static public void addGattService1Object(String path, Object proxy) {
   			org.bluez.GattService1 n = new org.bluez.GattService1(proxy);
   			if (path==null)
   				path = ObjectManager.getInstance().getObjectPath(proxy);
    		gattservice1Map.put(path, n);
    		n.setObjectPath(path);
	}
	
    static public void removeGattService1Object(String path, Object proxy) {
   			if (path==null)
   				path = ObjectManager.getInstance().getObjectPath(proxy);
    		org.bluez.GattService1  n = gattservice1Map.get(path);
    		n._destroy();
    		gattservice1Map.remove(path);
	}
	
    static public void initializeGattService1Mapping() {
   		gattservice1Map = Collections.synchronizedMap(new HashMap<String, org.bluez.GattService1>());
    	if (false) {
			Object [] newProxies = ObjectManager.getInstance().getProxyObjects("org.bluez.GattService1", false);
	    	for (Object proxy : newProxies) {
	   			addGattService1Object(null, proxy);
	    	}
			System.out.println("*** gattservice1Map initialized, count="+(newProxies.length));
		}
    }

    public List<org.bluez.GattService1> getServices() {
    	if (!false) {
    		gattservice1Map.clear();
			Object [] newProxies = ObjectManager.getInstance().getProxyObjects("org.bluez.GattService1", false);
	    	for (Object proxy : newProxies) {
	   			addGattService1Object(null, proxy);
	    	}
			//System.out.println("*** gattservice1Map updated, count="+(newProxies.length));
		}

		List<org.bluez.GattService1> resultList = new ArrayList<org.bluez.GattService1>();
		String prefix = getObjectPath();
		if (prefix.length()>0 && prefix.charAt(prefix.length()-1)!='/') {
			prefix = prefix + '/';
		}
		//System.out.println(" ** gattservice1Map: searching at prefix="+prefix);
		for (Map.Entry<String, org.bluez.GattService1> entry : gattservice1Map.entrySet()) {
			String key = entry.getKey();
			// System.out.println("  * key="+key);
			if (key.startsWith(prefix)) {
				resultList.add(entry.getValue());
			}
		}
		return resultList;
    }

    


    /**
     * Reads property Address.
     *
     * The Bluetooth device address of the remote device. 
     *
     * @return the property value.
     */
    public native String getAddress();




    /**
     * Reads property Name.
     *
     * The Bluetooth remote name. This value can not be changed. Use the 
			Alias property instead. This value is only present for completeness. It is 
			better to always use the Alias property when displaying the devices name. 
			If the Alias property is unset, it will reflect this value which makes it 
			more convenient. 
     *
     * @return the property value.
     */
    public native String getName();




    /**
     * Reads property Icon.
     *
     * Proposed icon name according to the freedesktop.org icon naming specification. 
     *
     * @return the property value.
     */
    public native String getIcon();




    /**
     * Reads property Class.
     *
     * The Bluetooth class of device of the remote device. 
     *
     * @return the property value.
     */
    public native int getClassProperty();




    /**
     * Reads property Appearance.
     *
     * External appearance of device, as found on GAP service. 
     *
     * @return the property value.
     */
    public native short getAppearance();




    /**
     * Reads property UUIDs.
     *
     * List of 128-bit UUIDs that represents the available remote services. 
     *
     * @return the property value.
     */
    public native String[] getUUIDs();




    /**
     * Reads property Paired.
     *
     * Indicates if the remote device is paired. 
     *
     * @return the property value.
     */
    public native boolean getPaired();




    /**
     * Reads property Connected.
     *
     * Indicates if the remote device is currently connected. A PropertiesChanged 
			signal indicate changes to this status. 
     *
     * @return the property value.
     */
    public native boolean getConnected();




    /**
     * Reads property Trusted.
     *
     * Indicates if the remote is seen as trusted. This setting can be changed 
			by the application. 
     *
     * @return the property value.
     */
    public native boolean getTrusted();


    /**
     * Writes property Trusted.
     *
     * Indicates if the remote is seen as trusted. This setting can be changed 
			by the application. 
     *
     * @param Trusted the new value.
     */
    public native void setTrusted(boolean Trusted);



    /**
     * Reads property Blocked.
     *
     * If set to true any incoming connections from the device will be immediately 
			rejected. Any device drivers will also be removed and no new ones will be 
			probed as long as the device is blocked. 
     *
     * @return the property value.
     */
    public native boolean getBlocked();


    /**
     * Writes property Blocked.
     *
     * If set to true any incoming connections from the device will be immediately 
			rejected. Any device drivers will also be removed and no new ones will be 
			probed as long as the device is blocked. 
     *
     * @param Blocked the new value.
     */
    public native void setBlocked(boolean Blocked);



    /**
     * Reads property Alias.
     *
     * The name alias for the remote device. The alias can be used to have 
			a different friendly name for the remote device. In case no alias is set, 
			it will return the remote device name. Setting an empty string as alias will 
			convert it back to the remote device name. When resetting the alias with 
			an empty string, the property will default back to the remote name. 
     *
     * @return the property value.
     */
    public native String getAlias();


    /**
     * Writes property Alias.
     *
     * The name alias for the remote device. The alias can be used to have 
			a different friendly name for the remote device. In case no alias is set, 
			it will return the remote device name. Setting an empty string as alias will 
			convert it back to the remote device name. When resetting the alias with 
			an empty string, the property will default back to the remote name. 
     *
     * @param Alias the new value.
     */
    public native void setAlias(String Alias);


// property signature unsupported: Adapter



    /**
     * Reads property LegacyPairing.
     *
     * Set to true if the device only supports the pre-2.1 pairing mechanism. 
			This property is useful during device discovery to anticipate whether legacy 
			or simple pairing will occur if pairing is initiated. Note that this property 
			can exhibit false-positives in the case of Bluetooth 2.1 (or newer) devices 
			that have disabled Extended Inquiry Response support. 
     *
     * @return the property value.
     */
    public native boolean getLegacyPairing();




    /**
     * Reads property Modalias.
     *
     * Remote Device ID information in modalias format used by the kernel 
			and udev. 
     *
     * @return the property value.
     */
    public native String getModalias();




    /**
     * Reads property RSSI.
     *
     * Received Signal Strength Indicator of the remote device (inquiry or 
			advertising). 
     *
     * @return the property value.
     */
    public native short getRSSI();




    /**
     * Reads property ServicesResolved.
     *
     * Indicate whether or not service discovery has been resolved. 
     *
     * @return the property value.
     */
    public native boolean getServicesResolved();





    /**
     * Connect:
     *
     *  This is a generic method to connect any profiles the remote device 
			supports that can be connected to and have been flagged as auto-connectable 
			on our side. If only subset of profiles is already connected it will try 
			to connect currently disconnected ones. If at least one profile was connected 
			successfully this method will indicate success. Possible errors: org.bluez.Error.NotReady 
			org.bluez.Error.Failed org.bluez.Error.InProgress org.bluez.Error.AlreadyConnected 
     */
    public native void connect() throws IOException;

    /**
     * Disconnect:
     *
     *  This method gracefully disconnects all connected profiles and then 
			terminates low-level ACL connection. ACL connection will be terminated even 
			if some profiles were not disconnected properly e.g. due to misbehaving device. 
			This method can be also used to cancel a preceding Connect call before a 
			reply to it has been received. Possible errors: org.bluez.Error.NotConnected 
     */
    public native void disconnect() throws IOException;

    /**
     * ConnectProfile:
     *
     *  This method connects a specific profile of this device. The UUID provided 
			is the remote service UUID for the profile. Possible errors: org.bluez.Error.Failed 
			org.bluez.Error.InProgress org.bluez.Error.InvalidArguments org.bluez.Error.NotAvailable 
			org.bluez.Error.NotReady 
     */
    public native void connectProfile(String UUID) throws IOException;

    /**
     * DisconnectProfile:
     *
     *  This method disconnects a specific profile of this device. The profile 
			needs to be registered client profile. There is no connection tracking for 
			a profile, so as long as the profile is registered this will always succeed. 
			Possible errors: org.bluez.Error.Failed org.bluez.Error.InProgress org.bluez.Error.InvalidArguments 
			org.bluez.Error.NotSupported 
     */
    public native void disconnectProfile(String UUID) throws IOException;

    /**
     * Pair:
     *
     *  This method will connect to the remote device, initiate pairing and 
			then retrieve all SDP records (or GATT primary services). If the application 
			has registered its own agent, then that specific agent will be used. Otherwise 
			it will use the default agent. Only for applications like a pairing wizard 
			it would make sense to have its own agent. In almost all other cases the 
			default agent will handle this just fine. In case there is no application 
			agent and also no default agent present, this method will fail. Possible 
			errors: org.bluez.Error.InvalidArguments org.bluez.Error.Failed org.bluez.Error.AlreadyExists 
			org.bluez.Error.AuthenticationCanceled org.bluez.Error.AuthenticationFailed 
			org.bluez.Error.AuthenticationRejected org.bluez.Error.AuthenticationTimeout 
			org.bluez.Error.ConnectionAttemptFailed 
     */
    public native void pair() throws IOException;

    /**
     * CancelPairing:
     *
     *  This method can be used to cancel a pairing operation initiated by 
			the Pair method. Possible errors: org.bluez.Error.DoesNotExist org.bluez.Error.Failed 
     */
    public native void cancelPairing() throws IOException;

}
