/* Source generated by codegenj (https://github.com/olir/codegenj) - DO NOT EDIT!
 *
 * https://github.com/olir/codegenj
 *
 * This license does not apply to any contained documentation in the source!
 *
 * This generated output is free and unencumbered software released into the public domain.
 *
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to <http://unlicense.org>
 */
package org.bluez;

import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.Collections;
import de.serviceflow.codegenj.ObjectManager;
import de.serviceflow.codegenj.ObjectManager.DBusInterface;
import java.io.IOException;

/**
 * D-Bus JNI Interface class for org.bluez.Adapter1
 */  
public class Adapter1 extends DBusInterface {
    static {
        System.loadLibrary("bluezdbus"); // Load native library libbluezdbus.so at runtime
    }
 
    private Object _proxy;

    public Adapter1(Object proxy) {
    	_proxy = proxy;
    	_init();
    }

     public native void _init();
     
     public native void _destroy();
 
 
	static private	Map<String, org.bluez.Device1> device1Map = null;

    static public void addDevice1Object(String path, Object proxy) {
   			org.bluez.Device1 n = new org.bluez.Device1(proxy);
   			if (path==null)
   				path = ObjectManager.getInstance().getObjectPath(proxy);
    		device1Map.put(path, n);
    		n.setObjectPath(path);
	}
	
    static public void removeDevice1Object(String path, Object proxy) {
   			if (path==null)
   				path = ObjectManager.getInstance().getObjectPath(proxy);
    		org.bluez.Device1  n = device1Map.get(path);
    		n._destroy();
    		device1Map.remove(path);
	}
	
    static public void initializeDevice1Mapping() {
   		device1Map = Collections.synchronizedMap(new HashMap<String, org.bluez.Device1>());
    	if (true) {
			Object [] newProxies = ObjectManager.getInstance().getProxyObjects("org.bluez.Device1", true);
	    	for (Object proxy : newProxies) {
	   			addDevice1Object(null, proxy);
	    	}
			System.out.println("*** device1Map initialized, count="+(newProxies.length));
		}
    }

    public List<org.bluez.Device1> getDevices() {
    	if (!true) {
    		device1Map.clear();
			Object [] newProxies = ObjectManager.getInstance().getProxyObjects("org.bluez.Device1", true);
	    	for (Object proxy : newProxies) {
	   			addDevice1Object(null, proxy);
	    	}
			//System.out.println("*** device1Map updated, count="+(newProxies.length));
		}

		List<org.bluez.Device1> resultList = new ArrayList<org.bluez.Device1>();
		String prefix = getObjectPath();
		if (prefix.length()>0 && prefix.charAt(prefix.length()-1)!='/') {
			prefix = prefix + '/';
		}
		//System.out.println(" ** device1Map: searching at prefix="+prefix);
		for (Map.Entry<String, org.bluez.Device1> entry : device1Map.entrySet()) {
			String key = entry.getKey();
			// System.out.println("  * key="+key);
			if (key.startsWith(prefix)) {
				resultList.add(entry.getValue());
			}
		}
		return resultList;
    }

    


    /**
     * Reads property Address.
     *
     * The Bluetooth device address. 
     *
     * @return the property value.
     */
    public native String getAddress();




    /**
     * Reads property Name.
     *
     * The Bluetooth system name (pretty hostname). This property is either 
			a static system default or controlled by an external daemon providing access 
			to the pretty hostname configuration. 
     *
     * @return the property value.
     */
    public native String getName();




    /**
     * Reads property Alias.
     *
     * The Bluetooth friendly name. This value can be changed. In case no 
			alias is set, it will return the system provided name. Setting an empty string 
			as alias will convert it back to the system provided name. When resetting 
			the alias with an empty string, the property will default back to system 
			name. On a well configured system, this property never needs to be changed 
			since it defaults to the system name and provides the pretty hostname. Only 
			if the local name needs to be different from the pretty hostname, this property 
			should be used as last resort. 
     *
     * @return the property value.
     */
    public native String getAlias();


    /**
     * Writes property Alias.
     *
     * The Bluetooth friendly name. This value can be changed. In case no 
			alias is set, it will return the system provided name. Setting an empty string 
			as alias will convert it back to the system provided name. When resetting 
			the alias with an empty string, the property will default back to system 
			name. On a well configured system, this property never needs to be changed 
			since it defaults to the system name and provides the pretty hostname. Only 
			if the local name needs to be different from the pretty hostname, this property 
			should be used as last resort. 
     *
     * @param Alias the new value.
     */
    public native void setAlias(String Alias);



    /**
     * Reads property Class.
     *
     * The Bluetooth class of device. This property represents the value 
			that is either automatically configured by DMI/ACPI information or provided 
			as static configuration. 
     *
     * @return the property value.
     */
    public native int getClassProperty();




    /**
     * Reads property Powered.
     *
     * Switch an adapter on or off. This will also set the appropriate connectable 
			state of the controller. The value of this property is not persistent. After 
			restart or unplugging of the adapter it will reset back to false. 
     *
     * @return the property value.
     */
    public native boolean getPowered();


    /**
     * Writes property Powered.
     *
     * Switch an adapter on or off. This will also set the appropriate connectable 
			state of the controller. The value of this property is not persistent. After 
			restart or unplugging of the adapter it will reset back to false. 
     *
     * @param Powered the new value.
     */
    public native void setPowered(boolean Powered);



    /**
     * Reads property Discoverable.
     *
     * Switch an adapter to discoverable or non-discoverable to either make 
			it visible or hide it. This is a global setting and should only be used by 
			the settings application. If the DiscoverableTimeout is set to a non-zero 
			value then the system will set this value back to false after the timer expired. 
			In case the adapter is switched off, setting this value will fail. When changing 
			the Powered property the new state of this property will be updated via a 
			PropertiesChanged signal. For any new adapter this settings defaults to false. 
     *
     * @return the property value.
     */
    public native boolean getDiscoverable();


    /**
     * Writes property Discoverable.
     *
     * Switch an adapter to discoverable or non-discoverable to either make 
			it visible or hide it. This is a global setting and should only be used by 
			the settings application. If the DiscoverableTimeout is set to a non-zero 
			value then the system will set this value back to false after the timer expired. 
			In case the adapter is switched off, setting this value will fail. When changing 
			the Powered property the new state of this property will be updated via a 
			PropertiesChanged signal. For any new adapter this settings defaults to false. 
     *
     * @param Discoverable the new value.
     */
    public native void setDiscoverable(boolean Discoverable);



    /**
     * Reads property Pairable.
     *
     * Switch an adapter to pairable or non-pairable. This is a global setting 
			and should only be used by the settings application. Note that this property 
			only affects incoming pairing requests. For any new adapter this settings 
			defaults to true. 
     *
     * @return the property value.
     */
    public native boolean getPairable();


    /**
     * Writes property Pairable.
     *
     * Switch an adapter to pairable or non-pairable. This is a global setting 
			and should only be used by the settings application. Note that this property 
			only affects incoming pairing requests. For any new adapter this settings 
			defaults to true. 
     *
     * @param Pairable the new value.
     */
    public native void setPairable(boolean Pairable);



    /**
     * Reads property PairableTimeout.
     *
     * The pairable timeout in seconds. A value of zero means that the timeout 
			is disabled and it will stay in pairable mode forever. The default value 
			for pairable timeout should be disabled (value 0). 
     *
     * @return the property value.
     */
    public native int getPairableTimeout();


    /**
     * Writes property PairableTimeout.
     *
     * The pairable timeout in seconds. A value of zero means that the timeout 
			is disabled and it will stay in pairable mode forever. The default value 
			for pairable timeout should be disabled (value 0). 
     *
     * @param PairableTimeout the new value.
     */
    public native void setPairableTimeout(int PairableTimeout);



    /**
     * Reads property DiscoverableTimeout.
     *
     * The discoverable timeout in seconds. A value of zero means that the 
			timeout is disabled and it will stay in discoverable/limited mode forever. 
			The default value for the discoverable timeout should be 180 seconds (3 minutes). 
     *
     * @return the property value.
     */
    public native int getDiscoverableTimeout();


    /**
     * Writes property DiscoverableTimeout.
     *
     * The discoverable timeout in seconds. A value of zero means that the 
			timeout is disabled and it will stay in discoverable/limited mode forever. 
			The default value for the discoverable timeout should be 180 seconds (3 minutes). 
     *
     * @param DiscoverableTimeout the new value.
     */
    public native void setDiscoverableTimeout(int DiscoverableTimeout);



    /**
     * Reads property Discovering.
     *
     * Indicates that a device discovery procedure is active. 
     *
     * @return the property value.
     */
    public native boolean getDiscovering();




    /**
     * Reads property UUIDs.
     *
     * List of 128-bit UUIDs that represents the available local services. 
     *
     * @return the property value.
     */
    public native String[] getUUIDs();




    /**
     * Reads property Modalias.
     *
     * Local Device ID information in modalias format used by the kernel 
			and udev. 
     *
     * @return the property value.
     */
    public native String getModalias();





    /**
     * StartDiscovery:
     *
     *  This method starts the device discovery session. This includes an 
			inquiry procedure and remote device name resolving. Use StopDiscovery to 
			release the sessions acquired. This process will start creating Device objects 
			as new devices are discovered. During discovery RSSI delta-threshold is imposed. 
			Possible errors: org.bluez.Error.NotReady org.bluez.Error.Failed 
     */
    public native void startDiscovery() throws IOException;

    /**
     * StopDiscovery:
     *
     *  This method will cancel any previous StartDiscovery transaction. Note 
			that a discovery procedure is shared between all discovery sessions thus 
			calling StopDiscovery will only release a single session. Possible errors: 
			org.bluez.Error.NotReady org.bluez.Error.Failed org.bluez.Error.NotAuthorized 
     */
    public native void stopDiscovery() throws IOException;

    /**
     * RemoveDevice:
     *
     *  This removes the remote device object at the given path. It will remove 
			also the pairing information. Possible errors: org.bluez.Error.InvalidArguments 
			org.bluez.Error.Failed 
     */
    public native void removeDevice(Object device) throws IOException;
// Method signature unsupported: SetDiscoveryFilter
}
