/*
 * Decompiled with CFR 0.152.
 */
package de.serviceflow.codegenj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TemplateParser {
    public static final String BLOCK_TOKEN = "###";
    public static final String EOF_TOKEN = null;
    public static final String EOL_TOKEN = "\n";
    private final String path;
    private BufferedReader r;
    private int lineno = 0;
    private boolean returnBlockToken = false;
    private String[] bufferedTokens = null;
    private int bufferedTokensPointer = 0;

    public TemplateParser(String path) {
        this.path = path;
    }

    public void open() {
        InputStream tis = this.getClass().getResourceAsStream("/" + this.path);
        this.r = new BufferedReader(new InputStreamReader(tis));
    }

    public String readNext() {
        try {
            if (this.bufferedTokens == null || this.bufferedTokensPointer > this.bufferedTokens.length) {
                String strLine = this.r.readLine();
                if (strLine != null) {
                    ++this.lineno;
                    this.returnBlockToken = false;
                    this.bufferedTokens = strLine.split(BLOCK_TOKEN);
                    this.bufferedTokensPointer = 0;
                } else {
                    return EOF_TOKEN;
                }
            }
            if (this.bufferedTokensPointer < this.bufferedTokens.length) {
                if (this.returnBlockToken) {
                    this.returnBlockToken = !this.returnBlockToken;
                    return BLOCK_TOKEN;
                }
                if (this.bufferedTokensPointer + 1 < this.bufferedTokens.length) {
                    this.returnBlockToken = !this.returnBlockToken;
                }
                return this.bufferedTokens[this.bufferedTokensPointer++];
            }
            if (this.returnBlockToken) {
                this.returnBlockToken = !this.returnBlockToken;
                return BLOCK_TOKEN;
            }
            ++this.bufferedTokensPointer;
            return EOL_TOKEN;
        }
        catch (IOException e) {
            throw new Error("Internal error", e);
        }
    }

    public void close() {
        try {
            this.r.close();
        }
        catch (IOException e) {
            throw new Error("Internal error", e);
        }
    }

    public String location() {
        return this.path + ":" + this.lineno;
    }

    public String getTemplatePath() {
        return this.path;
    }
}

