/*
 * Decompiled with CFR 0.152.
 */
package de.serviceflow.codegenj;

import de.serviceflow.codegenj.Node;
import de.serviceflow.codegenj.TemplateBlock;
import de.serviceflow.codegenj.TemplateParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Map;

public class ObjectManagerGenerator {
    public static final String OM_INAME = "de.serviceflow.codegenj.ObjectManager";
    private final Node nodeDef;
    private final String destination;
    private final Map<String, String> parameters;
    private String fileBaseName = null;

    public ObjectManagerGenerator(Node nodeDef, Map<String, String> parameters, String destination) {
        this.nodeDef = nodeDef;
        this.parameters = parameters;
        this.destination = destination;
    }

    public void open() {
        this.fileBaseName = "ObjectManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        PrintWriter w;
        String ppath = this.packagePath();
        String dir = this.destination + "/generated";
        new File(dir + '/' + ppath).mkdirs();
        String jnidir = this.destination + "/jni";
        new File(jnidir).mkdirs();
        String jnihdir = jnidir + "/include";
        new File(jnihdir).mkdirs();
        TemplateParser t = new TemplateParser("template/ObjectManager_c.txt");
        t.open();
        try {
            w = new PrintWriter(new FileOutputStream(jnidir + "/" + this.fileBaseName + ".c"));
        }
        catch (FileNotFoundException e) {
            throw new Error("Can't create output file: " + e.getLocalizedMessage());
        }
        try {
            new TemplateBlock(this.nodeDef, this.parameters, t, w).process();
        }
        finally {
            w.close();
        }
        t.close();
        t = new TemplateParser("template/ObjectManager_java.txt");
        t.open();
        try {
            w = new PrintWriter(new FileOutputStream(dir + "/" + ppath + this.fileBaseName + ".java"));
        }
        catch (FileNotFoundException e) {
            throw new Error("Can't create output file: " + e.getLocalizedMessage());
        }
        this.parameters.put("classname", OM_INAME);
        try {
            new TemplateBlock(this.nodeDef, this.parameters, t, w).process();
        }
        finally {
            w.close();
        }
        t.close();
        this.parameters.remove("classname");
    }

    private String packagePath() {
        String pname = OM_INAME.substring(0, OM_INAME.lastIndexOf(46));
        if (pname == null) {
            return "";
        }
        StringBuffer packagePath = new StringBuffer();
        int fromIndex = 0;
        int index = pname.indexOf(46, fromIndex);
        while (index >= 0) {
            packagePath.append(pname.substring(fromIndex, index));
            packagePath.append('/');
            fromIndex = index + 1;
            index = pname.indexOf(46, fromIndex);
        }
        packagePath.append(pname.substring(fromIndex));
        packagePath.append('/');
        return packagePath.toString();
    }

    public void close() {
    }
}

