/*
 * Decompiled with CFR 0.152.
 */
package de.serviceflow.codegenj;

import de.serviceflow.codegenj.CaseBlock;
import de.serviceflow.codegenj.ForBlock;
import de.serviceflow.codegenj.ProcessingObjective;
import de.serviceflow.codegenj.TemplateBlockParser;
import de.serviceflow.codegenj.TemplateParser;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

public abstract class Block {
    private final String blockname;
    private final ProcessingObjective context;
    private final Map<String, String> parameters;
    private TemplateParser t;
    private PrintWriter w;

    protected Block(String blockname, ProcessingObjective context, Map<String, String> parameters, TemplateParser t, PrintWriter w) {
        this.blockname = blockname;
        this.context = context;
        this.parameters = parameters;
        this.t = t;
        this.w = w;
    }

    public boolean process() {
        return this.process(false);
    }

    public String process(String content) {
        System.out.println("**** process start " + content.substring(0, Math.min(15, content.length())) + "...");
        StringWriter sw = new StringWriter();
        PrintWriter w2 = new PrintWriter(sw);
        PrintWriter parentWriter = this.w;
        this.setWriter(w2);
        TemplateParser parentParser = this.t;
        this.t = new TemplateBlockParser(parentParser, content);
        this.t.open();
        boolean valid = this.process(false);
        this.t.close();
        w2.close();
        this.w = parentWriter;
        this.t = parentParser;
        return this.parameterSubstitution(sw.toString());
    }

    public boolean process(boolean cachemode) {
        String token;
        System.out.println("*** process start " + this.blockname + " " + cachemode);
        boolean inBlockSyntax = false;
        int cachedBlockLevel = 0;
        while ((token = this.t.readNext()) != TemplateParser.EOF_TOKEN) {
            if (token == "\n") {
                this.w.println("");
                continue;
            }
            if (token == "###") {
                inBlockSyntax = !inBlockSyntax;
                continue;
            }
            if (inBlockSyntax) {
                boolean bl = inBlockSyntax = !inBlockSyntax;
                if ("end".equals(token)) {
                    if (--cachedBlockLevel < 0) break;
                    this.w.print("###");
                    this.w.print(token);
                    this.w.print("###");
                    continue;
                }
                if (cachemode) {
                    ++cachedBlockLevel;
                    this.w.print("###");
                    this.w.print(token);
                    this.w.print("###");
                    continue;
                }
                String[] args = token.split("\\s+");
                if (args.length < 1) {
                    throw new Error("Block Command with no args at " + this.t.location() + ": '" + token + "'");
                }
                String blockType = args[0];
                if ("for".equals(blockType)) {
                    if (args.length != 2) {
                        throw new Error("for block argument invalid: '" + token + "' at " + this.t.location());
                    }
                    if (new ForBlock(this.getContext(), this.parameters, this.t, this.w, args[1]).process(true)) continue;
                    throw new Error("Unexpected EOF in child block," + this.t.location());
                }
                if ("case".equals(blockType)) {
                    if (args.length != 2) {
                        throw new Error("case block argument invalid: '" + token + "' at " + this.t.location());
                    }
                    if (new CaseBlock(this.getContext(), this.parameters, this.t, this.w, args[1]).process(true)) continue;
                    throw new Error("Unexpected EOF in child block," + this.t.location());
                }
                throw new Error("Block type unknown: '" + blockType + "' at " + this.t.location());
            }
            this.printResult(token);
        }
        System.out.println("*** process end " + this.blockname + " " + cachemode);
        return token != TemplateParser.EOF_TOKEN;
    }

    protected void printResult(String token) {
        this.w.print(token);
    }

    public String getBlockname() {
        return this.blockname;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public TemplateParser getTemplate() {
        return this.t;
    }

    public PrintWriter getWriter() {
        return this.w;
    }

    protected void setWriter(PrintWriter w) {
        this.w = w;
    }

    protected String parameterSubstitution(String subject) {
        StringBuffer buffer = new StringBuffer();
        String[] parts = subject.split("\\$\\$\\$");
        boolean inParameterSyntax = false;
        if (parts != null) {
            for (String p : parts) {
                if (inParameterSyntax) {
                    String value = this.parameters.get(p);
                    if (value == null) {
                        buffer.append("$$$" + p + "$$$");
                    } else {
                        buffer.append(value);
                    }
                } else {
                    buffer.append(p);
                }
                inParameterSyntax = !inParameterSyntax;
            }
        }
        return buffer.toString();
    }

    public ProcessingObjective getContext() {
        return this.context;
    }
}

