/*
 * Decompiled with CFR 0.152.
 */
package de.sematre.dsbmobile;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sematre.dsbmobile.utils.Base64;
import de.sematre.dsbmobile.utils.GZIP;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;

public class DSBMobile
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5265820858352981519L;
    private static final Gson gson = new Gson();
    private HashMap<String, Object> args = new HashMap();

    public DSBMobile(String username, String password) {
        this.args.put("UserId", username);
        this.args.put("UserPw", password);
        this.args.put("Language", "de");
        this.args.put("Device", "Nexus 4");
        this.args.put("AppId", UUID.randomUUID().toString());
        this.args.put("AppVersion", "2.5.9");
        this.args.put("OsVersion", "27 8.1.0");
        this.args.put("PushId", "");
        this.args.put("BundleId", "de.heinekingmedia.dsbmobile");
    }

    public ArrayList<TimeTable> getTimeTables() {
        JsonObject mainObject = this.pullData();
        int resultCode = mainObject.get("Resultcode").getAsInt();
        if (resultCode != 0) {
            throw new RuntimeException("Server returned result code is " + resultCode + ": " + mainObject.get("ResultStatusInfo").getAsString());
        }
        JsonObject contentObject = this.findJsonObjectByTitle(mainObject.get("ResultMenuItems").getAsJsonArray(), "Inhalte");
        Objects.requireNonNull(contentObject, "Server response doesn't contain content!");
        JsonObject tableObject = this.findJsonObjectByTitle(contentObject.get("Childs").getAsJsonArray(), "Pl\u00e4ne");
        Objects.requireNonNull(tableObject, "Server response doesn't contain a table!");
        ArrayList<TimeTable> tables = new ArrayList<TimeTable>();
        for (JsonElement jElement : tableObject.get("Root").getAsJsonObject().get("Childs").getAsJsonArray()) {
            if (!jElement.isJsonObject()) continue;
            JsonObject jObject = jElement.getAsJsonObject();
            UUID uuid = UUID.fromString(jObject.get("Id").getAsString());
            String groupName = jObject.get("Title").getAsString();
            String date = jObject.get("Date").getAsString();
            for (JsonElement jElementChild : jObject.get("Childs").getAsJsonArray()) {
                if (!jElementChild.isJsonObject()) continue;
                JsonObject childObject = jElementChild.getAsJsonObject();
                String title = childObject.get("Title").getAsString();
                String detail = childObject.get("Detail").getAsString();
                tables.add(new TimeTable(uuid, groupName, date, title, detail));
            }
        }
        return tables;
    }

    public ArrayList<News> getNews() {
        JsonObject mainObject = this.pullData();
        int resultCode = mainObject.get("Resultcode").getAsInt();
        if (resultCode != 0) {
            throw new RuntimeException("Server returned result code is " + resultCode + ": " + mainObject.get("ResultStatusInfo").getAsString());
        }
        JsonObject contentObject = this.findJsonObjectByTitle(mainObject.get("ResultMenuItems").getAsJsonArray(), "Inhalte");
        Objects.requireNonNull(contentObject, "Server response doesn't contain content!");
        JsonObject tableObject = this.findJsonObjectByTitle(contentObject.get("Childs").getAsJsonArray(), "News");
        Objects.requireNonNull(tableObject, "Server response doesn't contain news!");
        ArrayList<News> news = new ArrayList<News>();
        for (JsonElement jElement : tableObject.get("Root").getAsJsonObject().get("Childs").getAsJsonArray()) {
            if (!jElement.isJsonObject()) continue;
            JsonObject jObject = jElement.getAsJsonObject();
            UUID uuid = UUID.fromString(jObject.get("Id").getAsString());
            String date = jObject.get("Date").getAsString();
            String title = jObject.get("Title").getAsString();
            String detail = jObject.get("Detail").getAsString();
            news.add(new News(uuid, date, title, detail));
        }
        return news;
    }

    public JsonObject pullData() {
        try {
            int c;
            HttpsURLConnection connection = (HttpsURLConnection)new URL("https://www.dsbmobile.de/JsonHandler.ashx/GetData").openConnection();
            connection.setRequestMethod("POST");
            connection.addRequestProperty("User-Agent", "Dalvik/2.1.0 (Linux; U; Android 8.1.0; Nexus 4 Build/OPM7.181205.001)");
            connection.addRequestProperty("Accept-Encoding", "gzip, deflate");
            connection.addRequestProperty("Content-Type", "application/json;charset=utf-8");
            connection.setDoOutput(true);
            connection.getOutputStream().write(this.packageArgs().getBytes("UTF-8"));
            StringBuilder builder = new StringBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            while ((c = ((Reader)in).read()) >= 0) {
                builder.append((char)c);
            }
            return (JsonObject)gson.fromJson(GZIP.decompress(Base64.decode(((JsonObject)gson.fromJson(builder.toString(), JsonObject.class)).get("d").getAsString())), JsonObject.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to pull data from server!", e);
        }
    }

    private String packageArgs() throws IOException {
        String date = this.getFormattedTime(new Date());
        this.args.put("Date", date);
        this.args.put("LastUpdate", date);
        HashMap<String, Object> innerArgs = new HashMap<String, Object>();
        innerArgs.put("Data", Base64.encode(GZIP.compress(this.unescapeString(gson.toJson(this.args)))));
        innerArgs.put("DataType", 1);
        HashMap<String, HashMap<String, Object>> outerArgs = new HashMap<String, HashMap<String, Object>>();
        outerArgs.put("req", innerArgs);
        return this.unescapeString(gson.toJson(outerArgs));
    }

    private JsonObject findJsonObjectByTitle(JsonArray sourceArray, String title) {
        for (JsonElement jElement : sourceArray) {
            String objectTitle;
            JsonObject jObject;
            if (!jElement.isJsonObject() || !(jObject = jElement.getAsJsonObject()).has("Title") || !(objectTitle = jObject.get("Title").getAsString()).equalsIgnoreCase(title)) continue;
            return jObject;
        }
        return null;
    }

    private String getFormattedTime(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ENGLISH).format(date);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String unescapeString(String text) {
        StringBuilder builder = new StringBuilder(text.length());
        int i = 0;
        while (true) {
            block18: {
                int ch;
                block16: {
                    char nextChar;
                    block17: {
                        if (i >= text.length()) {
                            return builder.toString();
                        }
                        ch = text.charAt(i);
                        if (ch != 92) break block16;
                        char c = nextChar = i == text.length() - 1 ? (char)'\\' : (char)text.charAt(i + 1);
                        if (nextChar < 48 || nextChar > 55) break block17;
                        String code = "" + nextChar;
                        if (++i < text.length() - 1 && text.charAt(i + 1) >= '0' && text.charAt(i + 1) <= '7') {
                            code = code + text.charAt(i + 1);
                            if (++i < text.length() - 1 && text.charAt(i + 1) >= '0' && text.charAt(i + 1) <= '7') {
                                code = code + text.charAt(i + 1);
                                ++i;
                            }
                        }
                        builder.append((char)Integer.parseInt(code, 8));
                        break block18;
                    }
                    switch (nextChar) {
                        case '\\': {
                            ch = 92;
                            break;
                        }
                        case 'b': {
                            ch = 8;
                            break;
                        }
                        case 'f': {
                            ch = 12;
                            break;
                        }
                        case 'n': {
                            ch = 10;
                            break;
                        }
                        case 'r': {
                            ch = 13;
                            break;
                        }
                        case 't': {
                            ch = 9;
                            break;
                        }
                        case '\"': {
                            ch = 34;
                            break;
                        }
                        case '\'': {
                            ch = 39;
                            break;
                        }
                        case 'u': {
                            if (i >= text.length() - 5) {
                                ch = 117;
                                break;
                            }
                            int code = Integer.parseInt("" + text.charAt(i + 2) + text.charAt(i + 3) + text.charAt(i + 4) + text.charAt(i + 5), 16);
                            builder.append(Character.toChars(code));
                            i += 5;
                            break block18;
                        }
                    }
                    ++i;
                }
                builder.append((char)ch);
            }
            ++i;
        }
    }

    public class News
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 2336407351548626614L;
        private UUID uuid = null;
        private String date = "";
        private String title = "";
        private String detail = "";

        public News(UUID uuid, String date, String title, String detail) {
            this.uuid = uuid;
            this.date = date;
            this.title = title;
            this.detail = detail;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public void setUUID(UUID uuid) {
            this.uuid = uuid;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            News other = (News)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
                return false;
            }
            if (this.detail == null ? other.detail != null : !this.detail.equals(other.detail)) {
                return false;
            }
            if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
                return false;
            }
            return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
        }

        private DSBMobile getEnclosingInstance() {
            return DSBMobile.this;
        }

        public String toString() {
            return "{\"uuid\": \"" + this.uuid + "\", \"date\": \"" + this.date + "\", \"title\": \"" + this.title + "\", \"detail\": \"" + this.detail + "\"}";
        }
    }

    public class TimeTable
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 553852884423090700L;
        private UUID uuid = null;
        private String groupName = "";
        private String date = "";
        private String title = "";
        private String detail = "";

        public TimeTable(UUID uuid, String groupName, String date, String title, String detail) {
            this.uuid = uuid;
            this.groupName = groupName;
            this.date = date;
            this.title = title;
            this.detail = detail;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public void setUUID(UUID uuid) {
            this.uuid = uuid;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeTable other = (TimeTable)obj;
            if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
                return false;
            }
            if (this.detail == null ? other.detail != null : !this.detail.equals(other.detail)) {
                return false;
            }
            if (this.groupName == null ? other.groupName != null : !this.groupName.equals(other.groupName)) {
                return false;
            }
            if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
                return false;
            }
            return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
        }

        public String toString() {
            return "{\"uuid\": \"" + this.uuid + "\", \"groupName\": \"" + this.groupName + "\", \"date\": \"" + this.date + "\", \"title\": \"" + this.title + "\", \"detail\": \"" + this.detail + "\"}";
        }
    }
}

