/*
 * Decompiled with CFR 0.152.
 */
package de.sematre.dsbmobile;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;

public class DSBMobile
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5265820858352981519L;
    private static final Gson gson = new Gson();
    private HashMap<String, Object> args = new HashMap();

    public DSBMobile(String username, String password) {
        this.args.put("UserId", username);
        this.args.put("UserPw", password);
        this.args.put("AppId", UUID.randomUUID().toString());
        this.args.put("AppVersion", "2.3");
        this.args.put("Language", "de");
        this.args.put("OsVersion", "");
        this.args.put("AppVersion", "");
        this.args.put("Device", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0");
        this.args.put("PushId", "");
        this.args.put("BundleId", "de.heinekingmedia.dsbmobile");
    }

    public ArrayList<TimeTable> getTimeTables() {
        try {
            JsonObject mainObject = this.findJsonObjectByTitle(this.pullData().get("ResultMenuItems").getAsJsonArray(), "Inhalte");
            Objects.requireNonNull(mainObject, "Server response doesn't contain content!");
            JsonObject jObject = this.findJsonObjectByTitle(mainObject.get("Childs").getAsJsonArray(), "Pl\u00e4ne");
            Objects.requireNonNull(jObject, "Server response doesn't contain a time table!");
            ArrayList<TimeTable> tables = new ArrayList<TimeTable>();
            for (JsonElement jElement : jObject.get("Root").getAsJsonObject().get("Childs").getAsJsonArray()) {
                for (JsonElement jElementChild : jElement.getAsJsonObject().get("Childs").getAsJsonArray()) {
                    tables.add(new TimeTable(jElementChild.getAsJsonObject()));
                }
            }
            return tables;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to pull data from server!", e);
        }
    }

    @Deprecated
    public ArrayList<News> getNews() {
        throw new UnsupportedOperationException("Not implemented, yet!");
    }

    public JsonObject pullData() throws IOException {
        int c;
        HttpsURLConnection connection = (HttpsURLConnection)new URL("https://www.dsbmobile.de/JsonHandler.ashx/GetData").openConnection();
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "*/*");
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0");
        connection.addRequestProperty("Content-Type", "application/json;charset=utf-8");
        connection.addRequestProperty("Bundle_ID", "de.heinekingmedia.inhouse.dsbmobile.web");
        connection.addRequestProperty("Referer", "https://www.dsbmobile.de/default.aspx");
        connection.setDoOutput(true);
        connection.getOutputStream().write(this.packageArgs().getBytes("UTF-8"));
        StringBuilder builder = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
        while ((c = ((Reader)in).read()) >= 0) {
            builder.append((char)c);
        }
        return (JsonObject)gson.fromJson(this.decompressGZIP(Base64.decode(((JsonObject)gson.fromJson(builder.toString(), JsonObject.class)).get("d").getAsString())), JsonObject.class);
    }

    private String packageArgs() throws IOException {
        String date = this.getJavascriptTime(new Date());
        this.args.put("Date", date);
        this.args.put("LastUpdate", date);
        HashMap<String, Object> innerArgs = new HashMap<String, Object>();
        innerArgs.put("Data", Base64.encode(this.compressGZIP(this.unescapeString(gson.toJson(this.args)))));
        innerArgs.put("DataType", 1);
        HashMap<String, HashMap<String, Object>> outerArgs = new HashMap<String, HashMap<String, Object>>();
        outerArgs.put("req", innerArgs);
        return this.unescapeString(gson.toJson(outerArgs));
    }

    private JsonObject findJsonObjectByTitle(JsonArray sourceArray, String title) {
        for (JsonElement jElement : sourceArray) {
            String objectTitle;
            JsonObject jObject;
            if (!jElement.isJsonObject() || !(jObject = jElement.getAsJsonObject()).has("Title") || !(objectTitle = jObject.get("Title").getAsString()).equalsIgnoreCase(title)) continue;
            return jObject;
        }
        return null;
    }

    private String getJavascriptTime(Date date) {
        return new SimpleDateFormat("E MMM dd yyyy HH:mm:ss Z", Locale.ENGLISH).format(date);
    }

    private byte[] compressGZIP(String data) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length());
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
        gzipOutputStream.write(data.getBytes("UTF-8"));
        gzipOutputStream.close();
        return outputStream.toByteArray();
    }

    private String decompressGZIP(byte[] data) throws IOException {
        int len;
        GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(data));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(inputStream.available());
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
        }
        outputStream.close();
        byte[] bytes = outputStream.toByteArray();
        return new String(bytes, "UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     */
    private String unescapeString(String text) {
        StringBuilder builder = new StringBuilder(text.length());
        int i = 0;
        while (true) {
            block18: {
                int ch;
                block16: {
                    char nextChar;
                    block17: {
                        if (i >= text.length()) {
                            return builder.toString();
                        }
                        ch = text.charAt(i);
                        if (ch != 92) break block16;
                        char c = nextChar = i == text.length() - 1 ? (char)'\\' : (char)text.charAt(i + 1);
                        if (nextChar < 48 || nextChar > 55) break block17;
                        String code = "" + nextChar;
                        if (++i < text.length() - 1 && text.charAt(i + 1) >= '0' && text.charAt(i + 1) <= '7') {
                            code = code + text.charAt(i + 1);
                            if (++i < text.length() - 1 && text.charAt(i + 1) >= '0' && text.charAt(i + 1) <= '7') {
                                code = code + text.charAt(i + 1);
                                ++i;
                            }
                        }
                        builder.append((char)Integer.parseInt(code, 8));
                        break block18;
                    }
                    switch (nextChar) {
                        case '\\': {
                            ch = 92;
                            break;
                        }
                        case 'b': {
                            ch = 8;
                            break;
                        }
                        case 'f': {
                            ch = 12;
                            break;
                        }
                        case 'n': {
                            ch = 10;
                            break;
                        }
                        case 'r': {
                            ch = 13;
                            break;
                        }
                        case 't': {
                            ch = 9;
                            break;
                        }
                        case '\"': {
                            ch = 34;
                            break;
                        }
                        case '\'': {
                            ch = 39;
                            break;
                        }
                        case 'u': {
                            if (i >= text.length() - 5) {
                                ch = 117;
                                break;
                            }
                            int code = Integer.parseInt("" + text.charAt(i + 2) + text.charAt(i + 3) + text.charAt(i + 4) + text.charAt(i + 5), 16);
                            builder.append(Character.toChars(code));
                            i += 5;
                            break block18;
                        }
                    }
                    ++i;
                }
                builder.append((char)ch);
            }
            ++i;
        }
    }

    private static class Base64 {
        private static final char[] TABLE_ENCODE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        private static final int[] TABLE_DECODE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

        private Base64() {
        }

        public static String encode(byte[] data) {
            StringBuilder builder = new StringBuilder();
            int padding = 0;
            for (int index = 0; index < data.length; index += 3) {
                int b = (data[index] & 0xFF) << 16 & 0xFFFFFF;
                if (index + 1 < data.length) {
                    b |= (data[index + 1] & 0xFF) << 8;
                } else {
                    ++padding;
                }
                if (index + 2 < data.length) {
                    b |= data[index + 2] & 0xFF;
                } else {
                    ++padding;
                }
                for (int k = 0; k < 4 - padding; ++k) {
                    int c = (b & 0xFC0000) >> 18;
                    builder.append(TABLE_ENCODE[c]);
                    b <<= 6;
                }
            }
            for (int i = 0; i < padding; ++i) {
                builder.append("=");
            }
            return builder.toString();
        }

        public static byte[] decode(String data) {
            byte[] bytes;
            try {
                bytes = data.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 is not supported!", e);
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            int i = 0;
            while (i < bytes.length) {
                int k = 0;
                if (TABLE_DECODE[bytes[i]] == -1) {
                    ++i;
                    continue;
                }
                k = (TABLE_DECODE[bytes[i]] & 0xFF) << 18;
                int num = 0;
                if (i + 1 < bytes.length && TABLE_DECODE[bytes[i + 1]] != -1) {
                    k |= (TABLE_DECODE[bytes[i + 1]] & 0xFF) << 12;
                    ++num;
                }
                if (i + 2 < bytes.length && TABLE_DECODE[bytes[i + 2]] != -1) {
                    k |= (TABLE_DECODE[bytes[i + 2]] & 0xFF) << 6;
                    ++num;
                }
                if (i + 3 < bytes.length && TABLE_DECODE[bytes[i + 3]] != -1) {
                    k |= TABLE_DECODE[bytes[i + 3]] & 0xFF;
                    ++num;
                }
                while (num > 0) {
                    int c = (k & 0xFF0000) >> 16;
                    buffer.write((char)c);
                    k <<= 8;
                    --num;
                }
                i += 4;
            }
            return buffer.toByteArray();
        }
    }

    public class News
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 2336407351548626614L;
        private String headLine = "";
        private String date = "";
        private String id = "";
        private String imageUrl = "";
        private String shortMessage = "";
        private String wholeMessage = "";

        public News(String headLine, String date, String id, String imageUrl, String shortMessage, String wholeMessage) {
            this.headLine = headLine;
            this.date = date;
            this.id = id;
            this.imageUrl = imageUrl;
            this.shortMessage = shortMessage;
            this.wholeMessage = wholeMessage;
        }

        public News(JsonObject jsonObject) {
            this.headLine = jsonObject.get("headline").getAsString();
            this.date = jsonObject.get("newsdate").getAsString();
            this.id = jsonObject.get("newsid").getAsString();
            this.imageUrl = jsonObject.get("newsimageurl").getAsString();
            this.shortMessage = jsonObject.get("shortmessage").getAsString();
            this.wholeMessage = jsonObject.get("wholemessage").getAsString();
        }

        public String getHeadLine() {
            return this.headLine;
        }

        public void setHeadLine(String headLine) {
            this.headLine = headLine;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public String getShortMessage() {
            return this.shortMessage;
        }

        public void setShortMessage(String shortMessage) {
            this.shortMessage = shortMessage;
        }

        public String getWholeMessage() {
            return this.wholeMessage;
        }

        public void setWholeMessage(String wholeMessage) {
            this.wholeMessage = wholeMessage;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            News other = (News)obj;
            if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
                return false;
            }
            if (this.headLine == null ? other.headLine != null : !this.headLine.equals(other.headLine)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.imageUrl == null ? other.imageUrl != null : !this.imageUrl.equals(other.imageUrl)) {
                return false;
            }
            if (this.shortMessage == null ? other.shortMessage != null : !this.shortMessage.equals(other.shortMessage)) {
                return false;
            }
            return !(this.wholeMessage == null ? other.wholeMessage != null : !this.wholeMessage.equals(other.wholeMessage));
        }

        public String toString() {
            return "{\"headLine\":\"" + this.headLine + "\", \"date\":\"" + this.date + "\", \"id\":\"" + this.id + "\", \"imageUrl\":\"" + this.imageUrl + "\", \"shortMessage\":\"" + this.shortMessage + "\", \"wholeMessage\":\"" + this.wholeMessage + "\"}";
        }
    }

    public class TimeTable
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 553852884423090700L;
        private UUID uuid = null;
        private String title = "";
        private String detail = "";
        private String date = "";
        private String url = "";

        public TimeTable(UUID uuid, String title, String detail, String date, String url) {
            this.uuid = uuid;
            this.title = title;
            this.detail = detail;
            this.date = date;
            this.url = url;
        }

        public TimeTable(JsonObject jsonObject) {
            this.uuid = UUID.fromString(jsonObject.get("Id").getAsString());
            this.title = jsonObject.get("Title").getAsString();
            this.detail = jsonObject.get("Detail").getAsString();
            this.date = jsonObject.get("Date").getAsString();
            this.url = jsonObject.get("Detail").getAsString();
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public void setUUID(UUID uuid) {
            this.uuid = uuid;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeTable other = (TimeTable)obj;
            if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
                return false;
            }
            if (this.detail == null ? other.detail != null : !this.detail.equals(other.detail)) {
                return false;
            }
            if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
                return false;
            }
            if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }

        public String toString() {
            return "{\"uuid\":\"" + this.uuid + "\", \"date\":\"" + this.date + "\", \"detail\":\"" + this.detail + "\", \"title\":\"" + this.title + "\", \"url\":\"" + this.url + "\"}";
        }
    }
}

