/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.maven;

import de.sekmi.histream.i2b2.ont.SQLGenerator;
import de.sekmi.histream.ontology.Ontology;
import de.sekmi.histream.ontology.OntologyException;
import de.sekmi.histream.ontology.skos.Store;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.openrdf.repository.RepositoryException;

@Mojo(name="ontology")
public class OntologyMojo
extends AbstractMojo {
    @Parameter(required=true)
    FileSet source;
    @Parameter(required=false, defaultValue="${project.build.directory}/generated-resources/sql")
    File destination;
    @Parameter
    boolean overwrite;
    @Parameter
    Properties properties;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter
    Map<String, String> prefixes;

    private void logWarning(String message) {
        this.getLog().warn((CharSequence)message);
    }

    private List<File> getSourceFiles() {
        Objects.requireNonNull(this.source);
        FileSetManager fsm = new FileSetManager();
        String[] files = fsm.getIncludedFiles(this.source);
        String base = this.source.getDirectory();
        this.getLog().info((CharSequence)("Using source base directory: " + base));
        ArrayList<File> list = new ArrayList<File>(files.length);
        for (int i = 0; i < files.length; ++i) {
            this.getLog().info((CharSequence)("Source: " + files[i]));
            list.add(new File(base, files[i]));
        }
        if (list.isEmpty()) {
            this.getLog().warn((CharSequence)"No ontology source files to process");
        }
        return list;
    }

    private Map<String, String> loadConfiguration() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.properties != null) {
            for (String name : this.properties.stringPropertyNames()) {
                map.put(name, this.properties.getProperty(name));
            }
        }
        if (!map.containsKey("meta.sourcesystem_cd")) {
            this.getLog().warn((CharSequence)"Using project artifact id for missing property meta.sourcesystem_cd");
            map.put("meta.sourcesystem_cd", this.project.getArtifactId());
        }
        if (!map.containsKey("ont.language")) {
            this.getLog().warn((CharSequence)("Using system default language for missing property ont.language: " + Locale.getDefault().getLanguage()));
            map.put("ont.language", Locale.getDefault().getLanguage());
        }
        return map;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Store store;
        Map<String, String> map = this.loadConfiguration();
        try {
            Files.createDirectories(this.destination.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create destination directory: " + this.destination, (Exception)e);
        }
        Path metaSQL = new File(this.destination, "meta.sql").toPath();
        Path dataSQL = new File(this.destination, "data.sql").toPath();
        try {
            store = new Store(this.getSourceFiles(), null);
        }
        catch (IOException | RepositoryException e) {
            throw new MojoExecutionException("Unable to load ontology", (Exception)e);
        }
        if (this.prefixes != null) {
            String[] ns = new String[this.prefixes.size()];
            String[] pr = new String[ns.length];
            int i = 0;
            Iterator<String> iterator = this.prefixes.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                pr[i] = key = iterator.next();
                ns[i] = this.prefixes.get(key);
                ++i;
            }
            store.setNamespacePrefixes(ns, pr);
        }
        try {
            SQLGenerator gen = new SQLGenerator(metaSQL, dataSQL, map, this.overwrite);
            gen.setWarningHandler(this::logWarning);
            gen.writeOntologySQL((Ontology)store);
            gen.close();
            store.close();
        }
        catch (OntologyException | IOException | SQLException e) {
            throw new MojoExecutionException("Ontology to SQL transformation failed", (Exception)e);
        }
    }
}

