/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.ontology.skos;

import de.sekmi.histream.ontology.OntologyException;
import de.sekmi.histream.ontology.ValueRestriction;
import de.sekmi.histream.ontology.skos.ConceptImpl;
import de.sekmi.histream.ontology.skos.RDFUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.SKOS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class RestrictionImpl
implements ValueRestriction {
    final QName type;
    final ConceptImpl concept;
    final Resource resource;
    final Object[] enumValues;

    RestrictionImpl(ConceptImpl concept, Resource restriction) throws RepositoryException, OntologyException {
        String localPart;
        RepositoryConnection rdf = concept.getStore().getConnection();
        this.concept = concept;
        this.resource = restriction;
        if (!rdf.hasStatement(this.resource, RDF.TYPE, (Value)OWL.RESTRICTION, false, new Resource[0])) {
            throw new OntologyException("Type owl:Restriction expected for " + restriction);
        }
        if (!rdf.hasStatement(this.resource, OWL.ONPROPERTY, (Value)RDF.VALUE, false, new Resource[0])) {
            throw new OntologyException("owl:Restriction only supported owl:onProperty rdf:value");
        }
        Value o = RDFUtils.getObject(rdf, this.resource, OWL.ALLVALUESFROM);
        this.type = o != null ? ((localPart = o.equals(XMLSchema.INTEGER) || o.equals(XMLSchema.INT) || o.equals(XMLSchema.LONG) ? ((URI)o).getLocalName() : (o.equals(XMLSchema.POSITIVE_INTEGER) ? ((URI)o).getLocalName() : (o.equals(XMLSchema.STRING) ? ((URI)o).getLocalName() : (o.equals(XMLSchema.DECIMAL) || o.equals(XMLSchema.FLOAT) || o.equals(XMLSchema.DOUBLE) ? ((URI)o).getLocalName() : null)))) != null ? new QName("http://www.w3.org/2001/XMLSchema#", localPart) : null) : null;
        o = RDFUtils.getObject(rdf, this.resource, OWL.ONEOF);
        if (o != null) {
            ArrayList list = new ArrayList();
            RDFUtils.forEachRDFListItem(rdf, (Resource)o, v -> {
                try {
                    Literal literal = RDFUtils.getLiteralObject(rdf, (Resource)v, RDF.VALUE);
                    list.add(literal.getLabel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.enumValues = list.toArray(new String[list.size()]);
        } else {
            this.enumValues = null;
        }
    }

    public QName getType() {
        return this.type;
    }

    public String[] getEnumerationLabels(Locale locale) throws OntologyException {
        if (this.enumValues == null) {
            return null;
        }
        RepositoryConnection rdf = this.concept.getStore().getConnection();
        try {
            Value o = RDFUtils.getObject(rdf, this.resource, OWL.ONEOF);
            if (o == null) {
                return null;
            }
            String language = locale == null ? null : locale.toString();
            ArrayList list = new ArrayList();
            RDFUtils.forEachRDFListItem(rdf, (Resource)o, v -> {
                try {
                    String label = RDFUtils.getLocalString(rdf, (Resource)v, SKOS.PREF_LABEL, language);
                    list.add(label);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return list.toArray(new String[list.size()]);
        }
        catch (RepositoryException e) {
            throw new OntologyException((Throwable)e);
        }
    }

    public Object[] getEnumerationValues() {
        return this.enumValues;
    }

    public Number minInclusive() {
        return null;
    }

    public Number maxInclusive() {
        return null;
    }

    public Integer minLength() {
        return null;
    }

    public Integer maxLength() {
        return null;
    }

    public Pattern getPattern() {
        return null;
    }
}

