/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.ontology.skos;

import java.util.function.Consumer;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class RDFUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value getObject(RepositoryConnection connection, Resource subject, URI predicate) throws RepositoryException {
        try (RepositoryResult rs = connection.getStatements(subject, predicate, null, false, new Resource[0]);){
            if (rs.hasNext()) {
                Value value = ((Statement)rs.next()).getObject();
                return value;
            }
            Value value = null;
            return value;
        }
    }

    public static void forEachRDFListItem(RepositoryConnection connection, Resource rdfList, Consumer<Value> consumer) throws RepositoryException {
        Value obj;
        do {
            if ((obj = RDFUtils.getObject(connection, rdfList, RDF.FIRST)) == null) continue;
            consumer.accept(obj);
        } while ((rdfList = (obj = RDFUtils.getObject(connection, rdfList, RDF.REST)) == null ? null : (obj.equals(RDF.NIL) ? null : (obj instanceof Resource ? (Resource)obj : null))) != null);
    }

    public static final Literal getLiteralObject(RepositoryConnection rc, Resource subject, URI predicate) throws RepositoryException {
        Value v = RDFUtils.getObject(rc, subject, predicate);
        if (v instanceof Literal) {
            return (Literal)v;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getLocalString(RepositoryConnection rc, Resource subject, URI predicate, String language) throws RepositoryException {
        if (language != null && language.length() == 0) {
            language = null;
        }
        try (RepositoryResult rs = rc.getStatements(subject, predicate, null, false, new Resource[0]);){
            while (rs.hasNext()) {
                Value v = ((Statement)rs.next()).getObject();
                if (!(v instanceof Literal)) continue;
                Literal l = (Literal)v;
                String lit_lang = l.getLanguage();
                if (language == null && lit_lang == null) {
                    String string = l.getLabel();
                    return string;
                }
                if (lit_lang == null || language == null || !lit_lang.equals(language)) continue;
                String string = l.getLabel();
                return string;
            }
        }
        return null;
    }
}

