/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.ontology.skos;

import de.sekmi.histream.ontology.Concept;
import de.sekmi.histream.ontology.OntologyException;
import de.sekmi.histream.ontology.ValueRestriction;
import de.sekmi.histream.ontology.skos.HIStreamOntology;
import de.sekmi.histream.ontology.skos.RestrictionImpl;
import de.sekmi.histream.ontology.skos.Store;
import java.util.ArrayList;
import java.util.Locale;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.DC;
import org.openrdf.model.vocabulary.SKOS;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class ConceptImpl
implements Concept {
    private Resource res;
    private Store store;

    public ConceptImpl(Store store, Resource concept) {
        this.store = store;
        this.res = concept;
    }

    public boolean equals(Object other) {
        if (other.getClass() != ConceptImpl.class) {
            return false;
        }
        return this.res.equals(((ConceptImpl)other).res);
    }

    public int hashCode() {
        return this.res.hashCode();
    }

    public Concept[] getNarrower() throws OntologyException {
        return this.store.getNarrower(this);
    }

    public Resource getResource() {
        return this.res;
    }

    Store getStore() {
        return this.store;
    }

    public String toString() {
        return this.res.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNotations() throws OntologyException {
        ArrayList<String> ids = new ArrayList<String>();
        try (RepositoryResult s = this.store.getConnection().getStatements(this.res, SKOS.NOTATION, null, true, new Resource[0]);){
            while (s.hasNext()) {
                Value o = ((Statement)s.next()).getObject();
                ids.add(o.stringValue());
            }
        }
        catch (RepositoryException e) {
            throw new OntologyException((Throwable)e);
        }
        return ids.toArray(new String[ids.size()]);
    }

    public Concept[] getBroader() throws OntologyException {
        return this.store.getBroader(this);
    }

    public String getPrefLabel(Locale locale) throws OntologyException {
        String lang = locale == null ? null : locale.toString();
        return this.store.getLocalString(this.getResource(), SKOS.PREF_LABEL, lang);
    }

    public String getDescription(Locale locale) throws OntologyException {
        String lang = locale == null ? null : locale.toString();
        return this.store.getLocalString(this.getResource(), DC.DESCRIPTION, lang);
    }

    public Concept[] getParts() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ValueRestriction getValueRestriction() throws OntologyException {
        try (RepositoryResult rs = this.store.getConnection().getStatements(this.getResource(), HIStreamOntology.DWH_RESTRICTION, null, false, new Resource[0]);){
            if (!rs.hasNext()) {
                ValueRestriction valueRestriction = null;
                return valueRestriction;
            }
            Value obj = ((Statement)rs.next()).getObject();
            if (!(obj instanceof Resource)) {
                throw new OntologyException("dwh:restriction expected to be a rdf resource");
            }
            RestrictionImpl ret = new RestrictionImpl(this, (Resource)obj);
            if (rs.hasNext()) {
                throw new OntologyException("More than one dwh:restriction for " + this.res);
            }
            RestrictionImpl restrictionImpl = ret;
            return restrictionImpl;
        }
        catch (RepositoryException e) {
            throw new OntologyException((Throwable)e);
        }
    }

    public String[] getSchemes() throws OntologyException {
        ArrayList ids = new ArrayList();
        try {
            this.store.forEachObject(this.res, SKOS.IN_SCHEME, scheme -> ids.add(scheme.stringValue()));
        }
        catch (RepositoryException e) {
            throw new OntologyException((Throwable)e);
        }
        return ids.toArray(new String[ids.size()]);
    }

    public String getID() {
        URI me = (URI)this.res;
        return Integer.toHexString(me.getNamespace().hashCode()) + ":" + me.getLocalName();
    }
}

