/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.ontology.skos.transform;

import de.sekmi.histream.Observation;
import de.sekmi.histream.ObservationSupplier;
import de.sekmi.histream.io.FileObservationProviderTest;
import de.sekmi.histream.ontology.OntologyException;
import de.sekmi.histream.ontology.skos.Store;
import de.sekmi.histream.ontology.skos.transform.ConditionType;
import de.sekmi.histream.ontology.skos.transform.RDFTransformation;
import de.sekmi.histream.ontology.skos.transform.Rule;
import de.sekmi.histream.ontology.skos.transform.TransformationRules;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransformationRuleTest {
    private Store store;
    public static final String TEST_PREFIX = "http://sekmi.de/histream/examples/mapping#";

    @Before
    public void setupOntology() throws Exception {
        this.store = new Store(new File("examples/test-mapping.ttl"));
    }

    @Test
    public void testGetRules() throws OntologyException {
        TransformationRules r = this.store.getConceptTransformations("source1", "http://sekmi.de/histream/examples/mapping#source");
        Assert.assertNotNull((Object)r);
        Assert.assertNotNull((Object)r.getMapRules());
        Assert.assertEquals((long)1L, (long)r.getMapRules().length);
        Rule rule = r.getMapRules()[0];
        Assert.assertNotNull((Object)rule.condition);
        Assert.assertNotNull((Object)rule.getTarget());
        Assert.assertEquals((Object)ConditionType.XPath, (Object)rule.conditionType);
    }

    @Test
    public void testApplyRules() throws Exception {
        TransformationRules r = this.store.getConceptTransformations("source1", "http://sekmi.de/histream/examples/mapping#source");
        Assert.assertNotNull((Object)r);
        RDFTransformation t = new RDFTransformation(null, this.store, "http://sekmi.de/histream/examples/mapping#source", true);
        FileObservationProviderTest p = new FileObservationProviderTest();
        p.initializeObservationFactory();
        ObservationSupplier s = p.getExampleSupplier("examples/test-mapping-facts.xml");
        Observation o = (Observation)s.get();
        Assert.assertEquals((Object)"source1", (Object)o.getConceptId());
        Observation o2 = t.transform(o, null);
        Assert.assertEquals((Object)"T:t1", (Object)o2.getConceptId());
        o = (Observation)s.get();
        Assert.assertEquals((Object)"source1", (Object)o.getConceptId());
        o2 = t.transform(o, null);
        Assert.assertEquals((Object)"source1", (Object)o2.getConceptId());
        o = (Observation)s.get();
        Assert.assertEquals((Object)"source2", (Object)o.getConceptId());
        o2 = t.transform(o, null);
        Assert.assertEquals((Object)"T:t2", (Object)o2.getConceptId());
        o = (Observation)s.get();
        Assert.assertEquals((Object)"source3", (Object)o.getConceptId());
        o2 = t.transform(o, null);
        Assert.assertEquals((Object)"T:t1", (Object)o2.getConceptId());
        o = (Observation)s.get();
        Assert.assertEquals((Object)"source3", (Object)o.getConceptId());
        o2 = t.transform(o, null);
        Assert.assertEquals((Object)"T:t2", (Object)o2.getConceptId());
        o = (Observation)s.get();
        Assert.assertEquals((Object)"source3", (Object)o.getConceptId());
        o2 = t.transform(o, null);
        Assert.assertEquals((Object)"T:t3", (Object)o2.getConceptId());
        s.close();
    }
}

