/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.ontology.skos;

import de.sekmi.histream.ontology.Concept;
import de.sekmi.histream.ontology.OntologyException;
import de.sekmi.histream.ontology.ValueRestriction;
import de.sekmi.histream.ontology.skos.ConceptImpl;
import de.sekmi.histream.ontology.skos.Store;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OntologyTest {
    Store store;
    static final String NS_PREFIX = "http://sekmi.de/histream/skos/tests#";

    @Before
    public void setupOntology() throws Exception {
        this.store = new Store(new File("examples/test-ontology.ttl"));
        this.store.setConceptScheme("http://sekmi.de/histream/skos/tests#TestScheme");
    }

    @Test
    public void testGetSchemes() throws OntologyException {
        ConceptImpl c = this.store.getConceptByNotation("other");
        Assert.assertNotNull((Object)c);
        String[] schemes = c.getSchemes();
        Assert.assertNotNull((Object)schemes);
        Assert.assertEquals((long)2L, (long)schemes.length);
    }

    @Test
    public void getConceptByIdTest() throws OntologyException {
        Assert.assertNull((Object)this.store.getConceptByNotation("notfound"));
        ConceptImpl c = this.store.getConceptByNotation("T:type:int");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)1L, (long)c.getNotations().length);
        Assert.assertEquals((Object)"T:type:int", (Object)c.getNotations()[0]);
        ValueRestriction rest = c.getValueRestriction();
        Assert.assertNotNull((Object)rest);
    }

    @Test
    public void enumRestrictionTest() throws OntologyException {
        ConceptImpl c = this.store.getConceptByNotation("T:Enum");
        Assert.assertNotNull((Object)c);
        ValueRestriction rest = c.getValueRestriction();
        Assert.assertNotNull((Object)rest);
        Object[] values = rest.getEnumerationValues();
        Assert.assertEquals((Object)"1", (Object)values[0]);
        Assert.assertEquals((Object)"2", (Object)values[1]);
        String[] labels = rest.getEnumerationLabels(Locale.GERMAN);
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.length);
        Assert.assertEquals((Object)"1_de", (Object)labels[0]);
        Assert.assertEquals((Object)"2_de", (Object)labels[1]);
        labels = rest.getEnumerationLabels(Locale.ENGLISH);
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.length);
        Assert.assertEquals((Object)"1_en", (Object)labels[0]);
        Assert.assertEquals((Object)"2_en", (Object)labels[1]);
    }

    @Test
    public void getNarrowerTest() throws OntologyException {
        Concept[] top = this.store.getTopConcepts();
        Assert.assertNotNull((Object)top);
        Assert.assertEquals((long)1L, (long)top.length);
        Concept[] narrower = top[0].getNarrower();
        Assert.assertNotNull((Object)narrower);
        Assert.assertEquals((long)4L, (long)narrower.length);
    }

    @Test
    public void inferredBroaderTest() throws OntologyException {
        Concept[] top = this.store.getTopConcepts();
        Assert.assertNotNull((Object)top);
        Assert.assertEquals((long)1L, (long)top.length);
        Concept[] narrower = top[0].getNarrower();
        Assert.assertNotNull((Object)narrower);
        for (int i = 0; i < narrower.length; ++i) {
            Concept[] broader = narrower[i].getBroader();
            Assert.assertNotNull((Object)broader);
            Assert.assertEquals((long)1L, (long)broader.length);
            Assert.assertEquals((Object)top[0], (Object)broader[0]);
        }
    }

    @Test
    public void inferredHasTopConceptAndNarrowerTest() throws OntologyException {
        Concept[] top = this.store.getTopConcepts("http://sekmi.de/histream/skos/tests#OtherScheme");
        Assert.assertNotNull((Object)top);
        Assert.assertEquals((long)1L, (long)top.length);
        Concept[] narrower = top[0].getNarrower();
        Assert.assertNotNull((Object)narrower);
        Assert.assertEquals((long)1L, (long)narrower.length);
        String[] ids = narrower[0].getNotations();
        Assert.assertEquals((long)1L, (long)ids.length);
        Assert.assertEquals((Object)"other", (Object)ids[0]);
    }

    @Test
    public void testLanguage() throws OntologyException {
        ConceptImpl c = this.store.getConceptByNotation("T:type:int");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)"Integer_label_de", (Object)c.getPrefLabel(Locale.GERMAN));
        Assert.assertEquals((Object)"Integer_label_en", (Object)c.getPrefLabel(Locale.ENGLISH));
        Assert.assertNull((Object)c.getPrefLabel(Locale.JAPANESE));
        Assert.assertEquals((Object)"Description_neutral", (Object)c.getDescription(Locale.ROOT));
        Assert.assertEquals((Object)"Description_de", (Object)c.getDescription(Locale.GERMAN));
    }

    @After
    public void closeOntology() throws IOException {
        this.store.close();
    }

    public static void main(String[] args) throws Exception {
        try (Store store = new Store(new File("examples/test-ontology.ttl"));){
            store.printConceptHierarchy();
            ConceptImpl c = store.getConceptByNotation("Type");
            System.out.println("Concept:" + c);
        }
    }
}

