/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.ontology.skos.transform;

import de.sekmi.histream.Observation;
import de.sekmi.histream.ObservationFactory;
import de.sekmi.histream.eval.ECMAEvaluator;
import de.sekmi.histream.eval.Engine;
import de.sekmi.histream.eval.ScriptException;
import de.sekmi.histream.eval.StringValueEqualsEngine;
import de.sekmi.histream.impl.XPathEvaluator;
import de.sekmi.histream.io.Transformation;
import de.sekmi.histream.io.TransformationException;
import de.sekmi.histream.ontology.OntologyException;
import de.sekmi.histream.ontology.skos.ConceptImpl;
import de.sekmi.histream.ontology.skos.Store;
import de.sekmi.histream.ontology.skos.transform.Rule;
import de.sekmi.histream.ontology.skos.transform.TransformationRules;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.xml.bind.JAXBException;

public class RDFTransformation
implements Transformation {
    private ObservationFactory factory;
    private Store store;
    private String schema;
    private boolean dropFactsWithoutRules;
    private HashMap<String, TransformationRules> cache;
    private Engine engineXPath;
    private Engine engineES;

    public RDFTransformation(ObservationFactory factory, Store store, String schema, boolean dropFactsWithoutRules) throws TransformationException {
        this.store = store;
        this.factory = factory;
        this.schema = schema;
        this.dropFactsWithoutRules = dropFactsWithoutRules;
        this.cache = new HashMap();
        try {
            this.engineXPath = new XPathEvaluator();
        }
        catch (JAXBException e) {
            throw new TransformationException("Initialization error for XPath engine", (Throwable)e);
        }
        this.engineES = new ECMAEvaluator();
    }

    public Observation transform(Observation fact, Consumer<Observation> generatedReceiver) throws TransformationException {
        TransformationRules rules;
        String notation = fact.getConceptId();
        if (this.cache.containsKey(notation)) {
            rules = this.cache.get(notation);
        } else {
            try {
                rules = this.store.getConceptTransformations(notation, this.schema);
            }
            catch (OntologyException e) {
                this.cache.put(notation, null);
                throw new TransformationException("Error retrieving transformation rules", (Throwable)e);
            }
            this.cache.put(notation, rules);
        }
        if (rules == null) {
            return this.dropFactsWithoutRules ? null : fact;
        }
        try {
            Rule[] map;
            for (Rule rule : map = rules.getMapRules()) {
                this.applyRule(rule, fact);
            }
        }
        catch (OntologyException e) {
            throw new TransformationException("Rule evaluation failed", (Throwable)e);
        }
        if (this.factory != null) {
            // empty if block
        }
        return fact;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean applyRule(Rule rule, Observation fact) throws OntologyException, TransformationException {
        ConceptImpl target;
        if (rule.choose != null) {
            int i = -1;
            for (i = 0; i < rule.choose.length; ++i) {
                if (!this.applyRule(rule.choose[i], fact)) continue;
                target = rule.choose[i].target;
                break;
            }
            if (i != rule.choose.length || rule.otherwise == null) return false;
            target = rule.otherwise.target;
        } else {
            boolean matched;
            StringValueEqualsEngine ng;
            if (rule.condition == null) throw new TransformationException("Rule without 'choose' or 'condition'");
            switch (rule.conditionType) {
                case ECMAScript: {
                    ng = this.engineES;
                    break;
                }
                case XPath: {
                    ng = this.engineXPath;
                    break;
                }
                case StringValueEquals: {
                    ng = StringValueEqualsEngine.ENGINE;
                    break;
                }
                default: {
                    throw new TransformationException("Unsupported condition type: " + (Object)((Object)rule.conditionType));
                }
            }
            try {
                matched = ng.test(rule.condition, fact);
            }
            catch (ScriptException e) {
                throw new TransformationException("Evaluation error: " + rule.condition, (Throwable)e);
            }
            if (matched) {
                target = rule.target;
            } else {
                if (rule.otherwise == null) return false;
                target = rule.otherwise.target;
            }
        }
        String[] ids = target.getNotations();
        if (ids.length == 0) {
            throw new TransformationException("No notation found in target concept " + target);
        }
        fact.replaceConcept(ids[0]);
        return true;
    }
}

