/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.ontology.skos;

import de.sekmi.histream.Plugin;
import de.sekmi.histream.ontology.Concept;
import de.sekmi.histream.ontology.Ontology;
import de.sekmi.histream.ontology.OntologyException;
import de.sekmi.histream.ontology.skos.ConceptImpl;
import de.sekmi.histream.ontology.skos.HIStreamOntology;
import de.sekmi.histream.ontology.skos.RDFUtils;
import de.sekmi.histream.ontology.skos.SKOSException;
import de.sekmi.histream.ontology.skos.transform.ConditionType;
import de.sekmi.histream.ontology.skos.transform.Rule;
import de.sekmi.histream.ontology.skos.transform.TransformationRules;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.util.Literals;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.SKOS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class Store
implements Ontology,
Plugin {
    private static final Logger log = Logger.getLogger(Store.class.getName());
    private Repository repo;
    private RepositoryConnection rc;
    private static final Concept[] noConcepts = new Concept[0];
    private long lastModified;
    private Resource inferredContext;
    private Resource scheme;

    public Store(Map<String, String> conf) throws RepositoryException, IOException {
        int i = 1;
        ArrayList<File> files = new ArrayList<File>();
        String baseURI = conf.get("rdf.baseURI");
        while (conf.containsKey("rdf.file." + i)) {
            File file = new File(conf.get("rdf.file." + i));
            if (!file.exists()) {
                throw new FileNotFoundException("rdf.file." + i + " not found: " + file.getAbsolutePath());
            }
            files.add(file);
            ++i;
        }
        this.initializeRepo(files, null, baseURI);
        if (conf.containsKey("rdf.skosScheme")) {
            this.scheme = this.repo.getValueFactory().createURI(conf.get("rdf.skosScheme"));
        }
    }

    public Store(List<File> files, String baseURI, String scheme) throws RepositoryException, IOException {
        this.initializeRepo(files, null, baseURI);
        if (scheme != null) {
            this.scheme = this.repo.getValueFactory().createURI(scheme);
        }
    }

    public Store(Iterable<File> files, String baseURI) throws RepositoryException, IOException {
        this.initializeRepo(files, null, baseURI);
    }

    public Store(Iterable<URL> urls) throws RepositoryException, IOException {
        this.initializeRepo(null, urls, null);
    }

    public Store(File file) throws RepositoryException, IOException {
        this(Arrays.asList(file), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int inferInverseRelations(URI predicate, URI inversePredicate) throws RepositoryException {
        int count = 0;
        try (RepositoryResult res = this.rc.getStatements(null, predicate, null, false, new Resource[0]);){
            while (res.hasNext()) {
                Statement stmt = (Statement)res.next();
                if (!(stmt.getObject() instanceof Resource) || this.rc.hasStatement((Resource)stmt.getObject(), inversePredicate, (Value)stmt.getSubject(), false, new Resource[0])) continue;
                this.rc.add((Resource)stmt.getObject(), inversePredicate, (Value)stmt.getSubject(), new Resource[]{this.inferredContext});
                ++count;
            }
        }
        return count;
    }

    private void initializeRepo(Iterable<File> files, Iterable<URL> urls, String baseURI) throws RepositoryException, IOException {
        this.repo = new SailRepository((Sail)new MemoryStore());
        this.repo.initialize();
        this.rc = this.repo.getConnection();
        this.inferredContext = this.repo.getValueFactory().createURI("http://sekmi.de/histream/inferredInverse");
        this.lastModified = 0L;
        if (files != null) {
            for (File file : files) {
                try {
                    this.rc.add(file, baseURI, RDFFormat.TURTLE, new Resource[0]);
                }
                catch (RDFParseException e) {
                    throw new IOException("Parse error for file " + file + ":" + e.getLineNumber() + ": " + e.getMessage(), e);
                }
                this.lastModified = Math.max(this.lastModified, file.lastModified());
            }
        }
        if (urls != null) {
            for (URL url : urls) {
                try {
                    this.rc.add(url, baseURI, RDFFormat.TURTLE, new Resource[0]);
                }
                catch (RDFParseException e) {
                    throw new IOException("Parse error for url " + url + ":" + e.getLineNumber() + ": " + e.getMessage(), e);
                }
                this.lastModified = System.currentTimeMillis();
            }
        }
        int inferred = 0;
        inferred += this.inferInverseRelations(SKOS.TOP_CONCEPT_OF, SKOS.HAS_TOP_CONCEPT);
        inferred += this.inferInverseRelations(SKOS.BROADER, SKOS.NARROWER);
        if ((inferred += this.inferInverseRelations(SKOS.NARROWER, SKOS.BROADER)) != 0) {
            log.fine("Inferred " + inferred + " statements.");
        }
    }

    public void setConceptScheme(String schemeURI) {
        this.scheme = this.repo.getValueFactory().createURI(schemeURI);
    }

    public RepositoryConnection getConnection() {
        return this.rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Concept[] collectConcepts(RepositoryResult<Statement> result) throws RepositoryException {
        ArrayList<ConceptImpl> concepts = new ArrayList<ConceptImpl>();
        try {
            while (result.hasNext()) {
                Statement s = (Statement)result.next();
                concepts.add(new ConceptImpl(this, (Resource)s.getObject()));
            }
        }
        finally {
            result.close();
        }
        if (concepts.size() == 0) {
            return noConcepts;
        }
        return concepts.toArray(new Concept[concepts.size()]);
    }

    public Concept[] getTopConcepts() throws OntologyException {
        return this.getRelatedConcepts(this.scheme, SKOS.HAS_TOP_CONCEPT);
    }

    public Concept[] getTopConcepts(String scheme) throws OntologyException {
        URI schemeURI = null;
        if (scheme != null) {
            schemeURI = this.repo.getValueFactory().createURI(scheme);
        }
        return this.getRelatedConcepts((Resource)schemeURI, SKOS.HAS_TOP_CONCEPT);
    }

    private Concept[] getRelatedConcepts(Resource subject, URI predicate) throws OntologyException {
        try {
            RepositoryResult rr = this.rc.getStatements(subject, predicate, null, true, new Resource[0]);
            return this.collectConcepts((RepositoryResult<Statement>)rr);
        }
        catch (RepositoryException e) {
            throw new OntologyException((Throwable)e);
        }
    }

    Concept[] getBroader(ConceptImpl concept) throws OntologyException {
        return this.getRelatedConcepts(concept.getResource(), SKOS.BROADER);
    }

    Concept[] getNarrower(ConceptImpl concept) throws OntologyException {
        return this.getRelatedConcepts(concept.getResource(), SKOS.NARROWER);
    }

    public void printTopConcepts() throws OntologyException {
        for (Concept c : this.getTopConcepts()) {
            System.out.println("Top: " + c);
        }
    }

    private void printSubHierarchy(int indent, Concept concept) throws OntologyException {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            b.append('\t');
        }
        System.out.println(b.toString() + concept.toString());
        for (Concept c : concept.getNarrower()) {
            this.printSubHierarchy(indent + 1, c);
        }
    }

    public void printConceptHierarchy() throws OntologyException {
        for (Concept c : this.getTopConcepts()) {
            this.printSubHierarchy(0, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConceptImpl getConceptByNotation(String id) throws OntologyException {
        try (RepositoryResult rs = this.rc.getStatements(null, SKOS.NOTATION, (Value)Literals.createLiteral((ValueFactory)this.rc.getValueFactory(), (Object)id), true, new Resource[0]);){
            if (!rs.hasNext()) {
                ConceptImpl conceptImpl = null;
                return conceptImpl;
            }
            Resource s = ((Statement)rs.next()).getSubject();
            if (rs.hasNext()) {
                throw new SKOSException(s, "Notation '" + id + "' with multiple concepts");
            }
            ConceptImpl conceptImpl = new ConceptImpl(this, s);
            return conceptImpl;
        }
        catch (RepositoryException e) {
            throw new SKOSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConceptImpl getConceptByNotation(String notation, URI conceptScheme) throws RepositoryException {
        Resource concept = null;
        try (RepositoryResult rs = this.rc.getStatements(null, SKOS.NOTATION, (Value)Literals.createLiteral((ValueFactory)this.rc.getValueFactory(), (Object)notation), true, new Resource[0]);){
            while (rs.hasNext()) {
                concept = ((Statement)rs.next()).getSubject();
                if (this.rc.hasStatement(concept, SKOS.IN_SCHEME, (Value)conceptScheme, false, new Resource[0])) {
                    break;
                }
                concept = null;
            }
        }
        return new ConceptImpl(this, concept);
    }

    String getLocalString(Resource subject, URI predicate, String language) throws OntologyException {
        try {
            return RDFUtils.getLocalString(this.rc, subject, predicate, language);
        }
        catch (RepositoryException e) {
            throw new OntologyException((Throwable)e);
        }
    }

    public void close() throws IOException {
        try {
            this.rc.close();
            this.repo.shutDown();
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    public long lastModified() {
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forEachStatement(Resource subject, URI predicate, Consumer<Statement> consumer) throws RepositoryException {
        try (RepositoryResult rs = this.rc.getStatements(subject, predicate, null, false, new Resource[0]);){
            while (rs.hasNext()) {
                consumer.accept((Statement)rs.next());
            }
        }
    }

    protected void forEachObject(Resource subject, URI predicate, Consumer<Value> consumer) throws RepositoryException {
        this.forEachStatement(subject, predicate, s -> consumer.accept(s.getObject()));
    }

    public TransformationRules getConceptTransformations(String notation, String schemaURI) throws OntologyException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        try {
            ConceptImpl c = this.getConceptByNotation(notation, this.rc.getValueFactory().createURI(schemaURI));
            if (c == null) {
                return null;
            }
            ArrayList list = new ArrayList();
            this.forEachObject(c.getResource(), HIStreamOntology.DWH_MAPFACT, list::add);
            for (Value v : list) {
                if (!(v instanceof Resource)) {
                    throw new RepositoryException("Not a resource: (" + c.getResource() + ", " + HIStreamOntology.DWH_MAPFACT + ", [object] <--!! )");
                }
                Rule rule = this.loadMapFactRule((Resource)v, false);
                rules.add(rule);
            }
        }
        catch (RepositoryException e) {
            throw new OntologyException((Throwable)e);
        }
        if (rules.size() == 0) {
            return null;
        }
        return new TransformationRules(rules.toArray(new Rule[rules.size()]));
    }

    public void forEachRDFListItem(Resource rdfList, Consumer<Value> consumer) throws RepositoryException {
        Value obj;
        do {
            if ((obj = RDFUtils.getObject(this.rc, rdfList, RDF.FIRST)) == null) continue;
            consumer.accept(obj);
        } while ((rdfList = (obj = RDFUtils.getObject(this.rc, rdfList, RDF.REST)) == null ? null : (obj.equals(RDF.NIL) ? null : (obj instanceof Resource ? (Resource)obj : null))) != null);
    }

    private Rule loadOtherwiseRule(Resource r) throws SKOSException, RepositoryException {
        Value targ = RDFUtils.getObject(this.rc, r, HIStreamOntology.DWH_TARGET);
        if (targ == null) {
            throw new SKOSException(r, "dwh:otherwise must include a dwh:target");
        }
        return new Rule(null, ConditionType.Otherwise, new ConceptImpl(this, (Resource)targ), null);
    }

    private Rule loadMapFactRule(Resource r, boolean disableChoose) throws OntologyException, RepositoryException {
        Value[] v = new Value[6];
        this.forEachStatement(r, null, s -> {
            if (s.getPredicate().equals((Object)HIStreamOntology.DWH_CONDITION)) {
                v[0] = s.getObject();
            } else if (s.getPredicate().equals((Object)HIStreamOntology.DWH_CHOOSE)) {
                v[1] = s.getObject();
            } else if (s.getPredicate().equals((Object)HIStreamOntology.DWH_TARGET)) {
                v[2] = s.getObject();
            } else if (s.getPredicate().equals((Object)HIStreamOntology.DWH_MODIFY)) {
                v[3] = s.getObject();
            } else if (s.getPredicate().equals((Object)RDF.VALUE)) {
                v[4] = s.getObject();
            } else if (s.getPredicate().equals((Object)HIStreamOntology.DWH_OTHERWISE)) {
                v[5] = s.getObject();
            }
        });
        if (v[0] != null) {
            if (v[2] == null) {
                throw new SKOSException(r, "dwh:mapFact with dwh:condition must also contain dwh:target");
            }
            if (v[1] != null) {
                throw new SKOSException(r, "dwh:condition and dwh:choose cannot be combined");
            }
            if (!(v[0] instanceof Literal)) {
                throw new SKOSException(r, "dwh:condition needs literal object");
            }
            Literal condition = (Literal)v[0];
            Rule otherwise = null;
            if (v[5] != null) {
                otherwise = this.loadOtherwiseRule((Resource)v[5]);
            }
            return Rule.forCondition(condition, new ConceptImpl(this, (Resource)v[2]), otherwise);
        }
        if (v[1] != null) {
            if (!(v[1] instanceof Resource)) {
                throw new SKOSException(r, "dwh:choose must be a resource");
            }
            if (v[2] != null) {
                throw new SKOSException(r, "dwh:choose and dwh:target cannot be combined");
            }
            ArrayList list = new ArrayList();
            LinkedList errors = new LinkedList();
            RDFUtils.forEachRDFListItem(this.rc, (Resource)v[1], l -> {
                try {
                    list.add(this.loadMapFactRule((Resource)l, true));
                }
                catch (Exception e) {
                    errors.add(e);
                }
            });
            Rule otherwise = null;
            if (v[5] != null) {
                otherwise = this.loadOtherwiseRule((Resource)v[5]);
            }
            if (errors.isEmpty()) {
                return new Rule(list.toArray(new Rule[list.size()]), otherwise);
            }
            Throwable first = (Throwable)errors.get(0);
            SKOSException error = new SKOSException(first);
            for (Throwable e : errors) {
                if (e == first) continue;
                error.addSuppressed(e);
            }
            throw error;
        }
        if (v[4] != null) {
            if (!(v[4] instanceof Literal)) {
                throw new SKOSException(r, "rdf:value needs literal object");
            }
            if (v[2] == null) {
                throw new SKOSException(r, "dwh:mapFact with rdf:value must also contain dwh:target");
            }
            Literal value = (Literal)v[4];
            if (!value.getDatatype().equals((Object)XMLSchema.STRING)) {
                throw new SKOSException(r, "rdf:value for comparison must have datatype xsd:string");
            }
            return new Rule(value.stringValue(), ConditionType.StringValueEquals, new ConceptImpl(this, (Resource)v[2]), null);
        }
        throw new SKOSException(r, "dwh:mapFact must contain one of dwh:condition, dwh:choose, dwh:value");
    }

    public Concept getConceptById(String id) throws OntologyException {
        URI uri = this.repo.getValueFactory().createURI(id);
        RepositoryResult s = null;
        ConceptImpl ci = null;
        try {
            s = this.rc.getStatements((Resource)uri, RDF.TYPE, (Value)SKOS.CONCEPT, false, new Resource[0]);
            if (s.hasNext()) {
                ci = new ConceptImpl(this, ((Statement)s.next()).getSubject());
            }
            s.close();
        }
        catch (RepositoryException e) {
            throw new OntologyException((Throwable)e);
        }
        return ci;
    }
}

