/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2.services;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import javax.annotation.Resource;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;

public class HiveServer
implements Provider<Source> {
    private ScriptEngineManager scriptManager = new ScriptEngineManager();
    private ScriptEngine scriptEngine;
    private Path scriptDir;
    private WatchService watcher;
    @Resource
    protected WebServiceContext context;

    public void loadMainScript() throws IOException, ScriptException {
        this.scriptEngine = this.scriptManager.getEngineByName("nashorn");
        try (FileReader scriptFile = new FileReader(this.scriptDir.resolve("main.js").toFile());){
            this.scriptEngine.eval(scriptFile);
            Object o = this.scriptEngine.eval("typeof httpRequest === 'function'");
            if (o == null || !(o instanceof Boolean) || !((Boolean)o).booleanValue()) {
                throw new ScriptException("global function 'httpRequest(?,?,?,?)' needed");
            }
        }
    }

    public void reloadChangesLoop() {
        block6: {
            WatchKey key;
            do {
                try {
                    key = this.watcher.take();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break block6;
                }
                System.out.println("Reloading scripts..");
                try {
                    this.loadMainScript();
                }
                catch (IOException | ScriptException e1) {
                    System.err.println("Error loading script");
                    e1.printStackTrace();
                }
                for (WatchEvent<?> e : key.pollEvents()) {
                    if (e != null) continue;
                }
            } while (key.reset());
            System.err.println("Key closed");
        }
    }

    public void loadScipts() throws IOException, ScriptException {
        FileSystem fs = FileSystems.getDefault();
        this.scriptDir = fs.getPath("src", "main", "scripts", "i2b2-ws");
        if (!Files.isDirectory(this.scriptDir, new LinkOption[0])) {
            throw new FileNotFoundException("Script dir not found: " + this.scriptDir);
        }
        this.loadMainScript();
        this.watcher = fs.newWatchService();
        this.scriptDir.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    public static void main(String[] args) throws IOException, ScriptException {
        HiveServer hs = new HiveServer();
        hs.loadScipts();
        Endpoint e = Endpoint.create((String)"http://www.w3.org/2004/08/wsdl/http", (Object)hs);
        String address = "http://localhost:9000/i2b2/services";
        e.publish(address);
        hs.reloadChangesLoop();
    }

    public StreamSource invoke(Source request) {
        MessageContext mc = this.context.getMessageContext();
        String path = (String)mc.get((Object)"javax.xml.ws.http.request.pathinfo");
        String query = (String)mc.get((Object)"javax.xml.ws.http.request.querystring");
        String httpMethod = (String)mc.get((Object)"javax.xml.ws.http.request.method");
        if (request != null) {
            System.out.println("Source: " + request.getClass());
        }
        if (this.scriptEngine != null) {
            try {
                Object ret = ((Invocable)((Object)this.scriptEngine)).invokeFunction("httpRequest", httpMethod, path, query, request);
                return new StreamSource(new StringReader(ret.toString()));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
        return new StreamSource(new StringReader("<!DOCTYPE html><html><head></head><body>ERROR</body></html>"));
    }
}

