/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.DateTimeAccuracy;
import de.sekmi.histream.Observation;
import de.sekmi.histream.ext.ExternalSourceType;
import de.sekmi.histream.ext.StoredExtensionType;
import de.sekmi.histream.ext.Visit;
import de.sekmi.histream.i2b2.I2b2Patient;
import de.sekmi.histream.i2b2.I2b2Visit;
import de.sekmi.histream.i2b2.PostgresExtension;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class PostgresVisitStore
extends PostgresExtension<I2b2Visit> {
    private static final Logger log = Logger.getLogger(PostgresVisitStore.class.getName());
    private static final Class<?>[] INSTANCE_TYPES = new Class[]{Visit.class, I2b2Visit.class};
    private String projectId;
    private int maxEncounterNum;
    private char idSourceSeparator;
    private String idSourceDefault;
    private Hashtable<Integer, I2b2Visit> visitCache;
    private Hashtable<String, I2b2Visit> idCache;
    private PreparedStatement insert;
    private PreparedStatement insertMapping;
    private PreparedStatement update;
    private PreparedStatement selectAll;
    private PreparedStatement selectMappingsAll;
    private PreparedStatement deleteSource;
    private PreparedStatement deleteMapSource;

    public PostgresVisitStore(Map<String, String> configuration) throws ClassNotFoundException, SQLException {
        super(configuration);
        this.projectId = (String)this.config.get("project");
        this.openDatabase(new String[]{"jdbc.", "data.jdbc."});
        this.initialize();
    }

    public PostgresVisitStore(DataSource ds, Map<String, String> configuration) throws SQLException {
        super(configuration);
        this.projectId = (String)this.config.get("project");
        this.openDatabase(ds);
        this.initialize();
    }

    private void initialize() throws SQLException {
        this.visitCache = new Hashtable();
        this.idCache = new Hashtable();
        this.idSourceDefault = "HIVE";
        this.idSourceSeparator = (char)58;
        this.db.setAutoCommit(true);
        this.loadMaxEncounterNum();
        this.batchLoad();
    }

    @Override
    protected void prepareStatements() throws SQLException {
        this.insert = this.db.prepareStatement("INSERT INTO visit_dimension(encounter_num, patient_num, import_date, download_date, sourcesystem_cd) VALUES(?,?,current_timestamp,?,?)");
        this.insertMapping = this.db.prepareStatement("INSERT INTO encounter_mapping(encounter_num, encounter_ide, encounter_ide_source, patient_ide, patient_ide_source, encounter_ide_status, project_id, import_date, download_date, sourcesystem_cd) VALUES(?,?,?,?,?,'A','" + this.projectId + "',current_timestamp,?,?)");
        this.update = this.db.prepareStatement("UPDATE visit_dimension SET active_status_cd=?, start_date=?, end_date=?, inout_cd=?, location_cd=?, update_date=current_timestamp, download_date=?, sourcesystem_cd=? WHERE encounter_num=?");
        this.selectAll = this.db.prepareStatement("SELECT encounter_num, patient_num, active_status_cd, start_date, end_date, inout_cd, location_cd, download_date, sourcesystem_cd FROM visit_dimension", 1003, 1007);
        this.selectAll.setFetchSize(this.getFetchSize());
        this.selectMappingsAll = this.db.prepareStatement("SELECT encounter_num, encounter_ide, encounter_ide_source, patient_ide, patient_ide_source, encounter_ide_status, project_id FROM encounter_mapping ORDER BY encounter_num", 1003, 1007);
        this.selectMappingsAll.setFetchSize(this.getFetchSize());
        this.deleteSource = this.db.prepareStatement("DELETE FROM visit_dimension WHERE sourcesystem_cd=?");
        this.deleteMapSource = this.db.prepareStatement("DELETE FROM encounter_mapping WHERE sourcesystem_cd=?");
    }

    public int size() {
        return this.visitCache.size();
    }

    private void loadMaxEncounterNum() throws SQLException {
        try (Statement s = this.db.createStatement();){
            String sql = "SELECT MAX(encounter_num) FROM visit_dimension";
            ResultSet rs = s.executeQuery(sql);
            this.maxEncounterNum = rs.next() ? rs.getInt(1) : 1;
            rs.close();
        }
        log.info("MAX(encounter_num) = " + this.maxEncounterNum);
    }

    public void loadMaxInstanceNums() throws SQLException {
        log.info("Loading maximum instance_num for each encounter");
        Statement stmt = this.db.createStatement(1003, 1007);
        String sql = "SELECT patient_num, encounter_num, MAX(instance_num) FROM observation_fact GROUP BY patient_num, encounter_num";
        int count = 0;
        int noMatch = 0;
        try (ResultSet rs = stmt.executeQuery("SELECT patient_num, encounter_num, MAX(instance_num) FROM observation_fact GROUP BY patient_num, encounter_num");){
            while (rs.next()) {
                I2b2Visit v = this.visitCache.get(rs.getInt(2));
                if (v != null) {
                    v.maxInstanceNum = rs.getInt(3);
                } else {
                    ++noMatch;
                }
                ++count;
            }
        }
        stmt.close();
        log.info("Loaded MAX(instance_num) for " + count + " encounters");
        if (noMatch != 0) {
            log.warning("Encountered " + noMatch + " encounter_num in observation_fact without matching visits");
        }
    }

    private String pasteId(String source, String ide) {
        if (source == null || source.equals(this.idSourceDefault)) {
            return ide;
        }
        return source + ":" + ide;
    }

    private String[] splitId(String id) {
        String ide;
        String ids;
        int p = id.indexOf(this.idSourceSeparator);
        if (p == -1) {
            ids = this.idSourceDefault;
            ide = id;
        } else {
            ids = id.substring(0, p);
            ide = id.substring(p + 1);
        }
        return new String[]{ids, ide};
    }

    private void setAliases(I2b2Visit visit, String[] aliases, int primary) {
        visit.aliasIds = aliases;
        visit.primaryAliasIndex = primary;
        visit.setId(aliases[primary]);
        for (String id : aliases) {
            this.idCache.put(id, visit);
        }
    }

    private void batchSetAliases(int num, ArrayList<String> aliases, int primary) {
        I2b2Visit visit = this.visitCache.get(num);
        if (visit == null) {
            log.warning("Missing row in visit_dimension for encounter_mapping.encounter_num=" + num);
        } else {
            this.setAliases(visit, aliases.toArray(new String[aliases.size()]), primary);
        }
    }

    private void batchLoad() throws SQLException {
        try (ResultSet rs = this.selectAll.executeQuery();){
            while (rs.next()) {
                I2b2Visit visit = this.loadFromResultSet(rs);
                this.visitCache.put(visit.getNum(), visit);
            }
        }
        rs = this.selectMappingsAll.executeQuery();
        var2_2 = null;
        try {
            int num = -1;
            ArrayList<String> ids = new ArrayList<String>(16);
            int primary = 0;
            while (rs.next()) {
                if (num == -1) {
                    num = rs.getInt(1);
                } else if (num != rs.getInt(1)) {
                    this.batchSetAliases(num, ids, primary);
                    ids.clear();
                    num = rs.getInt(1);
                    primary = 0;
                }
                String id = this.pasteId(rs.getString(3), rs.getString(2));
                if (rs.getString(6).equals("A") && rs.getString(7).equals(this.projectId)) {
                    primary = ids.size();
                }
                ids.add(id);
            }
            if (num != -1) {
                this.batchSetAliases(num, ids, primary);
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (var2_2 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStorage(I2b2Visit visit) throws SQLException {
        PreparedStatement preparedStatement = this.update;
        synchronized (preparedStatement) {
            this.update.setString(1, PostgresVisitStore.getActiveStatusCd((Visit)visit));
            this.update.setTimestamp(2, PostgresVisitStore.inaccurateSqlTimestamp(visit.getStartTime()));
            this.update.setTimestamp(3, PostgresVisitStore.inaccurateSqlTimestamp(visit.getEndTime()));
            this.update.setString(4, PostgresVisitStore.getInOutCd((Visit)visit));
            this.update.setString(5, visit.getLocationId());
            this.update.setTimestamp(6, Timestamp.from(visit.getSourceTimestamp()));
            this.update.setString(7, visit.getSourceId());
            this.update.setInt(8, visit.getNum());
            int rows = this.update.executeUpdate();
            if (rows == 0) {
                log.warning("UPDATE executed for visit_dimension.encounter_num=" + visit.getNum() + ", but no rows changed.");
            }
            visit.markDirty(false);
        }
    }

    private static String getInOutCd(Visit patient) {
        if (patient.getStatus() == null) {
            return null;
        }
        switch (patient.getStatus()) {
            case Inpatient: {
                return "I";
            }
            case Outpatient: 
            case Emergency: {
                return "O";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToStorage(I2b2Visit visit) throws SQLException {
        PreparedStatement preparedStatement = this.insert;
        synchronized (preparedStatement) {
            this.insert.setInt(1, visit.getNum());
            this.insert.setInt(2, visit.getPatientNum());
            this.insert.setTimestamp(3, Timestamp.from(visit.getSourceTimestamp()));
            this.insert.setString(4, visit.getSourceId());
            this.insert.executeUpdate();
        }
        preparedStatement = this.insertMapping;
        synchronized (preparedStatement) {
            this.insertMapping.setInt(1, visit.getNum());
            String[] ids = this.splitId(visit.getId());
            this.insertMapping.setString(2, ids[1]);
            this.insertMapping.setString(3, ids[0]);
            ids = this.splitId(visit.getPatientId());
            this.insertMapping.setString(4, ids[1]);
            this.insertMapping.setString(5, ids[0]);
            this.insertMapping.setTimestamp(6, Timestamp.from(visit.getSourceTimestamp()));
            this.insertMapping.setString(7, visit.getSourceId());
            this.insertMapping.executeUpdate();
        }
    }

    private static String getActiveStatusCd(Visit visit) {
        char end_char = '\u0000';
        char start_char = '\u0000';
        if (visit.getEndTime() != null) {
            switch (visit.getEndTime().getAccuracy()) {
                case DAYS: {
                    end_char = 'Y';
                    break;
                }
                case MONTHS: {
                    end_char = 'M';
                    break;
                }
                case YEARS: {
                    end_char = 'X';
                    break;
                }
                case HOURS: {
                    end_char = 'R';
                    break;
                }
                case MINUTES: {
                    end_char = 'T';
                    break;
                }
                case SECONDS: {
                    end_char = 'S';
                    break;
                }
            }
        }
        if (visit.getStartTime() != null) {
            switch (visit.getStartTime().getAccuracy()) {
                case DAYS: {
                    end_char = 'D';
                    end_char = '\u0000';
                    break;
                }
                case MONTHS: {
                    end_char = 'B';
                    break;
                }
                case YEARS: {
                    end_char = 'F';
                    break;
                }
                case HOURS: {
                    end_char = 'H';
                    break;
                }
                case MINUTES: {
                    end_char = 'I';
                    break;
                }
                case SECONDS: {
                    end_char = 'C';
                    break;
                }
            }
        }
        if (end_char != '\u0000' && start_char != '\u0000') {
            return new String(new char[]{end_char, start_char});
        }
        if (end_char != '\u0000') {
            return new String(new char[]{end_char});
        }
        if (start_char != '\u0000') {
            return new String(new char[]{start_char});
        }
        return null;
    }

    private void setActiveStatusCd(Visit patient, String vital_cd) {
        if (vital_cd == null) {
            return;
        }
        ChronoUnit accuracy = null;
        char birthIndicator = '\u0000';
        switch (vital_cd.charAt(0)) {
            case 'O': 
            case 'U': {
                break;
            }
            case '\u0000': 
            case 'Y': {
                accuracy = ChronoUnit.DAYS;
                break;
            }
            case 'M': {
                accuracy = ChronoUnit.MONTHS;
                break;
            }
            case 'X': {
                accuracy = ChronoUnit.YEARS;
                break;
            }
            case 'R': {
                accuracy = ChronoUnit.HOURS;
                break;
            }
            case 'T': {
                accuracy = ChronoUnit.MINUTES;
                break;
            }
            case 'S': {
                accuracy = ChronoUnit.SECONDS;
                break;
            }
            default: {
                birthIndicator = vital_cd.charAt(0);
            }
        }
        if (patient.getEndTime() != null && accuracy != null) {
            patient.getEndTime().setAccuracy(accuracy);
        }
        if (birthIndicator == '\u0000' && vital_cd.length() > 1) {
            birthIndicator = vital_cd.charAt(1);
        }
        switch (birthIndicator) {
            case 'A': 
            case 'L': {
                break;
            }
            case '\u0000': 
            case 'D': {
                accuracy = ChronoUnit.DAYS;
                break;
            }
            case 'B': {
                accuracy = ChronoUnit.MONTHS;
                break;
            }
            case 'F': {
                accuracy = ChronoUnit.YEARS;
                break;
            }
            case 'H': {
                accuracy = ChronoUnit.HOURS;
                break;
            }
            case 'I': {
                accuracy = ChronoUnit.MINUTES;
                break;
            }
            case 'C': {
                accuracy = ChronoUnit.SECONDS;
            }
        }
        if (patient.getStartTime() != null && accuracy != null) {
            patient.getStartTime().setAccuracy(accuracy);
        }
    }

    private I2b2Visit loadFromResultSet(ResultSet rs) throws SQLException {
        int id = rs.getInt(1);
        int patid = rs.getInt(2);
        String active_status_cd = rs.getString(3);
        if (active_status_cd != null && active_status_cd.length() == 0) {
            active_status_cd = null;
        }
        DateTimeAccuracy startDate = null;
        DateTimeAccuracy endDate = null;
        Timestamp ts = rs.getTimestamp(4);
        if (ts != null) {
            startDate = new DateTimeAccuracy(ts.toLocalDateTime());
        }
        if ((ts = rs.getTimestamp(5)) != null) {
            endDate = new DateTimeAccuracy(ts.toLocalDateTime());
        }
        String inout_cd = rs.getString(6);
        Visit.Status status = null;
        if (inout_cd != null) {
            switch (inout_cd.charAt(0)) {
                case 'I': {
                    status = Visit.Status.Inpatient;
                    break;
                }
                case 'O': {
                    status = Visit.Status.Outpatient;
                }
            }
        }
        I2b2Visit visit = new I2b2Visit(id, patid);
        visit.setStartTime(startDate);
        visit.setEndTime(endDate);
        visit.setStatus(status);
        this.setActiveStatusCd((Visit)visit, active_status_cd);
        visit.setLocationId(rs.getString(7));
        visit.setSourceTimestamp(rs.getTimestamp(8).toInstant());
        visit.setSourceId(rs.getString(9));
        visit.markDirty(false);
        return visit;
    }

    private void insertionException(I2b2Visit visit, SQLException e) {
        log.log(Level.SEVERE, "Unable to insert visit " + visit.getId(), e);
    }

    private void updateException(I2b2Visit visit, SQLException e) {
        log.log(Level.SEVERE, "Unable to update visit " + visit.getId(), e);
    }

    private I2b2Visit getOrCreateInstance(String encounterId, I2b2Patient patient, ExternalSourceType source) {
        I2b2Visit visit = this.idCache.get(encounterId);
        if (visit == null) {
            ++this.maxEncounterNum;
            int encounter_num = this.maxEncounterNum;
            visit = new I2b2Visit(encounter_num, patient.getNum());
            visit.setPatientId(patient.getId());
            visit.setSourceId(source.getSourceId());
            visit.setSourceTimestamp(source.getSourceTimestamp());
            this.visitCache.put(encounter_num, visit);
            this.setAliases(visit, new String[]{encounterId}, 0);
            try {
                this.addToStorage(visit);
            }
            catch (SQLException e) {
                this.insertionException(visit, e);
            }
        }
        return visit;
    }

    public I2b2Visit createInstance(Observation fact) {
        return this.getOrCreateInstance(fact.getEncounterId(), (I2b2Patient)((Object)fact.getExtension(I2b2Patient.class)), fact.getSource());
    }

    public Class<?>[] getInstanceTypes() {
        return INSTANCE_TYPES;
    }

    public I2b2Visit findVisit(String id) {
        return this.idCache.get(id);
    }

    @Override
    public void deleteWhereSourceId(String sourceId) throws SQLException {
        this.deleteSource.setString(1, sourceId);
        int numRows = this.deleteSource.executeUpdate();
        log.info("Deleted " + numRows + " rows with sourcesystem_cd = " + sourceId);
        this.deleteMapSource.setString(1, sourceId);
        this.deleteMapSource.executeUpdate();
        Enumeration<I2b2Visit> all = this.visitCache.elements();
        LinkedList<I2b2Visit> remove = new LinkedList<I2b2Visit>();
        while (all.hasMoreElements()) {
            I2b2Visit p = all.nextElement();
            if (p.getSourceId() == null || !p.getSourceId().equals(sourceId)) continue;
            remove.add(p);
        }
        for (I2b2Visit p : remove) {
            this.visitCache.remove(p.getNum());
            for (String id : p.aliasIds) {
                this.idCache.remove(id);
            }
        }
        this.loadMaxEncounterNum();
    }

    public I2b2Visit createInstance(Object ... args) throws UnsupportedOperationException {
        if (!(args.length == 3 && args[0] instanceof String && args[1] instanceof I2b2Patient && args[2] instanceof ExternalSourceType)) {
            throw new IllegalArgumentException("Need arguments String visitId, I2b2Patient patient, ExternalSourceType source");
        }
        return this.getOrCreateInstance((String)args[0], (I2b2Patient)((Object)args[1]), (ExternalSourceType)args[2]);
    }

    @Override
    public void flush() {
        Iterator dirty = StoredExtensionType.dirtyIterator(this.visitCache.elements());
        int count = 0;
        while (dirty.hasNext()) {
            I2b2Visit visit = (I2b2Visit)((Object)dirty.next());
            try {
                this.updateStorage(visit);
                ++count;
            }
            catch (SQLException e) {
                this.updateException(visit, e);
            }
        }
        if (count != 0) {
            log.info("Updated " + count + " visits in database");
        }
    }
}

