/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.DateTimeAccuracy;
import de.sekmi.histream.Extension;
import de.sekmi.histream.Plugin;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;

public abstract class PostgresExtension<T>
implements Extension<T>,
Plugin {
    private static final int defaultFetchSize = 10000;
    private static final String driver = "org.postgresql.Driver";
    protected Map<String, String> config;
    protected Connection db;

    protected PostgresExtension(Map<String, String> configuration) {
        this.config = configuration;
    }

    public static Connection getConnection(Map<String, String> props, String[] prefixes) throws SQLException, ClassNotFoundException {
        Properties jdbc = new Properties();
        for (String prefix : prefixes) {
            PostgresExtension.copyProperties(props, prefix, jdbc);
        }
        return PostgresExtension.getConnection(jdbc);
    }

    private static Connection getConnection(Properties props) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        return DriverManager.getConnection("jdbc:postgresql://" + props.get("host") + ":" + props.get("port") + "/" + props.get("database"), props);
    }

    public static void copyProperties(Map<String, String> src, String keyPrefix, Properties dest) {
        src.forEach((key, value) -> {
            if (key.startsWith(keyPrefix)) {
                dest.put(key.substring(keyPrefix.length()), value);
            }
        });
    }

    protected void openDatabase(String[] propertyPrefixes) throws ClassNotFoundException, SQLException {
        this.db = PostgresExtension.getConnection(this.config, propertyPrefixes);
        this.prepareStatements();
    }

    public void close() throws IOException {
        this.flush();
        try {
            if (this.db != null && !this.db.isClosed()) {
                this.db.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public static Timestamp inaccurateSqlTimestamp(DateTimeAccuracy dateTime) {
        if (dateTime == null) {
            return null;
        }
        return Timestamp.valueOf(dateTime.getLocal());
    }

    public int getFetchSize() {
        if (this.config.containsKey("fetchSize")) {
            return Integer.parseInt(this.config.get("fetchSize"));
        }
        return 10000;
    }

    public abstract void flush();

    public abstract void deleteWhereSourceId(String var1) throws SQLException;

    protected abstract void prepareStatements() throws SQLException;
}

