/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.Modifier;
import de.sekmi.histream.Observation;
import de.sekmi.histream.ObservationException;
import de.sekmi.histream.ObservationHandler;
import de.sekmi.histream.Plugin;
import de.sekmi.histream.Value;
import de.sekmi.histream.i2b2.I2b2Patient;
import de.sekmi.histream.i2b2.I2b2Visit;
import de.sekmi.histream.i2b2.PostgresExtension;
import de.sekmi.histream.impl.AbstractObservationHandler;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class I2b2Inserter
extends AbstractObservationHandler
implements ObservationHandler,
Closeable,
Plugin {
    private static final Logger log = Logger.getLogger(I2b2Inserter.class.getName());
    private Connection db;
    private PreparedStatement insertFact;
    private PreparedStatement deleteSource;
    private PreparedStatement deleteVisit;
    private String nullProviderId;
    private String nullUnitCd = "@";
    private String nullLocationCd = "@";
    private String nullModifierCd = "@";
    private String nullValueFlagCd = "@";
    private String nullValueTypeCd = "@";
    private Preprocessor etlPreprocessor;
    private int insertCount = 0;

    public I2b2Inserter(Map<String, String> config) throws ClassNotFoundException, SQLException {
        this.open(config);
    }

    public synchronized void purgeSource(String sourceId) throws SQLException {
        this.deleteSource.setString(1, sourceId);
        int rows = this.deleteSource.executeUpdate();
        this.db.commit();
        log.info("Deleted " + rows + " rows for sourcesystem_cd=" + sourceId);
    }

    public synchronized void purgeVisit(int encounter_num) throws SQLException {
        this.deleteVisit.setInt(1, encounter_num);
        int rows = this.deleteVisit.executeUpdate();
        this.db.commit();
        log.info("Deleted " + rows + " rows for encounter_num=" + encounter_num);
    }

    private void prepareStatements(Map<String, String> props) throws SQLException {
        this.insertFact = this.db.prepareStatement("INSERT INTO observation_fact (encounter_num, patient_num, concept_cd, provider_id, start_date, modifier_cd, instance_num, valtype_cd, tval_char, nval_num, valueflag_cd, units_cd, end_date, location_cd, update_date, download_date, import_date, sourcesystem_cd, upload_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?,current_timestamp, ?, current_timestamp, ?, NULL)");
        this.deleteSource = this.db.prepareStatement("DELETE FROM observation_fact WHERE sourcesystem_cd=?");
        this.deleteVisit = this.db.prepareStatement("DELETE FROM observation_fact WHERE encounter_num=?");
    }

    private void open(Map<String, String> props) throws SQLException, ClassNotFoundException {
        this.db = PostgresExtension.getConnection(props, new String[]{"jdbc.", "data.jdbc."});
        this.db.setAutoCommit(false);
        this.nullProviderId = props.get("nullProvider");
        if (this.nullProviderId == null) {
            log.warning("property 'nullProvider' missing, using '@' (may violate foreign keys)");
            this.nullProviderId = "@";
        }
        this.prepareStatements(props);
    }

    public void acceptOrException(Observation o) throws ObservationException {
        if (this.etlPreprocessor != null) {
            try {
                this.etlPreprocessor.preprocess(o);
            }
            catch (SQLException e) {
                this.reportError(new ObservationException(o, (Throwable)e));
            }
        }
        try {
            this.insertFact(o, null, 1);
            this.db.commit();
            ++this.insertCount;
        }
        catch (SQLException e) {
            try {
                this.db.rollback();
            }
            catch (SQLException suppressed) {
                e.addSuppressed(suppressed);
            }
            throw new ObservationException(o, (Throwable)e);
        }
    }

    private static String getI2b2Operator(Value value) {
        String op;
        if (value.getOperator() == null) {
            return "E";
        }
        switch (value.getOperator()) {
            case Equal: {
                op = "E";
                break;
            }
            case NotEqual: {
                op = "NE";
                break;
            }
            case LessThan: {
                op = "L";
                break;
            }
            case LessOrEqual: {
                op = "LE";
                break;
            }
            case GreaterThan: {
                op = "G";
                break;
            }
            case GreaterOrEqual: {
                op = "GE";
                break;
            }
            default: {
                op = "E";
            }
        }
        return op;
    }

    private static String getI2b2ValueFlagCd(Value value) {
        String flag;
        if (value.getAbnormalFlag() == null) {
            flag = null;
        } else {
            switch (value.getAbnormalFlag()) {
                case Abnormal: {
                    flag = "A";
                }
            }
            flag = null;
        }
        return flag;
    }

    private int incrementInstanceNum(Observation o) {
        try {
            I2b2Visit v = (I2b2Visit)((Object)o.getExtension(I2b2Visit.class));
            ++v.maxInstanceNum;
            return v.maxInstanceNum;
        }
        catch (IllegalArgumentException e) {
            return 1;
        }
    }

    private static <T> T replaceNull(T value, T nullReplacement) {
        return value == null ? nullReplacement : value;
    }

    private int getPatientNum(Observation o) {
        try {
            I2b2Patient patient = (I2b2Patient)((Object)o.getExtension(I2b2Patient.class));
            return patient.getNum();
        }
        catch (IllegalArgumentException e) {
            return Integer.parseInt(o.getPatientId());
        }
    }

    private int getEncounterNum(Observation o) {
        I2b2Visit visit = (I2b2Visit)((Object)o.getExtension(I2b2Visit.class));
        return visit.getNum();
    }

    private synchronized void insertFact(Observation o, Modifier m, int instanceNum) throws SQLException {
        Value v;
        if (m == null && o.hasModifiers()) {
            instanceNum = this.incrementInstanceNum(o);
        }
        this.insertFact.setInt(1, this.getEncounterNum(o));
        this.insertFact.setInt(2, this.getPatientNum(o));
        this.insertFact.setString(3, o.getConceptId());
        this.insertFact.setString(4, I2b2Inserter.replaceNull(o.getProviderId(), this.nullProviderId));
        Objects.requireNonNull(o.getStartTime());
        this.insertFact.setTimestamp(5, Timestamp.valueOf(o.getStartTime().getLocal()));
        this.insertFact.setString(6, m == null ? this.nullModifierCd : m.getConceptId());
        this.insertFact.setInt(7, instanceNum);
        Value value = v = m == null ? o.getValue() : m.getValue();
        if (v == null) {
            this.insertFact.setString(8, this.nullValueTypeCd);
            this.insertFact.setString(9, null);
            this.insertFact.setBigDecimal(10, null);
            this.insertFact.setString(11, this.nullValueFlagCd);
            this.insertFact.setString(12, this.nullUnitCd);
        } else {
            switch (v.getType()) {
                case Numeric: {
                    this.insertFact.setString(8, "N");
                    this.insertFact.setString(9, I2b2Inserter.getI2b2Operator(v));
                    this.insertFact.setBigDecimal(10, v.getNumericValue());
                    this.insertFact.setString(11, I2b2Inserter.getI2b2ValueFlagCd(v));
                    this.insertFact.setString(12, I2b2Inserter.replaceNull(v.getUnits(), this.nullUnitCd));
                    break;
                }
                case Text: {
                    this.insertFact.setString(8, "T");
                    this.insertFact.setString(9, v.getStringValue());
                    this.insertFact.setBigDecimal(10, null);
                    this.insertFact.setString(11, I2b2Inserter.getI2b2ValueFlagCd(v));
                    this.insertFact.setString(12, I2b2Inserter.replaceNull(v.getUnits(), this.nullUnitCd));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Incomplete refactoring, unsupported value type " + v.getType());
                }
            }
        }
        if (o.getEndTime() == null) {
            this.insertFact.setTimestamp(13, null);
        } else {
            this.insertFact.setTimestamp(13, Timestamp.valueOf(o.getEndTime().getLocal()));
        }
        this.insertFact.setString(14, I2b2Inserter.replaceNull(o.getLocationId(), this.nullLocationCd));
        this.insertFact.setTimestamp(15, Timestamp.from(o.getSource().getSourceTimestamp()));
        this.insertFact.setString(16, o.getSource().getSourceId());
        this.insertFact.executeUpdate();
        if (o.hasModifiers() && m == null) {
            Iterator e = o.getModifiers();
            while (e.hasNext()) {
                Modifier mod = (Modifier)e.next();
                this.insertFact(o, mod, instanceNum);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.db.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        log.info("Inserted " + this.insertCount + " facts");
    }

    public void setMeta(String key, String value) {
        if (key.equals("etl.strategy")) {
            switch (value) {
                case "replace-visit": {
                    this.etlPreprocessor = new DistinctVisitPurge();
                    break;
                }
                case "replace-source": {
                    this.etlPreprocessor = new UniqueSourcePurge();
                    break;
                }
                case "insert": {
                    this.etlPreprocessor = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown etl strategy " + value);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown meta key " + key);
        }
    }

    public int getInsertCount() {
        return this.insertCount;
    }

    public void resetInsertCount() {
        this.insertCount = 0;
    }

    private class UniqueSourcePurge
    implements Preprocessor {
        private Set<String> purgedSources = new HashSet<String>();

        @Override
        public void preprocess(Observation fact) throws SQLException {
            String sourceId = fact.getSource().getSourceId();
            if (!this.purgedSources.contains(sourceId)) {
                this.purgedSources.add(sourceId);
                I2b2Inserter.this.purgeSource(sourceId);
            }
        }
    }

    private class DistinctVisitPurge
    implements Preprocessor {
        private I2b2Visit prev;

        private DistinctVisitPurge() {
        }

        @Override
        public void preprocess(Observation fact) throws SQLException {
            I2b2Visit current = (I2b2Visit)((Object)fact.getExtension(I2b2Visit.class));
            if (current != this.prev) {
                I2b2Inserter.this.purgeVisit(current.getNum());
                this.prev = current;
            }
        }
    }

    private static interface Preprocessor {
        public void preprocess(Observation var1) throws SQLException;
    }
}

