/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.impl.VisitImpl;
import java.time.temporal.ChronoUnit;

public class I2b2Visit
extends VisitImpl {
    private int encounter_num;
    private int patient_num;
    String[] aliasIds;
    int primaryAliasIndex;
    int maxInstanceNum;

    public I2b2Visit(int encounter_num, int patient_num) {
        this.encounter_num = encounter_num;
        this.patient_num = patient_num;
        this.maxInstanceNum = 1;
    }

    public int getNum() {
        return this.encounter_num;
    }

    public int getPatientNum() {
        return this.patient_num;
    }

    public String toString() {
        return "I2b2Visit(encounter_um=" + this.encounter_num + ")";
    }

    public String getActiveStatusCd() {
        I2b2Visit visit = this;
        char end_char = '\u0000';
        char start_char = '\u0000';
        if (visit.getEndTime() != null) {
            switch (visit.getEndTime().getAccuracy()) {
                case DAYS: {
                    end_char = '\u0000';
                    end_char = 'Y';
                    break;
                }
                case MONTHS: {
                    end_char = 'M';
                    break;
                }
                case YEARS: {
                    end_char = 'X';
                    break;
                }
                case HOURS: {
                    end_char = 'R';
                    break;
                }
                case MINUTES: {
                    end_char = 'T';
                    break;
                }
                case SECONDS: {
                    end_char = 'S';
                    break;
                }
            }
        } else {
            end_char = 'U';
        }
        if (visit.getStartTime() != null) {
            switch (visit.getStartTime().getAccuracy()) {
                case DAYS: {
                    start_char = '\u0000';
                    start_char = 'D';
                    break;
                }
                case MONTHS: {
                    start_char = 'B';
                    break;
                }
                case YEARS: {
                    start_char = 'F';
                    break;
                }
                case HOURS: {
                    start_char = 'H';
                    break;
                }
                case MINUTES: {
                    start_char = 'I';
                    break;
                }
                case SECONDS: {
                    start_char = 'C';
                    break;
                }
            }
        } else {
            start_char = 'L';
        }
        if (end_char != '\u0000' && start_char != '\u0000') {
            return new String(new char[]{end_char, start_char});
        }
        if (end_char != '\u0000') {
            return new String(new char[]{end_char});
        }
        if (start_char != '\u0000') {
            return new String(new char[]{start_char});
        }
        return null;
    }

    public void setActiveStatusCd(String vital_cd) {
        I2b2Visit visit = this;
        int endIndicator = 0;
        int startIndicator = 0;
        if (vital_cd != null && vital_cd.length() != 0) {
            endIndicator = vital_cd.charAt(0);
        }
        ChronoUnit accuracy = null;
        switch (endIndicator) {
            case 79: 
            case 85: {
                visit.setEndTime(null);
                break;
            }
            case 0: 
            case 89: {
                accuracy = ChronoUnit.DAYS;
                break;
            }
            case 77: {
                accuracy = ChronoUnit.MONTHS;
                break;
            }
            case 88: {
                accuracy = ChronoUnit.YEARS;
                break;
            }
            case 82: {
                accuracy = ChronoUnit.HOURS;
                break;
            }
            case 84: {
                accuracy = ChronoUnit.MINUTES;
                break;
            }
            case 83: {
                accuracy = ChronoUnit.SECONDS;
                break;
            }
            default: {
                accuracy = ChronoUnit.DAYS;
                startIndicator = endIndicator;
            }
        }
        if (visit.getEndTime() != null && accuracy != null) {
            visit.getEndTime().setAccuracy(accuracy);
        }
        if (vital_cd != null && vital_cd.length() > 1) {
            startIndicator = vital_cd.charAt(1);
        }
        accuracy = null;
        switch (startIndicator) {
            case 65: 
            case 76: {
                this.setStartTime(null);
                break;
            }
            case 0: 
            case 68: {
                accuracy = ChronoUnit.DAYS;
                break;
            }
            case 66: {
                accuracy = ChronoUnit.MONTHS;
                break;
            }
            case 70: {
                accuracy = ChronoUnit.YEARS;
                break;
            }
            case 72: {
                accuracy = ChronoUnit.HOURS;
                break;
            }
            case 73: {
                accuracy = ChronoUnit.MINUTES;
                break;
            }
            case 67: {
                accuracy = ChronoUnit.SECONDS;
                break;
            }
            default: {
                accuracy = ChronoUnit.DAYS;
            }
        }
        if (visit.getStartTime() != null && accuracy != null) {
            visit.getStartTime().setAccuracy(accuracy);
        }
    }

    public String getInOutCd() {
        I2b2Visit patient = this;
        if (patient.getStatus() == null) {
            return null;
        }
        switch (patient.getStatus()) {
            case Inpatient: {
                return "I";
            }
            case Outpatient: 
            case Emergency: {
                return "O";
            }
        }
        return null;
    }
}

