/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.DateTimeAccuracy;
import de.sekmi.histream.ext.Patient;
import de.sekmi.histream.impl.PatientImpl;
import java.time.temporal.ChronoUnit;

public class I2b2Patient
extends PatientImpl {
    private int patient_num;
    String[] mergedIds;

    public I2b2Patient(int num) {
        this.patient_num = num;
    }

    public I2b2Patient(int num, Patient.Sex sex, DateTimeAccuracy birthDate, DateTimeAccuracy deathDate) {
        this(num);
        this.setSex(sex);
        this.setBirthDate(birthDate);
        this.setDeathDate(deathDate);
    }

    public int getNum() {
        return this.patient_num;
    }

    public void setNum(int patient_num) {
        this.patient_num = patient_num;
    }

    public String getVitalStatusCd() {
        I2b2Patient patient = this;
        char death_char = '\u0000';
        char birth_char = '\u0000';
        if (patient.getDeathDate() != null) {
            switch (patient.getDeathDate().getAccuracy()) {
                case DAYS: {
                    death_char = 'Y';
                    break;
                }
                case MONTHS: {
                    death_char = 'M';
                    break;
                }
                case YEARS: {
                    death_char = 'X';
                    break;
                }
                case HOURS: {
                    death_char = 'R';
                    break;
                }
                case MINUTES: {
                    death_char = 'T';
                    break;
                }
                case SECONDS: {
                    death_char = 'S';
                    break;
                }
            }
        } else {
            Boolean deceased = patient.getDeceased();
            if (deceased == null) {
                death_char = 'U';
            } else if (deceased.booleanValue()) {
                death_char = 'Z';
            } else if (!deceased.booleanValue()) {
                death_char = '\u0000';
                death_char = 'N';
            }
        }
        if (patient.getBirthDate() != null) {
            switch (patient.getBirthDate().getAccuracy()) {
                case DAYS: {
                    birth_char = 'D';
                    break;
                }
                case MONTHS: {
                    birth_char = 'B';
                    break;
                }
                case YEARS: {
                    birth_char = 'F';
                    break;
                }
                case HOURS: {
                    birth_char = 'H';
                    break;
                }
                case MINUTES: {
                    birth_char = 'I';
                    break;
                }
                case SECONDS: {
                    birth_char = 'C';
                    break;
                }
            }
        } else {
            birth_char = 'L';
        }
        if (death_char != '\u0000' && birth_char != '\u0000') {
            return new String(new char[]{death_char, birth_char});
        }
        if (death_char != '\u0000') {
            return new String(new char[]{death_char});
        }
        if (birth_char != '\u0000') {
            return new String(new char[]{birth_char});
        }
        return null;
    }

    public void setVitalStatusCd(String vital_cd) {
        I2b2Patient patient = this;
        ChronoUnit accuracy = null;
        char birthIndicator = '\u0000';
        char deathIndicator = '\u0000';
        if (vital_cd == null || vital_cd.length() == 0) {
            birthIndicator = '\u0000';
            deathIndicator = '\u0000';
        } else {
            deathIndicator = vital_cd.charAt(0);
        }
        switch (deathIndicator) {
            case 'U': {
                this.setDeathDate(null);
                this.setDeceased(null);
                break;
            }
            case 'Z': {
                this.setDeathDate(null);
                this.setDeceased(true);
                break;
            }
            case 'Y': {
                accuracy = ChronoUnit.DAYS;
                break;
            }
            case 'M': {
                accuracy = ChronoUnit.MONTHS;
                break;
            }
            case 'X': {
                accuracy = ChronoUnit.YEARS;
                break;
            }
            case 'R': {
                accuracy = ChronoUnit.HOURS;
                break;
            }
            case 'T': {
                accuracy = ChronoUnit.MINUTES;
                break;
            }
            case 'S': {
                accuracy = ChronoUnit.SECONDS;
                break;
            }
            default: {
                birthIndicator = deathIndicator;
            }
            case '\u0000': 
            case 'N': {
                this.setDeathDate(null);
                this.setDeceased(false);
            }
        }
        if (patient.getDeathDate() != null && accuracy != null) {
            patient.getDeathDate().setAccuracy(accuracy);
            patient.setDeceased(true);
        }
        accuracy = null;
        if (vital_cd != null && vital_cd.length() > 1) {
            birthIndicator = vital_cd.charAt(1);
        }
        switch (birthIndicator) {
            case 'L': {
                this.setBirthDate(null);
                break;
            }
            case '\u0000': 
            case 'D': {
                accuracy = ChronoUnit.DAYS;
                break;
            }
            case 'B': {
                accuracy = ChronoUnit.MONTHS;
                break;
            }
            case 'F': {
                accuracy = ChronoUnit.YEARS;
                break;
            }
            case 'H': {
                accuracy = ChronoUnit.HOURS;
                break;
            }
            case 'I': {
                accuracy = ChronoUnit.MINUTES;
                break;
            }
            case 'C': {
                accuracy = ChronoUnit.SECONDS;
            }
        }
        if (patient.getBirthDate() != null && accuracy != null) {
            patient.getBirthDate().setAccuracy(accuracy);
        }
    }

    public String toString() {
        return "I2b2Patient(num=" + this.getNum() + ", id=" + this.getId() + ", dob=" + this.getBirthDate() + ")";
    }
}

