/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.Modifier;
import de.sekmi.histream.Observation;
import de.sekmi.histream.ObservationException;
import de.sekmi.histream.ObservationHandler;
import de.sekmi.histream.Plugin;
import de.sekmi.histream.Value;
import de.sekmi.histream.i2b2.DataDialect;
import de.sekmi.histream.i2b2.I2b2Patient;
import de.sekmi.histream.i2b2.I2b2Visit;
import de.sekmi.histream.impl.AbstractObservationHandler;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class I2b2Inserter
extends AbstractObservationHandler
implements ObservationHandler,
Closeable,
Plugin {
    private static final Logger log = Logger.getLogger(I2b2Inserter.class.getName());
    private Connection db;
    private PreparedStatement insertFact;
    private PreparedStatement deleteSource;
    private PreparedStatement deleteVisit;
    private Preprocessor etlPreprocessor;
    private DataDialect dialect;
    private int insertCount;

    public synchronized boolean purgeSource(String sourceId) throws SQLException {
        this.deleteSource.setString(1, sourceId);
        int rows = this.deleteSource.executeUpdate();
        this.db.commit();
        log.info("Deleted " + rows + " rows for sourcesystem_cd=" + sourceId);
        return 0 != rows;
    }

    public synchronized boolean purgeVisit(int encounter_num) throws SQLException {
        this.deleteVisit.setInt(1, encounter_num);
        int rows = this.deleteVisit.executeUpdate();
        this.db.commit();
        log.info("Deleted " + rows + " rows for encounter_num=" + encounter_num);
        return 0 != rows;
    }

    private void prepareStatements() throws SQLException {
        this.insertFact = this.db.prepareStatement("INSERT INTO observation_fact (encounter_num, patient_num, concept_cd, provider_id, start_date, modifier_cd, instance_num, valtype_cd, tval_char, nval_num, valueflag_cd, units_cd, end_date, location_cd, update_date, download_date, import_date, sourcesystem_cd, upload_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?,current_timestamp, ?, current_timestamp, ?, NULL)");
        this.deleteSource = this.db.prepareStatement("DELETE FROM observation_fact WHERE sourcesystem_cd=?");
        this.deleteVisit = this.db.prepareStatement("DELETE FROM observation_fact WHERE encounter_num=?");
    }

    public void open(Connection connection, DataDialect dialect) throws SQLException {
        this.dialect = dialect;
        this.db = connection;
        this.insertCount = 0;
        this.db.setAutoCommit(false);
        this.prepareStatements();
    }

    public void acceptOrException(Observation o) throws ObservationException {
        if (this.etlPreprocessor != null) {
            try {
                this.etlPreprocessor.preprocess(o);
            }
            catch (SQLException e) {
                throw new ObservationException("ETL preprocessing failed", (Throwable)e);
            }
        }
        try {
            this.insertFact(o, null, 1);
            this.db.commit();
            ++this.insertCount;
        }
        catch (SQLException e) {
            try {
                this.db.rollback();
            }
            catch (SQLException suppressed) {
                e.addSuppressed(suppressed);
            }
            throw new ObservationException("Insert failed", (Throwable)e);
        }
    }

    private int incrementInstanceNum(Observation o) {
        try {
            I2b2Visit v = (I2b2Visit)((Object)o.getExtension(I2b2Visit.class));
            ++v.maxInstanceNum;
            return v.maxInstanceNum;
        }
        catch (IllegalArgumentException e) {
            return 1;
        }
    }

    private int getPatientNum(Observation o) {
        try {
            I2b2Patient patient = (I2b2Patient)((Object)o.getExtension(I2b2Patient.class));
            return patient.getNum();
        }
        catch (IllegalArgumentException e) {
            return Integer.parseInt(o.getPatientId());
        }
    }

    private int getEncounterNum(Observation o) {
        try {
            I2b2Visit visit = (I2b2Visit)((Object)o.getExtension(I2b2Visit.class));
            return visit.getNum();
        }
        catch (IllegalArgumentException e) {
            return Integer.parseInt(o.getEncounterId());
        }
    }

    private synchronized void insertFact(Observation o, Modifier m, int instanceNum) throws SQLException {
        Value v;
        if (m == null && o.hasModifiers()) {
            instanceNum = this.incrementInstanceNum(o);
        }
        this.insertFact.setInt(1, this.getEncounterNum(o));
        this.insertFact.setInt(2, this.getPatientNum(o));
        this.insertFact.setString(3, o.getConceptId());
        this.insertFact.setString(4, this.dialect.encodeProviderId(o.getProviderId()));
        Objects.requireNonNull(o.getStartTime());
        this.insertFact.setTimestamp(5, this.dialect.encodeInstant(o.getStartTime().toInstantMin()));
        this.insertFact.setString(6, m == null ? this.dialect.getNullModifierCd() : m.getConceptId());
        this.insertFact.setInt(7, instanceNum);
        Value value = v = m == null ? o.getValue() : m.getValue();
        if (v == null) {
            this.insertFact.setString(8, this.dialect.getNullValueTypeCd());
            this.insertFact.setString(9, null);
            this.insertFact.setBigDecimal(10, null);
            this.insertFact.setString(11, this.dialect.getNullValueFlagCd());
            this.insertFact.setString(12, this.dialect.getNullUnitCd());
        } else {
            switch (v.getType()) {
                case Numeric: {
                    this.insertFact.setString(8, "N");
                    this.insertFact.setString(9, this.dialect.encodeOperator(v));
                    this.insertFact.setBigDecimal(10, v.getNumericValue());
                    this.insertFact.setString(11, this.dialect.encodeValueFlagCd(v));
                    this.insertFact.setString(12, this.dialect.encodeUnitCd(v.getUnits()));
                    break;
                }
                case Text: {
                    this.insertFact.setString(8, "T");
                    this.insertFact.setString(9, v.getStringValue());
                    this.insertFact.setBigDecimal(10, null);
                    this.insertFact.setString(11, this.dialect.encodeValueFlagCd(v));
                    this.insertFact.setString(12, this.dialect.encodeUnitCd(v.getUnits()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Incomplete refactoring, unsupported value type " + v.getType());
                }
            }
        }
        if (o.getEndTime() == null) {
            this.insertFact.setTimestamp(13, null);
        } else {
            this.insertFact.setTimestamp(13, this.dialect.encodeInstant(o.getEndTime().toInstantMin()));
        }
        this.insertFact.setString(14, this.dialect.encodeLocationCd(o.getLocationId()));
        this.insertFact.setTimestamp(15, this.dialect.encodeInstant(o.getSource().getSourceTimestamp()));
        this.insertFact.setString(16, o.getSource().getSourceId());
        this.insertFact.executeUpdate();
        if (o.hasModifiers() && m == null) {
            Iterator e = o.getModifiers();
            while (e.hasNext()) {
                Modifier mod = (Modifier)e.next();
                this.insertFact(o, mod, instanceNum);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.db.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        log.info("Inserted " + this.insertCount + " facts");
    }

    public void setMeta(String key, String value) {
        Objects.requireNonNull(key);
        if (key.equals("etl.strategy")) {
            if (value == null) {
                value = "insert";
            }
            switch (value) {
                case "replace-visit": {
                    this.etlPreprocessor = new DistinctVisitPurge();
                    break;
                }
                case "replace-source": {
                    this.etlPreprocessor = new UniqueSourcePurge();
                    break;
                }
                case "insert": {
                    this.etlPreprocessor = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown etl strategy " + value);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown meta key " + key);
        }
    }

    public int getInsertCount() {
        return this.insertCount;
    }

    public void resetInsertCount() {
        this.insertCount = 0;
    }

    private class UniqueSourcePurge
    implements Preprocessor {
        private Set<String> purgedSources = new HashSet<String>();

        @Override
        public void preprocess(Observation fact) throws SQLException {
            String sourceId = fact.getSource().getSourceId();
            if (!this.purgedSources.contains(sourceId)) {
                this.purgedSources.add(sourceId);
                I2b2Inserter.this.purgeSource(sourceId);
            }
        }
    }

    private class DistinctVisitPurge
    implements Preprocessor {
        private I2b2Visit prev;

        private DistinctVisitPurge() {
        }

        @Override
        public void preprocess(Observation fact) throws SQLException {
            I2b2Visit current = (I2b2Visit)((Object)fact.getExtension(I2b2Visit.class));
            if (current != this.prev) {
                I2b2Inserter.this.purgeVisit(current.getNum());
                this.prev = current;
            }
        }
    }

    private static interface Preprocessor {
        public void preprocess(Observation var1) throws SQLException;
    }
}

