/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.AbnormalFlag;
import de.sekmi.histream.DateTimeAccuracy;
import de.sekmi.histream.Value;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;

public class DataDialect {
    private String nullProviderId = "@";
    private String nullUnitCd = "@";
    private String nullLocationCd = "@";
    private String nullModifierCd = "@";
    private String nullValueFlagCd = "@";
    private String nullValueTypeCd = "@";
    private ZoneId zoneId = ZoneId.systemDefault();

    void setDefaultProviderId(String providerId) {
        this.nullProviderId = providerId;
    }

    public void setTimeZone(ZoneId zone) {
        this.zoneId = zone;
    }

    public String getDefaultProviderId() {
        return this.nullProviderId;
    }

    public String getNullUnitCd() {
        return this.nullUnitCd;
    }

    public String getNullLocationCd() {
        return this.nullLocationCd;
    }

    public ZoneId getTimeZone() {
        return this.zoneId;
    }

    public String getNullModifierCd() {
        return this.nullModifierCd;
    }

    public String getNullValueFlagCd() {
        return this.nullValueFlagCd;
    }

    public String getNullValueTypeCd() {
        return this.nullValueTypeCd;
    }

    public Timestamp encodeInstant(Instant instant) {
        if (instant == null) {
            return null;
        }
        return Timestamp.from(instant);
    }

    public Timestamp encodeInstantPartial(DateTimeAccuracy instant) {
        if (instant == null) {
            return null;
        }
        return this.encodeInstant(instant.toInstantMin());
    }

    public Instant decodeInstant(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestamp.toInstant();
    }

    public DateTimeAccuracy decodeInstantPartial(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new DateTimeAccuracy(this.decodeInstant(timestamp));
    }

    private boolean isNullComparison(String value, String nullValue) {
        if (value == null) {
            return true;
        }
        return nullValue != null && value.equals(nullValue);
    }

    public boolean isDefaultProviderId(String providerId) {
        return this.isNullComparison(providerId, this.getDefaultProviderId());
    }

    public boolean isNullLocationCd(String locationCd) {
        return this.isNullComparison(locationCd, this.getNullLocationCd());
    }

    private <T> T encodeNull(T value, T nullReplacement) {
        return value == null ? nullReplacement : value;
    }

    private <T> T decodeNull(T value, T nullReplacement) {
        if (value == null) {
            return null;
        }
        if (nullReplacement != null && nullReplacement.equals(value)) {
            return null;
        }
        return value;
    }

    public String encodeLocationCd(String locationCd) {
        return this.encodeNull(locationCd, this.getNullLocationCd());
    }

    public String encodeUnitCd(String unitCd) {
        return this.encodeNull(unitCd, this.getNullUnitCd());
    }

    public String decodeUnitCd(String rowValue) {
        return this.decodeNull(rowValue, this.nullUnitCd);
    }

    public String decodeValueTypeCd(String rowValue) {
        return this.decodeNull(rowValue, this.nullValueTypeCd);
    }

    public String encodeProviderId(String providerId) {
        return this.encodeNull(providerId, this.getDefaultProviderId());
    }

    public String decodeModifierCd(String rowValue) {
        return this.decodeNull(rowValue, this.nullModifierCd);
    }

    public String decodeLocationCd(String rowValue) {
        return this.decodeNull(rowValue, this.nullLocationCd);
    }

    public String encodeOperator(Value value) {
        String op;
        if (value.getOperator() == null) {
            return "E";
        }
        switch (value.getOperator()) {
            case Equal: {
                op = "E";
                break;
            }
            case NotEqual: {
                op = "NE";
                break;
            }
            case LessThan: {
                op = "L";
                break;
            }
            case LessOrEqual: {
                op = "LE";
                break;
            }
            case GreaterThan: {
                op = "G";
                break;
            }
            case GreaterOrEqual: {
                op = "GE";
                break;
            }
            default: {
                op = "E";
            }
        }
        return op;
    }

    public String encodeValueFlagCd(Value value) {
        String flag;
        if (value.getAbnormalFlag() == null) {
            flag = null;
        } else {
            switch (value.getAbnormalFlag()) {
                case Abnormal: {
                    flag = "A";
                }
            }
            flag = null;
        }
        return flag;
    }

    public AbnormalFlag decodeValueFlagCd(String value_flag_cd) {
        if (value_flag_cd == null) {
            return null;
        }
        switch (value_flag_cd) {
            case "A": {
                return AbnormalFlag.Abnormal;
            }
        }
        return null;
    }
}

