/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2.ont;

import de.sekmi.histream.i2b2.ont.Import;
import de.sekmi.histream.i2b2.sql.VirtualConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOntologyImport {
    VirtualConnection dbcData;
    VirtualConnection dbcMeta;
    Import imp;

    @Before
    public void prepareVirtualConnections() throws SQLException {
        this.dbcData = new VirtualConnection(a -> {});
        this.dbcMeta = new VirtualConnection(a -> {});
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("meta.basepath", "\\i2b2\\");
        props.put("meta.sourcesystem_cd", "test");
        props.put("meta.table", "i2b2metadata.i2b2");
        props.put("meta.access", "i2b2metadata.table_access");
        props.put("data.concept.table", "i2b2crcdata.concept_dimension");
        props.put("data.modifier.table", "i2b2crcdata.modifier_dimension");
        props.put("ont.language", "en");
        this.imp = new Import((Connection)this.dbcMeta, (Connection)this.dbcData, props);
    }

    @After
    public void closeVirtualConnections() throws SQLException {
        this.imp.close();
    }

    @Test
    public void verifyReadablePath() {
        String path = "\\i2b2\\asdf:First\\k23kskd:Second\\";
        String readable = this.imp.readableConceptPath(path);
        Assert.assertEquals((long)-1L, (long)readable.indexOf(58));
        System.out.println(readable);
        path = "\\i2b2\\http://lala/xyz#First\\asdf:Second";
        String readable2 = this.imp.readableConceptPath(path);
        System.out.println(readable);
        Assert.assertEquals((Object)readable, (Object)readable2);
    }
}

