/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.DateTimeAccuracy;
import de.sekmi.histream.ext.Patient;
import de.sekmi.histream.i2b2.I2b2Patient;
import java.text.ParseException;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.junit.Assert;
import org.junit.Test;

public class TestI2b2Patient {
    private DateTimeAccuracy createAccurateTimestamp() {
        try {
            return DateTimeAccuracy.parsePartialIso8601((String)"2001-02-03T04:05:06");
        }
        catch (ParseException e) {
            throw new AssertionError();
        }
    }

    @Test
    public void verifyAccurateTimestampParsing() {
        Assert.assertEquals((Object)ChronoUnit.SECONDS, (Object)this.createAccurateTimestamp().getAccuracy());
        I2b2Patient v = this.createPatientWithTimestamps();
        Assert.assertEquals((Object)ChronoUnit.SECONDS, (Object)v.getBirthDate().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.SECONDS, (Object)v.getDeathDate().getAccuracy());
    }

    private I2b2Patient createPatientWithTimestamps() {
        I2b2Patient v = new I2b2Patient(0, Patient.Sex.male, this.createAccurateTimestamp(), this.createAccurateTimestamp());
        return v;
    }

    @Test
    public void applyNullVitalStatus() {
        I2b2Patient v = this.createPatientWithTimestamps();
        v.setVitalStatusCd(null);
        Assert.assertEquals((Object)ChronoUnit.DAYS, (Object)v.getBirthDate().getAccuracy());
        Assert.assertNull((Object)v.getDeathDate());
        Assert.assertFalse((boolean)v.getDeceased());
        v = this.createPatientWithTimestamps();
        v.setVitalStatusCd("");
        Assert.assertEquals((Object)ChronoUnit.DAYS, (Object)v.getBirthDate().getAccuracy());
        Assert.assertNull((Object)v.getDeathDate());
        Assert.assertFalse((boolean)v.getDeceased());
    }

    @Test
    public void verifyMinuteAccuracy() {
        I2b2Patient v = this.createPatientWithTimestamps();
        v.setVitalStatusCd("I");
        Assert.assertEquals((Object)ChronoUnit.MINUTES, (Object)v.getBirthDate().getAccuracy());
        Assert.assertNull((Object)v.getDeathDate());
        Assert.assertFalse((boolean)v.getDeceased());
        v = this.createPatientWithTimestamps();
        v.setVitalStatusCd("T");
        Assert.assertEquals((Object)ChronoUnit.DAYS, (Object)v.getBirthDate().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.MINUTES, (Object)v.getDeathDate().getAccuracy());
    }

    @Test
    public void verifyHourAndNullAccuracy() {
        I2b2Patient v = this.createPatientWithTimestamps();
        v.setVitalStatusCd("UH");
        Assert.assertEquals((Object)ChronoUnit.HOURS, (Object)v.getBirthDate().getAccuracy());
        Assert.assertEquals((long)4L, (long)v.getBirthDate().toInstantMin().atOffset(ZoneOffset.UTC).toLocalDateTime().get(ChronoField.HOUR_OF_DAY));
        Assert.assertNull((Object)v.getDeathDate());
        v = this.createPatientWithTimestamps();
        v.setVitalStatusCd("RL");
        Assert.assertNull((Object)v.getBirthDate());
        Assert.assertEquals((Object)ChronoUnit.HOURS, (Object)v.getDeathDate().getAccuracy());
        Assert.assertEquals((long)4L, (long)v.getDeathDate().toInstantMin().atOffset(ZoneOffset.UTC).toLocalDateTime().get(ChronoField.HOUR_OF_DAY));
    }

    @Test
    public void verifyMonthAndYearAccuracy() {
        I2b2Patient v = this.createPatientWithTimestamps();
        v.setVitalStatusCd("XB");
        Assert.assertEquals((Object)ChronoUnit.MONTHS, (Object)v.getBirthDate().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.YEARS, (Object)v.getDeathDate().getAccuracy());
        v = this.createPatientWithTimestamps();
        v.setVitalStatusCd("MF");
        Assert.assertEquals((Object)ChronoUnit.YEARS, (Object)v.getBirthDate().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.MONTHS, (Object)v.getDeathDate().getAccuracy());
    }
}

