/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.DateTimeAccuracy;
import de.sekmi.histream.i2b2.DataDialect;
import de.sekmi.histream.i2b2.TestExtractor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.junit.Assert;
import org.junit.Test;

public class TestDataDialect {
    @Test
    public void localDateTimeVerbatimOutput() {
        LocalDateTime local = LocalDateTime.of(2001, 2, 3, 4, 5);
        Assert.assertEquals((Object)"2001-02-03T04:05", (Object)local.toString());
        Timestamp ts = Timestamp.valueOf(local);
        System.out.println("Local time " + local + " to SQL Timestamp: " + ts.toInstant());
    }

    @Test
    public void verifySqlTimestampConversions() {
        DataDialect dialect = new DataDialect();
        dialect.setTimeZone(ZoneId.of("Asia/Shanghai"));
        Instant inst = Instant.parse("2001-02-03T04:05:06Z");
        DateTimeAccuracy da = new DateTimeAccuracy(inst);
        System.out.println(inst);
        Timestamp ts = dialect.encodeInstant(inst);
        Assert.assertEquals((Object)ts, (Object)dialect.encodeInstantPartial(da));
        System.out.println(ts.toInstant());
        Instant b = dialect.decodeInstant(ts);
        System.out.println(b);
        Assert.assertEquals((Object)inst, (Object)b);
    }

    public static void main(String[] args) throws SQLException {
        Connection c = new TestExtractor().getConnection();
        Statement s = c.createStatement();
        s.executeUpdate("DELETE FROM source_master WHERE source_cd='db_test'");
        s.close();
        PreparedStatement ps = c.prepareStatement("INSERT INTO source_master(source_cd, create_date) VALUES(?,?)");
        ps.setString(1, "db_test");
        Instant inst = Instant.parse("2001-08-03T04:05:06Z");
        ps.setTimestamp(2, Timestamp.from(inst));
        ps.executeUpdate();
        ps.close();
        c.close();
    }
}

