/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2.ont;

import de.sekmi.histream.i2b2.ont.Import;
import de.sekmi.histream.i2b2.sql.VirtualConnection;
import de.sekmi.histream.ontology.Ontology;
import de.sekmi.histream.ontology.OntologyException;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Consumer;

public class SQLGenerator
implements Closeable {
    private Import imp;
    private BufferedWriter metaWriter;
    private BufferedWriter dataWriter;
    VirtualConnection metaCon;
    VirtualConnection dataCon;

    public SQLGenerator(BufferedWriter metaWriter, BufferedWriter dataWriter, Map<String, String> config) throws IOException, SQLException {
        this.metaWriter = metaWriter;
        this.dataWriter = dataWriter;
        this.metaCon = new VirtualConnection(this::writeMetaSQL);
        this.dataCon = new VirtualConnection(this::writeDataSQL);
        this.imp = new Import(this.metaCon, this.dataCon, config);
    }

    public SQLGenerator(Path metaSQL, Path dataSQL, Map<String, String> config, boolean overwrite) throws IOException, SQLException {
        this(Files.newBufferedWriter(metaSQL, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE), Files.newBufferedWriter(dataSQL, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE), config);
    }

    private void writeMetaSQL(String sql) {
        try {
            this.metaWriter.write(sql);
            this.metaWriter.write(59);
            this.metaWriter.newLine();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeDataSQL(String sql) {
        try {
            this.dataWriter.write(sql);
            this.dataWriter.write(59);
            this.dataWriter.newLine();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void setWarningHandler(Consumer<String> handler) {
        this.imp.setWarningHandler(handler);
    }

    public void writeOntologySQL(Ontology ontology) throws SQLException, OntologyException {
        this.imp.setOntology(ontology);
        this.imp.processOntology();
    }

    @Override
    public void close() throws IOException {
        this.metaWriter.close();
        this.dataWriter.close();
    }
}

