/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2.ont;

import de.sekmi.histream.i2b2.ont.MetaEntry;
import de.sekmi.histream.i2b2.ont.PostgresUtil;
import de.sekmi.histream.ontology.Concept;
import de.sekmi.histream.ontology.Ontology;
import de.sekmi.histream.ontology.OntologyException;
import de.sekmi.histream.ontology.ValueRestriction;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Import
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(Import.class.getName());
    private Ontology ontology;
    private Connection dbMeta;
    private Connection dbData;
    private Locale locale;
    private PreparedStatement insertMeta;
    private PreparedStatement insertMetaModifier;
    private PreparedStatement insertAccess;
    private PreparedStatement insertConcept;
    private PreparedStatement insertModifier;
    private int insertMetaCount;
    private int insertAccessCount;
    private int insertConceptCount;
    private int insertModifierCount;
    private int deleteMetaCount;
    private int deleteAccessCount;
    private int deleteConceptCount;
    private int deleteModifierCount;
    private String sourceId;
    private String sourceIdDelete;
    private String ontScheme;
    private Timestamp sourceTimestamp;
    private String metaBase;
    private String metaTable;
    private String metaAccess;
    private String dataConceptTable;
    private String dataModifierTable;
    private Consumer<String> warningHandler;

    public Import(Map<String, String> props) throws ClassNotFoundException, SQLException {
        this.openDatabase(props);
        this.readConfiguration(props);
        this.prepareStatements();
        this.warningHandler = log::warning;
    }

    public Import(Connection dbMeta, Connection dbData, Map<String, String> props) throws SQLException {
        this.dbMeta = dbMeta;
        this.dbData = dbData;
        this.readConfiguration(props);
        this.prepareStatements();
        this.warningHandler = log::warning;
    }

    private String getMetaTable() {
        return this.metaTable;
    }

    private String getAccessTable() {
        return this.metaAccess;
    }

    private String getConceptTable() {
        return this.dataConceptTable;
    }

    private String getModifierTable() {
        return this.dataModifierTable;
    }

    public int getInsertMetaCount() {
        return this.insertMetaCount;
    }

    public int getDeleteMetaCount() {
        return this.deleteMetaCount;
    }

    public int getInsertConceptCount() {
        return this.insertConceptCount;
    }

    public int getDeleteConceptCount() {
        return this.deleteConceptCount;
    }

    public int getInsertAccessCount() {
        return this.insertAccessCount;
    }

    public int getDeleteAccessCount() {
        return this.deleteAccessCount;
    }

    private void showWarning(String warning) {
        this.warningHandler.accept(warning);
    }

    private void prepareStatements() throws SQLException {
        this.insertMeta = this.dbMeta.prepareStatement("INSERT INTO " + this.getMetaTable() + "(c_hlevel,c_fullname,c_name,c_synonym_cd,c_visualattributes,c_basecode,c_metadataxml,c_facttablecolumn,c_tablename,c_columnname,c_columndatatype,c_operator,c_dimcode,c_tooltip,m_applied_path,update_date,download_date,import_date,sourcesystem_cd)VALUES(?,?,?,?,?,?,?,'concept_cd','concept_dimension','concept_path','T','LIKE',?,?,?,current_timestamp,?,current_timestamp,?)");
        this.insertMetaModifier = this.dbMeta.prepareStatement("INSERT INTO " + this.getMetaTable() + "(c_hlevel,c_fullname,c_name,c_synonym_cd,c_visualattributes,c_basecode,c_metadataxml,c_facttablecolumn,c_tablename,c_columnname,c_columndatatype,c_operator,c_dimcode,c_tooltip,m_applied_path,update_date,download_date,import_date,sourcesystem_cd)VALUES(?,?,?,?,?,?,?,'modifier_cd','modifier_dimension','modifier_path','T','LIKE',?,?,?,current_timestamp,?,current_timestamp,?)");
        String access_table_name = this.getMetaTable();
        if (access_table_name.indexOf(46) >= 0) {
            access_table_name = access_table_name.substring(access_table_name.indexOf(46) + 1);
        }
        this.insertAccess = this.dbMeta.prepareStatement("INSERT INTO " + this.getAccessTable() + "(c_table_cd,c_table_name,c_protected_access,c_hlevel,c_fullname,c_name,c_synonym_cd,c_visualattributes,c_facttablecolumn,c_dimtablename,c_columnname,c_columndatatype,c_operator,c_dimcode,c_tooltip)VALUES(?,'" + access_table_name + "','N',?,?,?,?,?,'concept_cd','concept_dimension','concept_path','T','LIKE',?,?)");
        this.insertConcept = this.dbData.prepareStatement("INSERT INTO " + this.getConceptTable() + "(concept_path,concept_cd,name_char,update_date,download_date,import_date,sourcesystem_cd)VALUES(?,?,?,current_timestamp,?,current_timestamp,?)");
        this.insertModifier = this.dbData.prepareStatement("INSERT INTO " + this.getModifierTable() + "(modifier_path, modifier_cd, name_char, update_date,download_date,import_date,sourcesystem_cd)VALUES(?,?,?,current_timestamp,?,current_timestamp,?)");
    }

    public void setWarningHandler(Consumer<String> warningHandler) {
        this.warningHandler = warningHandler;
    }

    private void readConfiguration(Map<String, String> config) {
        this.metaBase = config.get("meta.basepath");
        this.sourceId = config.get("meta.sourcesystem_cd");
        this.sourceIdDelete = config.getOrDefault("meta.sourcesystem_cd.delete", this.sourceId);
        if (this.sourceIdDelete.trim().length() == 0) {
            this.sourceIdDelete = null;
        }
        this.metaTable = config.get("meta.table");
        this.metaAccess = config.get("meta.access");
        this.dataConceptTable = config.get("data.concept.table");
        this.dataModifierTable = config.get("data.modifier.table");
        Objects.requireNonNull(this.metaTable, "Need configuration: meta.table");
        Objects.requireNonNull(this.metaAccess, "Need configuration: meta.access");
        Objects.requireNonNull(this.dataConceptTable, "Need configuration: data.concept.table");
        Objects.requireNonNull(this.dataModifierTable, "Need configuration: data.modifier.table");
        this.locale = config.get("ont.language") == null ? Locale.getDefault() : Locale.forLanguageTag(config.get("ont.language"));
        if (config.get("ont.scheme") != null) {
            this.ontScheme = config.get("ont.scheme");
        }
    }

    private void deleteFromDatabase() throws SQLException {
        if (this.sourceIdDelete == null) {
            return;
        }
        PreparedStatement deleteOnt = this.dbMeta.prepareStatement("DELETE FROM " + this.getMetaTable() + " WHERE sourcesystem_cd=?");
        PreparedStatement deleteAccess = this.dbMeta.prepareStatement("DELETE FROM " + this.getAccessTable() + " WHERE c_table_cd LIKE ?");
        PreparedStatement deleteModifiers = this.dbData.prepareStatement("DELETE FROM " + this.getModifierTable() + " WHERE sourcesystem_cd=?");
        PreparedStatement deleteConcepts = this.dbData.prepareStatement("DELETE FROM " + this.getConceptTable() + " WHERE sourcesystem_cd=?");
        deleteConcepts.setString(1, this.sourceIdDelete);
        this.deleteConceptCount = deleteConcepts.executeUpdate();
        deleteConcepts.close();
        deleteModifiers.setString(1, this.sourceIdDelete);
        this.deleteModifierCount = deleteModifiers.executeUpdate();
        deleteModifiers.close();
        deleteAccess.setString(1, this.sourceIdDelete + "%");
        this.deleteAccessCount = deleteAccess.executeUpdate();
        deleteAccess.close();
        deleteOnt.setString(1, this.sourceIdDelete);
        this.deleteMetaCount = deleteOnt.executeUpdate();
        deleteOnt.close();
    }

    public void processOntology() throws SQLException, OntologyException {
        Concept[] concepts;
        int base_level;
        this.deleteFromDatabase();
        String base = this.metaBase;
        if (base != null && !base.equals("\\")) {
            String[] baseParts = base.split("\\\\");
            if (baseParts.length < 2 || baseParts[0].length() != 0 || !base.endsWith("\\")) {
                throw new IllegalArgumentException("meta.basepath must start and end with a backslash (\\)");
            }
            base_level = baseParts.length - 1;
        } else {
            base = "\\";
            base_level = 0;
        }
        for (Concept c : concepts = this.ontology.getTopConcepts(this.ontScheme)) {
            this.insertMeta(base_level, base, c, true);
        }
    }

    private void insertConceptDimension(String path, String name, String concept_cd) throws SQLException {
        this.insertConcept.setString(1, path);
        this.insertConcept.setString(2, concept_cd);
        this.insertConcept.setString(3, name);
        this.insertConcept.setTimestamp(4, this.sourceTimestamp);
        this.insertConcept.setString(5, this.sourceId);
        this.insertConcept.executeUpdate();
        ++this.insertConceptCount;
    }

    private void insertModifierDimension(String path, String name, String concept_cd) throws SQLException {
        this.insertModifier.setString(1, path);
        this.insertModifier.setString(2, concept_cd);
        this.insertModifier.setString(3, name);
        this.insertModifier.setTimestamp(4, this.sourceTimestamp);
        this.insertModifier.setString(5, this.sourceId);
        this.insertModifier.executeUpdate();
        ++this.insertModifierCount;
    }

    private String generateMetadataXML(ValueRestriction vr) throws XMLStreamException, OntologyException {
        if (vr == null) {
            return null;
        }
        StringWriter xmlbuf = new StringWriter();
        XMLOutputFactory xmlout = XMLOutputFactory.newInstance();
        XMLStreamWriter xml = xmlout.createXMLStreamWriter(xmlbuf);
        xml.writeStartElement("ValueMetadata");
        xml.writeStartElement("Version");
        xml.writeCharacters("3.02");
        xml.writeEndElement();
        xml.writeStartElement("CreationDateTime");
        xml.writeCharacters("10/07/2002 15:08:07");
        xml.writeEndElement();
        Object[] ev = vr.getEnumerationValues();
        if (ev != null) {
            int i;
            xml.writeStartElement("DataType");
            xml.writeCharacters("Enum");
            xml.writeEndElement();
            xml.writeStartElement("Oktousevalues");
            xml.writeCharacters("Y");
            xml.writeEndElement();
            xml.writeStartElement("EnumValues");
            String[] labels = vr.getEnumerationLabels(this.locale);
            if (labels == null) {
                labels = new String[ev.length];
                for (i = 0; i < labels.length; ++i) {
                    labels[i] = ev[i].toString();
                }
            }
            for (i = 0; i < ev.length; ++i) {
                xml.writeStartElement("Val");
                xml.writeAttribute("description", labels[i]);
                xml.writeCharacters(ev[i].toString());
                xml.writeEndElement();
            }
            xml.writeEndElement();
        } else {
            String i2b2type;
            QName type = vr.getType();
            if (type != null) {
                switch (type.getLocalPart()) {
                    case "integer": 
                    case "int": {
                        i2b2type = "Integer";
                        break;
                    }
                    case "float": 
                    case "decimal": {
                        i2b2type = "Float";
                        break;
                    }
                    default: {
                        i2b2type = "String";
                        break;
                    }
                }
            } else {
                i2b2type = "String";
            }
            xml.writeStartElement("DataType");
            xml.writeCharacters(i2b2type);
            xml.writeEndElement();
            xml.writeStartElement("Oktousevalues");
            xml.writeCharacters("Y");
            xml.writeEndElement();
        }
        xml.writeEndDocument();
        xml.close();
        try {
            xmlbuf.close();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        return xmlbuf.toString();
    }

    public String readableConceptPath(String path) {
        if (path.startsWith(this.metaBase)) {
            path = path.substring(this.metaBase.length());
        }
        StringBuilder b = new StringBuilder();
        int pos = 0;
        boolean done = false;
        do {
            int prefix_char;
            int sep;
            if ((sep = path.indexOf(92, pos)) == -1) {
                done = true;
                sep = path.length();
            } else if (sep == path.length() - 1) {
                done = true;
            }
            if (path.length() - pos > 7 && path.substring(pos, pos + 7).equals("http://")) {
                prefix_char = 35;
                pos += 7;
            } else {
                prefix_char = 58;
            }
            int pfx = path.indexOf(prefix_char, pos);
            if (pfx != -1 && pfx < sep) {
                pos = pfx + 1;
            }
            b.append('\\').append(path.substring(pos, sep));
            pos = sep + 1;
        } while (!done);
        return b.toString();
    }

    private String buildConceptPath(String parentPath, Concept concept) {
        String path_part = concept.getID();
        return parentPath + path_part + "\\";
    }

    private String buildModifierPath(String parentPath, Concept modifier) {
        return this.buildConceptPath(parentPath, modifier);
    }

    private void insertConceptMetaEntry(MetaEntry m) throws SQLException {
        this.insertMeta.setInt(1, m.level);
        this.insertMeta.setString(2, m.path);
        this.insertMeta.setString(3, m.label);
        this.insertMeta.setString(4, m.synonym ? "Y" : "N");
        StringBuilder b = new StringBuilder(3);
        switch (m.type) {
            case Container: {
                b.append('C');
                break;
            }
            case Folder: {
                b.append('F');
                break;
            }
            case Leaf: {
                b.append('L');
                break;
            }
            case Multiple: {
                b.append('M');
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (m.visibility) {
            case Disabled: {
                b.append('I');
                break;
            }
            case ACTIVE: {
                b.append('A');
                break;
            }
            case Hidden: {
                b.append('H');
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.insertMeta.setString(5, b.toString());
        this.insertMeta.setString(6, m.basecode);
        this.insertMeta.setString(7, m.xml);
        this.insertMeta.setString(8, m.dimcode);
        this.insertMeta.setString(9, m.tooltip);
        this.insertMeta.setString(10, "@");
        this.insertMeta.setTimestamp(11, this.sourceTimestamp);
        this.insertMeta.setString(12, this.sourceId);
        this.insertMeta.executeUpdate();
        ++this.insertMetaCount;
    }

    private void insertMeta(int level, String path_prefix, Concept concept, boolean accessRoot) throws SQLException, OntologyException {
        MetaEntry m = new MetaEntry();
        m.level = level;
        m.label = concept.getPrefLabel(this.locale);
        if (m.label == null) {
            m.label = concept.getPrefLabel(null);
            if (m.label == null) {
                m.label = concept.getID();
                this.showWarning("Missing prefLabel for concept " + concept + " substituted with ID");
            }
        }
        m.path = this.buildConceptPath(path_prefix, concept);
        m.synonym = false;
        Concept[] subConcepts = concept.getNarrower();
        String[] conceptIds = concept.getNotations();
        m.visibility = MetaEntry.Visibility.ACTIVE;
        try {
            m.xml = this.generateMetadataXML(concept.getValueRestriction());
        }
        catch (XMLStreamException e) {
            throw new OntologyException("Failed to generate metadata XML for concept " + concept.getID(), (Throwable)e);
        }
        m.dimcode = m.path;
        String descr = concept.getDescription(this.locale);
        if (descr == null) {
            descr = this.readableConceptPath(m.path);
        }
        m.tooltip = descr;
        if (conceptIds.length == 0) {
            if (subConcepts.length == 0) {
                m.visibility = MetaEntry.Visibility.Disabled;
                m.type = MetaEntry.Type.Leaf;
            } else {
                m.type = MetaEntry.Type.Folder;
            }
            m.basecode = null;
        } else if (conceptIds.length == 1) {
            m.type = subConcepts.length == 0 ? MetaEntry.Type.Leaf : MetaEntry.Type.Folder;
            m.basecode = conceptIds[0];
            this.insertConceptDimension(m.path, m.label, conceptIds[0]);
        } else if (subConcepts.length == 0) {
            m.type = MetaEntry.Type.Multiple;
            MetaEntry sub = m.clone();
            sub.level = m.level + 1;
            sub.type = MetaEntry.Type.Leaf;
            for (int i = 0; i < conceptIds.length; ++i) {
                sub.basecode = conceptIds[i];
                sub.label = m.label + "-" + conceptIds[i].hashCode();
                sub.dimcode = sub.path = m.path + sub.label;
                this.insertConceptDimension(sub.path, sub.label, conceptIds[i]);
                this.insertConceptMetaEntry(sub);
            }
        } else {
            m.type = MetaEntry.Type.Folder;
            m.basecode = conceptIds[0];
            this.insertConceptDimension(m.path, m.label, conceptIds[0]);
            this.showWarning("Ignoring ids other than '" + conceptIds[0] + "' of parent concept " + concept);
        }
        this.insertConceptMetaEntry(m);
        this.insertModifiers(concept, m.path);
        if (accessRoot) {
            this.insertAccess.setString(1, this.sourceId + "_" + Integer.toHexString(concept.hashCode()));
            this.insertAccess.setInt(2, level);
            this.insertAccess.setString(3, m.path);
            this.insertAccess.setString(4, m.label);
            this.insertAccess.setString(5, "N");
            this.insertAccess.setString(6, "FA");
            this.insertAccess.setString(7, m.path);
            this.insertAccess.setString(8, m.tooltip);
            this.insertAccess.executeUpdate();
            ++this.insertAccessCount;
        }
        for (Concept sub : subConcepts) {
            this.insertMeta(level + 1, m.path, sub, false);
        }
    }

    private void insertModifiers(Concept concept, String concept_path) throws OntologyException, SQLException {
        Concept[] parts = concept.getParts(false);
        if (parts == null) {
            return;
        }
        for (Concept part : parts) {
            this.insertModifierMetaTree(concept_path, 1, part, "\\");
        }
    }

    private void insertModifierMetaEntry(MetaEntry entry) throws SQLException {
        this.insertMetaModifier.setInt(1, entry.level);
        this.insertMetaModifier.setString(2, entry.path);
        this.insertMetaModifier.setString(3, entry.label);
        this.insertMetaModifier.setString(4, entry.synonym ? "Y" : "N");
        StringBuilder b = new StringBuilder(3);
        switch (entry.type) {
            case Container: {
                b.append('O');
                break;
            }
            case Folder: {
                b.append('D');
                break;
            }
            case Leaf: {
                b.append('R');
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (entry.visibility) {
            case Disabled: {
                b.append('I');
                break;
            }
            case ACTIVE: {
                b.append('A');
                break;
            }
            case Hidden: {
                b.append('H');
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.insertMetaModifier.setString(5, b.toString());
        this.insertMetaModifier.setString(6, entry.basecode);
        this.insertMetaModifier.setString(7, entry.xml);
        this.insertMetaModifier.setString(8, entry.dimcode);
        this.insertMetaModifier.setString(9, entry.tooltip);
        this.insertMetaModifier.setString(10, entry.modpath);
        this.insertMetaModifier.setTimestamp(11, this.sourceTimestamp);
        this.insertMetaModifier.setString(12, this.sourceId);
        this.insertMetaModifier.executeUpdate();
        ++this.insertMetaCount;
    }

    private void insertModifierMetaTree(String concept_path, int level, Concept modifier, String path_prefix) throws OntologyException, SQLException {
        String[] ids = modifier.getNotations();
        String path = this.buildModifierPath(path_prefix, modifier);
        String label = modifier.getPrefLabel(this.locale);
        MetaEntry e = new MetaEntry();
        if (ids.length == 0) {
            e.basecode = null;
        } else if (ids.length == 1) {
            e.basecode = ids[0];
            this.insertModifierDimension(path, label, ids[0]);
        } else {
            this.showWarning("Using first notation - multiple notations not allowed for i2b2 modifiers: " + modifier.getID());
            e.basecode = ids[0];
            this.insertModifierDimension(path, label, ids[0]);
        }
        e.level = level;
        e.path = path;
        e.label = label;
        e.synonym = false;
        Concept[] narrower = modifier.getNarrower();
        e.type = narrower.length == 0 ? MetaEntry.Type.Leaf : MetaEntry.Type.Folder;
        e.visibility = MetaEntry.Visibility.ACTIVE;
        try {
            e.xml = this.generateMetadataXML(modifier.getValueRestriction());
        }
        catch (XMLStreamException ex) {
            throw new OntologyException("Failed to generate metadata XML for modifier " + modifier.getID(), (Throwable)ex);
        }
        e.dimcode = e.path;
        e.modpath = concept_path + "%";
        e.tooltip = modifier.getDescription(this.locale);
        this.insertModifierMetaEntry(e);
        for (Concept nested : narrower) {
            this.insertModifierMetaTree(concept_path, level + 1, nested, path);
        }
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
        this.sourceTimestamp = new Timestamp(ontology.lastModified());
    }

    private void openDatabase(Map<String, String> props) throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        this.dbMeta = PostgresUtil.getConnection(props, new String[]{"jdbc.", "meta.jdbc."});
        this.dbMeta.setAutoCommit(true);
        this.dbData = PostgresUtil.getConnection(props, new String[]{"jdbc.", "data.jdbc."});
        this.dbData.setAutoCommit(true);
    }

    @Override
    public void close() {
        try {
            this.dbMeta.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Error closing database connection", e);
        }
        try {
            this.dbData.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Error closing database connection", e);
        }
    }
}

