/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.DateTimeAccuracy;
import de.sekmi.histream.Observation;
import de.sekmi.histream.ext.ExternalSourceType;
import de.sekmi.histream.ext.Patient;
import de.sekmi.histream.ext.PatientStore;
import de.sekmi.histream.ext.StoredExtensionType;
import de.sekmi.histream.i2b2.I2b2Patient;
import de.sekmi.histream.i2b2.PostgresExtension;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PostgresPatientStore
extends PostgresExtension<I2b2Patient>
implements PatientStore,
Closeable {
    private static final Logger log = Logger.getLogger(PostgresPatientStore.class.getName());
    private static final Iterable<Class<? super I2b2Patient>> INSTANCE_TYPES = Arrays.asList(Patient.class, I2b2Patient.class);
    private String projectId;
    private String idSourceDefault = "HIVE";
    private char idSourceSeparator = (char)58;
    private Connection db;
    private int fetchSize = 1000;
    private int maxPatientNum;
    private Hashtable<Integer, I2b2Patient> patientCache;
    private Hashtable<String, I2b2Patient> idCache;
    private PreparedStatement insert;
    private PreparedStatement insertIde;
    private PreparedStatement update;
    private PreparedStatement selectAll;
    private PreparedStatement selectAllIde;
    private PreparedStatement deletePatientSource;
    private PreparedStatement deleteMapSource;

    public void open(Connection connection, String projectId) throws SQLException {
        this.db = connection;
        this.projectId = projectId;
        Objects.requireNonNull(this.projectId, "non-null projectId required");
        this.patientCache = new Hashtable(1000);
        this.idCache = new Hashtable(1000);
        this.prepareStatements();
        this.loadMaxPatientNum();
        this.batchLoad();
    }

    private I2b2Patient getCached(int patient_num) {
        return this.patientCache.get(patient_num);
    }

    public I2b2Patient lookupPatientNum(Integer patient_num) {
        return this.patientCache.get(patient_num);
    }

    private I2b2Patient getCached(String patient_id) {
        return this.idCache.get(patient_id);
    }

    private void loadMaxPatientNum() throws SQLException {
        try (Statement s = this.db.createStatement();){
            String sql = "SELECT MAX(patient_num) FROM patient_dimension";
            ResultSet rs = s.executeQuery(sql);
            rs.next();
            this.maxPatientNum = rs.getInt(1);
            if (rs.wasNull()) {
                this.maxPatientNum = 0;
            }
            rs.close();
        }
        log.info("MAX(patient_num) = " + this.maxPatientNum);
    }

    @Override
    protected void prepareStatements() throws SQLException {
        this.db.setAutoCommit(true);
        if (this.projectId == null) {
            log.warning("property project is null, some things might fail");
        }
        this.insert = this.db.prepareStatement("INSERT INTO patient_dimension(patient_num, import_date, sourcesystem_cd) VALUES(?,current_timestamp,?)");
        this.insertIde = this.db.prepareStatement("INSERT INTO patient_mapping(patient_ide, patient_ide_source, patient_num, patient_ide_status, project_id, import_date, download_date, sourcesystem_cd) values (?,?,?,?,'" + this.projectId + "',current_timestamp,?,?)");
        this.update = this.db.prepareStatement("UPDATE patient_dimension SET vital_status_cd=?, birth_date=?, death_date=?, sex_cd=?, update_date=current_timestamp, download_date=?, sourcesystem_cd=? WHERE patient_num=?");
        this.selectAll = this.db.prepareStatement("SELECT patient_num, vital_status_cd, birth_date, death_date, sex_cd, download_date, sourcesystem_cd FROM patient_dimension", 1003, 1007);
        this.selectAll.setFetchSize(this.fetchSize);
        this.selectAllIde = this.db.prepareStatement("SELECT patient_num, patient_ide, patient_ide_source, patient_ide_status, project_id FROM patient_mapping WHERE project_id='" + this.projectId + "' ORDER BY patient_num", 1003, 1007);
        this.selectAllIde.setFetchSize(this.fetchSize);
        this.deletePatientSource = this.db.prepareStatement("DELETE FROM patient_dimension WHERE sourcesystem_cd=?");
        this.deleteMapSource = this.db.prepareStatement("DELETE FROM patient_mapping WHERE sourcesystem_cd=?");
    }

    public int size() {
        return this.patientCache.size();
    }

    private void batchLoad() throws SQLException {
        try (ResultSet rs = this.selectAll.executeQuery();){
            while (rs.next()) {
                I2b2Patient patient = this.loadFromResultSet(rs);
                this.patientCache.put(patient.getNum(), patient);
            }
        }
        rs = this.selectAllIde.executeQuery();
        var2_2 = null;
        try {
            I2b2Patient p;
            ArrayList<String> ids = new ArrayList<String>(16);
            int num = -1;
            while (rs.next()) {
                if (num == -1) {
                    num = rs.getInt(1);
                } else if (num != rs.getInt(1)) {
                    p = this.getCached(num);
                    if (p == null) {
                        log.warning("No match for patient_num=" + num + " in patient_dimension (see encounter_mapping.id='" + rs.getString(2) + "'");
                    } else if (ids.size() > 0) {
                        p.mergedIds = new String[ids.size()];
                        p.mergedIds = ids.toArray(p.mergedIds);
                    }
                    num = rs.getInt(1);
                    ids.clear();
                }
                String id = rs.getString(3).equals(this.idSourceDefault) ? rs.getString(2) : rs.getString(3) + this.idSourceSeparator + rs.getString(2);
                if (rs.getString(4).equals("A") && rs.getString(5).equals(this.projectId)) {
                    p = this.getCached(num);
                    if (p == null) continue;
                    p.setId(id);
                    p.markDirty(false);
                    continue;
                }
                ids.add(id);
            }
            if (num != -1) {
                p = this.getCached(num);
                if (p == null) {
                    log.warning("No match for patient_num=" + num + " in patient_dimension from encounter_mapping");
                } else if (ids.size() > 0) {
                    p.mergedIds = new String[ids.size()];
                    p.mergedIds = ids.toArray(p.mergedIds);
                }
            }
        }
        catch (Throwable p) {
            var2_2 = p;
            throw p;
        }
        finally {
            if (rs != null) {
                if (var2_2 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable p) {
                        var2_2.addSuppressed(p);
                    }
                } else {
                    rs.close();
                }
            }
        }
        Enumeration<I2b2Patient> all = this.patientCache.elements();
        while (all.hasMoreElements()) {
            I2b2Patient p = all.nextElement();
            if (p.getId() != null) {
                this.idCache.put(p.getId(), p);
            }
            if (p.mergedIds == null) continue;
            for (int i = 0; i < p.mergedIds.length; ++i) {
                this.idCache.put(p.mergedIds[i], p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStorage(I2b2Patient patient) throws SQLException {
        PreparedStatement preparedStatement = this.update;
        synchronized (preparedStatement) {
            this.update.setString(1, PostgresPatientStore.getVitalStatusCd((Patient)patient));
            this.update.setTimestamp(2, PostgresPatientStore.inaccurateSqlTimestamp(patient.getBirthDate()));
            this.update.setTimestamp(3, PostgresPatientStore.inaccurateSqlTimestamp(patient.getDeathDate()));
            this.update.setString(4, PostgresPatientStore.getSexCd((Patient)patient));
            if (patient.getSourceTimestamp() != null) {
                this.update.setTimestamp(5, Timestamp.from(patient.getSourceTimestamp()));
            } else {
                this.update.setTimestamp(5, null);
            }
            this.update.setString(6, patient.getSourceId());
            this.update.setInt(7, patient.getNum());
            this.update.executeUpdate();
            patient.markDirty(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertPatient(I2b2Patient patient) throws SQLException {
        PreparedStatement preparedStatement = this.insert;
        synchronized (preparedStatement) {
            this.insert.setInt(1, patient.getNum());
            this.insert.setString(2, patient.getSourceId());
            this.insert.executeUpdate();
            patient.markDirty(false);
        }
    }

    private static String getSexCd(Patient patient) {
        if (patient.getSex() == null) {
            return null;
        }
        switch (patient.getSex()) {
            case female: {
                return "F";
            }
            case male: {
                return "M";
            }
            case indeterminate: {
                return "X";
            }
        }
        return null;
    }

    private static String getVitalStatusCd(Patient patient) {
        char death_char = '\u0000';
        char birth_char = '\u0000';
        if (patient.getDeathDate() != null) {
            switch (patient.getDeathDate().getAccuracy()) {
                case DAYS: {
                    death_char = 'Y';
                    break;
                }
                case MONTHS: {
                    death_char = 'M';
                    break;
                }
                case YEARS: {
                    death_char = 'X';
                    break;
                }
                case HOURS: {
                    death_char = 'R';
                    break;
                }
                case MINUTES: {
                    death_char = 'T';
                    break;
                }
                case SECONDS: {
                    death_char = 'S';
                    break;
                }
            }
        }
        if (patient.getBirthDate() != null) {
            switch (patient.getBirthDate().getAccuracy()) {
                case DAYS: {
                    death_char = 'D';
                    break;
                }
                case MONTHS: {
                    death_char = 'B';
                    break;
                }
                case YEARS: {
                    death_char = 'F';
                    break;
                }
                case HOURS: {
                    death_char = 'H';
                    break;
                }
                case MINUTES: {
                    death_char = 'I';
                    break;
                }
                case SECONDS: {
                    death_char = 'C';
                    break;
                }
            }
        }
        if (death_char != '\u0000' && birth_char != '\u0000') {
            return new String(new char[]{death_char, birth_char});
        }
        if (death_char != '\u0000') {
            return new String(new char[]{death_char});
        }
        if (birth_char != '\u0000') {
            return new String(new char[]{birth_char});
        }
        return null;
    }

    private static void setVitalStatusCd(Patient patient, String vital_cd) {
        if (vital_cd == null) {
            return;
        }
        ChronoUnit accuracy = null;
        char birthIndicator = '\u0000';
        switch (vital_cd.charAt(0)) {
            case 'N': 
            case 'U': 
            case 'Z': {
                break;
            }
            case 'Y': {
                accuracy = ChronoUnit.DAYS;
                break;
            }
            case 'M': {
                accuracy = ChronoUnit.MONTHS;
                break;
            }
            case 'X': {
                accuracy = ChronoUnit.YEARS;
                break;
            }
            case 'R': {
                accuracy = ChronoUnit.HOURS;
                break;
            }
            case 'T': {
                accuracy = ChronoUnit.MINUTES;
                break;
            }
            case 'S': {
                accuracy = ChronoUnit.SECONDS;
                break;
            }
            default: {
                birthIndicator = vital_cd.charAt(0);
            }
        }
        if (patient.getBirthDate() != null && accuracy != null) {
            patient.getBirthDate().setAccuracy(accuracy);
        }
        if (birthIndicator == '\u0000' && vital_cd.length() > 1) {
            birthIndicator = vital_cd.charAt(1);
        }
        switch (birthIndicator) {
            case 'L': {
                break;
            }
            case 'D': {
                accuracy = ChronoUnit.DAYS;
                break;
            }
            case 'B': {
                accuracy = ChronoUnit.MONTHS;
                break;
            }
            case 'F': {
                accuracy = ChronoUnit.YEARS;
                break;
            }
            case 'H': {
                accuracy = ChronoUnit.HOURS;
                break;
            }
            case 'I': {
                accuracy = ChronoUnit.MINUTES;
                break;
            }
            case 'C': {
                accuracy = ChronoUnit.SECONDS;
            }
        }
        if (patient.getBirthDate() != null && accuracy != null) {
            patient.getBirthDate().setAccuracy(accuracy);
        }
    }

    private I2b2Patient loadFromResultSet(ResultSet rs) throws SQLException {
        int id = rs.getInt(1);
        String vital_cd = rs.getString(2);
        if (vital_cd == null || vital_cd.length() == 0) {
            vital_cd = null;
        }
        DateTimeAccuracy birthDate = null;
        DateTimeAccuracy deathDate = null;
        Timestamp ts = rs.getTimestamp(3);
        if (ts != null) {
            birthDate = new DateTimeAccuracy(ts.toLocalDateTime());
        }
        if ((ts = rs.getTimestamp(4)) != null) {
            deathDate = new DateTimeAccuracy(ts.toLocalDateTime());
        }
        String sex_cd = rs.getString(5);
        Patient.Sex sex = null;
        if (sex_cd != null) {
            switch (sex_cd.charAt(0)) {
                case 'F': {
                    sex = Patient.Sex.female;
                    break;
                }
                case 'M': {
                    sex = Patient.Sex.male;
                    break;
                }
                case 'X': {
                    sex = Patient.Sex.indeterminate;
                    break;
                }
                default: {
                    sex_cd = null;
                }
            }
        }
        I2b2Patient patient = new I2b2Patient(id, sex, birthDate, deathDate);
        if (rs.getTimestamp(6) != null) {
            patient.setSourceTimestamp(rs.getTimestamp(6).toInstant());
        }
        patient.setSourceId(rs.getString(7));
        PostgresPatientStore.setVitalStatusCd((Patient)patient, vital_cd);
        patient.markDirty(false);
        return patient;
    }

    private void insertionException(I2b2Patient patient, SQLException e) {
        log.log(Level.SEVERE, "Unable to insert patient " + patient.getId(), e);
    }

    private void updateException(I2b2Patient patient, SQLException e) {
        log.log(Level.SEVERE, "Unable to update patient " + patient.getId(), e);
    }

    private String[] splitId(String id) {
        String ide;
        String ids;
        int p = id.indexOf(this.idSourceSeparator);
        if (p == -1) {
            ids = this.idSourceDefault;
            ide = id;
        } else {
            ids = id.substring(0, p);
            ide = id.substring(p + 1);
        }
        return new String[]{ids, ide};
    }

    private void insertIde(int patient_num, String id, String status, ExternalSourceType source) throws SQLException {
        String[] ids = this.splitId(id);
        this.insertIde.setString(1, ids[1]);
        this.insertIde.setString(2, ids[0]);
        this.insertIde.setInt(3, patient_num);
        this.insertIde.setString(4, status);
        this.insertIde.setTimestamp(5, Timestamp.from(source.getSourceTimestamp()));
        this.insertIde.setString(6, source.getSourceId());
        this.insertIde.executeUpdate();
    }

    private I2b2Patient getOrCreateInstance(String patientId, ExternalSourceType source) {
        I2b2Patient pat = this.getCached(patientId);
        if (pat == null) {
            ++this.maxPatientNum;
            int num = this.maxPatientNum;
            pat = new I2b2Patient(num);
            pat.setId(patientId);
            pat.setSourceId(source.getSourceId());
            pat.setSourceTimestamp(source.getSourceTimestamp());
            this.patientCache.put(num, pat);
            this.idCache.put(pat.getId(), pat);
            try {
                this.insertPatient(pat);
                this.insertIde(num, pat.getId(), "A", source);
            }
            catch (SQLException e) {
                this.insertionException(pat, e);
            }
        }
        return pat;
    }

    public I2b2Patient createInstance(Observation fact) {
        return this.getOrCreateInstance(fact.getPatientId(), fact.getSource());
    }

    public Iterable<Class<? super I2b2Patient>> getInstanceTypes() {
        return INSTANCE_TYPES;
    }

    public I2b2Patient createInstance(Object ... args) throws IllegalArgumentException {
        if (args.length != 2 || !(args[0] instanceof String) || !(args[1] instanceof ExternalSourceType)) {
            throw new IllegalArgumentException("Expected arguments: String patientId, ExternalSourceType source");
        }
        return this.getOrCreateInstance((String)args[0], (ExternalSourceType)args[1]);
    }

    public I2b2Patient retrieve(String id) {
        return this.idCache.get(id);
    }

    public void merge(Patient patient, String additionalId, ExternalSourceType source) {
        I2b2Patient p = (I2b2Patient)patient;
        throw new UnsupportedOperationException();
    }

    public String[] getAliasIds(Patient patient) {
        I2b2Patient p = (I2b2Patient)patient;
        return p.mergedIds;
    }

    @Override
    public void deleteWhereSourceId(String sourceId) throws SQLException {
        this.deletePatientSource.setString(1, sourceId);
        int numRows = this.deletePatientSource.executeUpdate();
        log.info("Deleted " + numRows + " rows with sourcesystem_cd = " + sourceId);
        this.deleteMapSource.setString(1, sourceId);
        this.deleteMapSource.executeUpdate();
        Enumeration<I2b2Patient> all = this.patientCache.elements();
        LinkedList<I2b2Patient> remove = new LinkedList<I2b2Patient>();
        while (all.hasMoreElements()) {
            I2b2Patient p = all.nextElement();
            if (p.getSourceId() == null || !p.getSourceId().equals(sourceId)) continue;
            remove.add(p);
        }
        for (I2b2Patient p : remove) {
            this.patientCache.remove(p.getNum());
            if (p.getId() != null) {
                this.idCache.remove(p.getId());
            }
            if (p.mergedIds == null) continue;
            for (String id : p.mergedIds) {
                this.idCache.remove(id);
            }
        }
        this.loadMaxPatientNum();
    }

    @Override
    public void flush() {
        int count = 0;
        Iterator dirty = StoredExtensionType.dirtyIterator(this.patientCache.elements());
        while (dirty.hasNext()) {
            I2b2Patient patient = (I2b2Patient)((Object)dirty.next());
            try {
                this.updateStorage(patient);
                ++count;
            }
            catch (SQLException e) {
                this.updateException(patient, e);
            }
        }
        log.info("Updated " + count + " patients in database");
    }

    public void purge(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.db != null) {
            this.flush();
            try {
                this.db.close();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            this.db = null;
        }
    }
}

