/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.ObservationException;
import de.sekmi.histream.ObservationExtractor;
import de.sekmi.histream.ObservationFactory;
import de.sekmi.histream.ObservationSupplier;
import de.sekmi.histream.ext.Patient;
import de.sekmi.histream.ext.Visit;
import de.sekmi.histream.i2b2.DataDialect;
import de.sekmi.histream.i2b2.I2b2Extractor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class I2b2ExtractorFactory
implements AutoCloseable,
ObservationExtractor {
    private static final Logger log = Logger.getLogger(I2b2ExtractorFactory.class.getName());
    private DataSource ds;
    private Integer fetchSize;
    DataDialect dialect;
    private ObservationFactory observationFactory;
    private boolean allowWildcardConceptCodes;
    Function<Integer, ? extends Patient> lookupPatientNum;
    Function<Integer, ? extends Visit> lookupVisitNum;
    public static String ALLOW_WILDCARD_CONCEPT_CODES = "de.sekmi.histream.i2b2.wildcard_concepts";
    private static String SELECT_PARAMETERS = "f.patient_num, f.encounter_num, f.instance_num, f.concept_cd, f.modifier_cd, f.provider_id, f.location_cd, f.start_date, f.end_date, RTRIM(f.valtype_cd) valtype_cd, f.tval_char, f.nval_num, RTRIM(f.valueflag_cd) valueflag_cd, f.units_cd, f.download_date, f.sourcesystem_cd";
    private static String SELECT_TABLE = "observation_fact f";
    private static String SELECT_ORDER_GROUP = "ORDER BY f.patient_num, f.encounter_num, f.start_date, f.instance_num, f.concept_cd, f.modifier_cd NULLS FIRST";

    public I2b2ExtractorFactory(DataSource crc_ds, ObservationFactory factory) throws SQLException {
        this.observationFactory = factory;
        this.ds = crc_ds;
        this.dialect = new DataDialect();
    }

    public ObservationFactory getObservationFactory() {
        return this.observationFactory;
    }

    public void setPatientLookup(Function<Integer, ? extends Patient> lookup) {
        this.lookupPatientNum = lookup;
    }

    public void setVisitLookup(Function<Integer, ? extends Visit> lookup) {
        this.lookupVisitNum = lookup;
    }

    public void setFeature(String feature, Object value) {
        if (feature.equals(ALLOW_WILDCARD_CONCEPT_CODES)) {
            if (value instanceof Boolean) {
                this.allowWildcardConceptCodes = (Boolean)value;
            } else {
                throw new IllegalArgumentException("Boolean value expected for feature " + feature);
            }
        }
    }

    private PreparedStatement prepareStatement(Connection dbc, String sql) throws SQLException {
        PreparedStatement s = dbc.prepareStatement(sql, 1003, 1007);
        if (this.fetchSize != null) {
            s.setFetchSize(this.fetchSize);
            s.setFetchDirection(1000);
        }
        return s;
    }

    public void setProperty(String property, Object value) {
    }

    private void createTemporaryConceptTable(Connection dbc, Iterable<String> concepts) throws SQLException {
        try (Statement s = dbc.createStatement();){
            s.executeUpdate("DROP TABLE IF EXISTS temp_concepts");
        }
        s = dbc.createStatement();
        var4_4 = null;
        try {
            s.executeUpdate("CREATE TEMPORARY TABLE temp_concepts(concept VARCHAR(255) PRIMARY KEY)");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var4_4 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
        var4_4 = null;
        try (PreparedStatement ps = dbc.prepareStatement("INSERT INTO temp_concepts(concept) VALUES(?)");){
            for (String concept : concepts) {
                ps.clearParameters();
                ps.clearWarnings();
                ps.setString(1, concept);
                ps.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private String escapeLikeString(String likeString) {
        return likeString;
    }

    public I2b2Extractor extract(Timestamp start_min, Timestamp start_max, Iterable<String> notations) throws SQLException {
        Statement ps = null;
        ResultSet rs = null;
        Connection dbc = null;
        try {
            dbc = this.ds.getConnection();
            dbc.setAutoCommit(true);
            StringBuilder b = new StringBuilder(600);
            b.append("SELECT ");
            b.append(SELECT_PARAMETERS + " FROM " + SELECT_TABLE + " ");
            if (notations != null) {
                log.info("Creating temporary table for concept ids");
                Iterable<String> ids = notations;
                int wildcardCount = 0;
                if (this.allowWildcardConceptCodes) {
                    ArrayList<String> escaped = new ArrayList<String>();
                    for (String id : ids) {
                        String es = this.escapeLikeString(id).replace('*', '%');
                        if (!es.equals(id)) {
                            ++wildcardCount;
                        }
                        escaped.add(es);
                    }
                    ids = escaped;
                }
                this.createTemporaryConceptTable(dbc, ids);
                if (wildcardCount > 0) {
                    b.append(" JOIN temp_concepts tc ON f.concept_cd LIKE tc.concept ");
                } else {
                    b.append(" JOIN temp_concepts tc ON f.concept_cd=tc.concept ");
                }
            }
            b.append("WHERE f.start_date BETWEEN ? AND ? ");
            b.append(SELECT_ORDER_GROUP);
            log.info("SQL: " + b.toString());
            ps = this.prepareStatement(dbc, b.toString());
            ps.setTimestamp(1, start_min);
            ps.setTimestamp(2, start_max);
            rs = ps.executeQuery();
            return new I2b2Extractor(this, dbc, rs);
        }
        catch (SQLException e) {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (dbc != null) {
                dbc.close();
            }
            throw e;
        }
    }

    @Override
    public void close() {
    }

    public ObservationSupplier extract(Instant start_min, Instant start_max, Iterable<String> notations) throws ObservationException {
        try {
            return this.extract(Timestamp.from(start_min), Timestamp.from(start_max), notations);
        }
        catch (SQLException e) {
            throw new ObservationException((Throwable)e);
        }
    }
}

