/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.DateTimeAccuracy;
import de.sekmi.histream.i2b2.I2b2Visit;
import java.text.ParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import org.junit.Assert;
import org.junit.Test;

public class TestI2b2Visit {
    private DateTimeAccuracy createAccurateTimestamp() {
        try {
            return DateTimeAccuracy.parsePartialIso8601((String)"2001-02-03T04:05:06");
        }
        catch (ParseException e) {
            throw new AssertionError();
        }
    }

    @Test
    public void verifyAccurateTimestampParsing() {
        Assert.assertEquals((Object)ChronoUnit.SECONDS, (Object)this.createAccurateTimestamp().getAccuracy());
        I2b2Visit v = this.createVisitWithTimestamps();
        Assert.assertEquals((Object)ChronoUnit.SECONDS, (Object)v.getEndTime().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.SECONDS, (Object)v.getStartTime().getAccuracy());
    }

    private I2b2Visit createVisitWithTimestamps() {
        I2b2Visit v = new I2b2Visit(0, 0);
        v.setStartTime(this.createAccurateTimestamp());
        v.setEndTime(this.createAccurateTimestamp());
        return v;
    }

    @Test
    public void verifyDaysAccuracy() {
        I2b2Visit v = this.createVisitWithTimestamps();
        v.setActiveStatusCd(null);
        Assert.assertEquals((Object)ChronoUnit.DAYS, (Object)v.getEndTime().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.DAYS, (Object)v.getStartTime().getAccuracy());
        v = this.createVisitWithTimestamps();
        v.setActiveStatusCd("");
        Assert.assertEquals((Object)ChronoUnit.DAYS, (Object)v.getEndTime().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.DAYS, (Object)v.getStartTime().getAccuracy());
        v = this.createVisitWithTimestamps();
        v.setActiveStatusCd("YD");
        Assert.assertEquals((Object)ChronoUnit.DAYS, (Object)v.getEndTime().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.DAYS, (Object)v.getStartTime().getAccuracy());
    }

    @Test
    public void verifyMinuteAccuracy() {
        I2b2Visit v = this.createVisitWithTimestamps();
        v.setActiveStatusCd("I");
        Assert.assertEquals((Object)ChronoUnit.MINUTES, (Object)v.getStartTime().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.DAYS, (Object)v.getEndTime().getAccuracy());
        v = this.createVisitWithTimestamps();
        v.setActiveStatusCd("T");
        Assert.assertEquals((Object)ChronoUnit.DAYS, (Object)v.getStartTime().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.MINUTES, (Object)v.getEndTime().getAccuracy());
    }

    @Test
    public void verifyHourAndNullAccuracy() {
        I2b2Visit v = this.createVisitWithTimestamps();
        v.setActiveStatusCd("UH");
        Assert.assertEquals((Object)ChronoUnit.HOURS, (Object)v.getStartTime().getAccuracy());
        Assert.assertEquals((long)4L, (long)v.getStartTime().get((TemporalField)ChronoField.HOUR_OF_DAY));
        Assert.assertNull((Object)v.getEndTime());
        v = this.createVisitWithTimestamps();
        v.setActiveStatusCd("RL");
        Assert.assertNull((Object)v.getStartTime());
        Assert.assertEquals((Object)ChronoUnit.HOURS, (Object)v.getEndTime().getAccuracy());
        Assert.assertEquals((long)4L, (long)v.getEndTime().get((TemporalField)ChronoField.HOUR_OF_DAY));
    }

    @Test
    public void verifyMonthAndYearAccuracy() {
        I2b2Visit v = this.createVisitWithTimestamps();
        v.setActiveStatusCd("XB");
        Assert.assertEquals((Object)ChronoUnit.MONTHS, (Object)v.getStartTime().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.YEARS, (Object)v.getEndTime().getAccuracy());
        v = this.createVisitWithTimestamps();
        v.setActiveStatusCd("MF");
        Assert.assertEquals((Object)ChronoUnit.YEARS, (Object)v.getStartTime().getAccuracy());
        Assert.assertEquals((Object)ChronoUnit.MONTHS, (Object)v.getEndTime().getAccuracy());
    }
}

