/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2.ont;

import de.sekmi.histream.i2b2.ont.PostgresUtil;
import de.sekmi.histream.ontology.Concept;
import de.sekmi.histream.ontology.Ontology;
import de.sekmi.histream.ontology.OntologyException;
import de.sekmi.histream.ontology.ValueRestriction;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Import
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(Import.class.getName());
    private Ontology ontology;
    private Connection dbMeta;
    private Connection dbData;
    private Locale locale;
    private PreparedStatement insertMeta;
    private PreparedStatement insertAccess;
    private PreparedStatement insertConcept;
    private int insertMetaCount;
    private int insertAccessCount;
    private int insertConceptCount;
    private int deleteMetaCount;
    private int deleteAccessCount;
    private int deleteConceptCount;
    private String sourceId;
    private String sourceIdDelete;
    private String ontScheme;
    private Timestamp sourceTimestamp;
    private String metaBase;
    private String metaTable;
    private String metaAccess;
    private String dataConceptTable;
    private Consumer<String> warningHandler;

    public Import(Map<String, String> props) throws ClassNotFoundException, SQLException {
        this.openDatabase(props);
        this.readConfiguration(props);
        this.prepareStatements();
        this.warningHandler = log::warning;
    }

    public Import(Connection dbMeta, Connection dbData, Map<String, String> props) throws SQLException {
        this.dbMeta = dbMeta;
        this.dbData = dbData;
        this.readConfiguration(props);
        this.prepareStatements();
        this.warningHandler = log::warning;
    }

    private String getMetaTable() {
        return this.metaTable;
    }

    private String getAccessTable() {
        return this.metaAccess;
    }

    private String getConceptTable() {
        return this.dataConceptTable;
    }

    public int getInsertMetaCount() {
        return this.insertMetaCount;
    }

    public int getDeleteMetaCount() {
        return this.deleteMetaCount;
    }

    public int getInsertConceptCount() {
        return this.insertConceptCount;
    }

    public int getDeleteConceptCount() {
        return this.deleteConceptCount;
    }

    public int getInsertAccessCount() {
        return this.insertAccessCount;
    }

    public int getDeleteAccessCount() {
        return this.deleteAccessCount;
    }

    private void showWarning(String warning) {
        this.warningHandler.accept(warning);
    }

    private void prepareStatements() throws SQLException {
        this.insertMeta = this.dbMeta.prepareStatement("INSERT INTO " + this.getMetaTable() + "(c_hlevel,c_fullname,c_name,c_synonym_cd,c_visualattributes,c_basecode,c_metadataxml,c_facttablecolumn,c_tablename,c_columnname,c_columndatatype,c_operator,c_dimcode,c_tooltip,m_applied_path,update_date,download_date,import_date,sourcesystem_cd)VALUES(?,?,?,?,?,?,?,'concept_cd','concept_dimension','concept_path','T','LIKE',?,?,?,current_timestamp,?,current_timestamp,?)");
        String access_table_name = this.getMetaTable();
        if (access_table_name.indexOf(46) >= 0) {
            access_table_name = access_table_name.substring(access_table_name.indexOf(46) + 1);
        }
        this.insertAccess = this.dbMeta.prepareStatement("INSERT INTO " + this.getAccessTable() + "(c_table_cd,c_table_name,c_protected_access,c_hlevel,c_fullname,c_name,c_synonym_cd,c_visualattributes,c_facttablecolumn,c_dimtablename,c_columnname,c_columndatatype,c_operator,c_dimcode,c_tooltip)VALUES(?,'" + access_table_name + "','N',?,?,?,?,?,'concept_cd','concept_dimension','concept_path','T','LIKE',?,?)");
        this.insertConcept = this.dbData.prepareStatement("INSERT INTO " + this.getConceptTable() + "(concept_path,concept_cd,name_char,update_date,download_date,import_date,sourcesystem_cd)VALUES(?,?,?,current_timestamp,?,current_timestamp,?)");
    }

    public void setWarningHandler(Consumer<String> warningHandler) {
        this.warningHandler = warningHandler;
    }

    private void readConfiguration(Map<String, String> config) {
        this.metaBase = config.get("meta.basepath");
        this.sourceId = config.get("meta.sourcesystem_cd");
        this.sourceIdDelete = config.getOrDefault("meta.sourcesystem_cd.delete", this.sourceId);
        if (this.sourceIdDelete.trim().length() == 0) {
            this.sourceIdDelete = null;
        }
        this.metaTable = config.get("meta.table");
        this.metaAccess = config.get("meta.access");
        this.dataConceptTable = config.get("data.concept.table");
        Objects.requireNonNull(this.metaTable, "Need configuration: meta.table");
        Objects.requireNonNull(this.metaAccess, "Need configuration: meta.access");
        Objects.requireNonNull(this.dataConceptTable, "Need configuration: data.concept.table");
        this.locale = config.get("ont.language") == null ? Locale.getDefault() : Locale.forLanguageTag(config.get("ont.language"));
        if (config.get("ont.scheme") != null) {
            this.ontScheme = config.get("ont.scheme");
        }
    }

    private void deleteFromDatabase() throws SQLException {
        if (this.sourceIdDelete == null) {
            return;
        }
        PreparedStatement deleteOnt = this.dbMeta.prepareStatement("DELETE FROM " + this.getMetaTable() + " WHERE sourcesystem_cd=?");
        PreparedStatement deleteAccess = this.dbMeta.prepareStatement("DELETE FROM " + this.getAccessTable() + " WHERE c_table_cd LIKE ?");
        PreparedStatement deleteConcepts = this.dbData.prepareStatement("DELETE FROM " + this.getConceptTable() + " WHERE sourcesystem_cd=?");
        deleteConcepts.setString(1, this.sourceIdDelete);
        this.deleteConceptCount = deleteConcepts.executeUpdate();
        deleteConcepts.close();
        deleteAccess.setString(1, this.sourceIdDelete + "%");
        this.deleteAccessCount = deleteAccess.executeUpdate();
        deleteAccess.close();
        deleteOnt.setString(1, this.sourceIdDelete);
        this.deleteMetaCount = deleteOnt.executeUpdate();
        deleteOnt.close();
    }

    public void processOntology() throws SQLException, OntologyException {
        Concept[] concepts;
        int base_level;
        this.deleteFromDatabase();
        String base = this.metaBase;
        if (base != null && !base.equals("\\")) {
            String[] baseParts = base.split("\\\\");
            if (baseParts.length < 2 || baseParts[0].length() != 0 || !base.endsWith("\\")) {
                throw new IllegalArgumentException("meta.basepath must start and end with a backslash (\\)");
            }
            base_level = baseParts.length - 1;
        } else {
            base = "\\";
            base_level = 0;
        }
        for (Concept c : concepts = this.ontology.getTopConcepts(this.ontScheme)) {
            this.insertMeta(base_level, base, c, true);
        }
    }

    private void insertConceptDimension(String path, String name, String concept_cd) throws SQLException {
        this.insertConcept.setString(1, path);
        this.insertConcept.setString(2, concept_cd);
        this.insertConcept.setString(3, name);
        this.insertConcept.setTimestamp(4, this.sourceTimestamp);
        this.insertConcept.setString(5, this.sourceId);
        this.insertConcept.executeUpdate();
        ++this.insertConceptCount;
    }

    private String generateMetadataXML(ValueRestriction vr) throws XMLStreamException, OntologyException {
        StringWriter xmlbuf = new StringWriter();
        XMLOutputFactory xmlout = XMLOutputFactory.newInstance();
        XMLStreamWriter xml = xmlout.createXMLStreamWriter(xmlbuf);
        xml.writeStartElement("ValueMetadata");
        xml.writeStartElement("Version");
        xml.writeCharacters("3.02");
        xml.writeEndElement();
        xml.writeStartElement("CreationDateTime");
        xml.writeCharacters("10/07/2002 15:08:07");
        xml.writeEndElement();
        Object[] ev = vr.getEnumerationValues();
        if (ev != null) {
            int i;
            xml.writeStartElement("DataType");
            xml.writeCharacters("Enum");
            xml.writeEndElement();
            xml.writeStartElement("Oktousevalues");
            xml.writeCharacters("Y");
            xml.writeEndElement();
            xml.writeStartElement("EnumValues");
            String[] labels = vr.getEnumerationLabels(this.locale);
            if (labels == null) {
                labels = new String[ev.length];
                for (i = 0; i < labels.length; ++i) {
                    labels[i] = ev[i].toString();
                }
            }
            for (i = 0; i < ev.length; ++i) {
                xml.writeStartElement("Val");
                xml.writeAttribute("description", labels[i]);
                xml.writeCharacters(ev[i].toString());
                xml.writeEndElement();
            }
            xml.writeEndElement();
        } else {
            String i2b2type;
            QName type = vr.getType();
            if (type != null) {
                switch (type.getLocalPart()) {
                    case "integer": 
                    case "int": {
                        i2b2type = "Integer";
                        break;
                    }
                    case "float": 
                    case "decimal": {
                        i2b2type = "Float";
                        break;
                    }
                    default: {
                        i2b2type = "String";
                        break;
                    }
                }
            } else {
                i2b2type = "String";
            }
            xml.writeStartElement("DataType");
            xml.writeCharacters(i2b2type);
            xml.writeEndElement();
            xml.writeStartElement("Oktousevalues");
            xml.writeCharacters("Y");
            xml.writeEndElement();
        }
        xml.writeEndDocument();
        xml.close();
        try {
            xmlbuf.close();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        return xmlbuf.toString();
    }

    public String readableConceptPath(String path) {
        if (path.startsWith(this.metaBase)) {
            path = path.substring(this.metaBase.length());
        }
        StringBuilder b = new StringBuilder();
        int pos = 0;
        boolean done = false;
        do {
            int prefix_char;
            int sep;
            if ((sep = path.indexOf(92, pos)) == -1) {
                done = true;
                sep = path.length();
            } else if (sep == path.length() - 1) {
                done = true;
            }
            if (path.substring(pos, pos + 7).equals("http://")) {
                prefix_char = 35;
                pos += 7;
            } else {
                prefix_char = 58;
            }
            int pfx = path.indexOf(prefix_char, pos);
            if (pfx != -1 && pfx < sep) {
                pos = pfx + 1;
            }
            b.append('\\').append(path.substring(pos, sep));
            pos = sep + 1;
        } while (!done);
        return b.toString();
    }

    private void insertMeta(int level, String path_prefix, Concept concept, boolean accessRoot) throws SQLException, OntologyException {
        ValueRestriction vr;
        this.insertMeta.setInt(1, level);
        String label = concept.getPrefLabel(this.locale);
        String path_part = concept.getID();
        if (label == null && (label = concept.getPrefLabel(null)) == null) {
            label = concept.getID();
            this.showWarning("Missing prefLabel for concept " + concept + " substituted with ID");
        }
        String path = path_prefix + path_part + "\\";
        this.insertMeta.setString(2, path);
        this.insertMeta.setString(3, label);
        String synonymCd = "N";
        this.insertMeta.setString(4, synonymCd);
        Concept[] subConcepts = concept.getNarrower();
        String[] conceptIds = concept.getNotations();
        if (conceptIds.length == 0) {
            this.insertMeta.setString(5, "FA");
            this.insertMeta.setString(6, null);
        } else if (conceptIds.length == 1) {
            String visualAttr = subConcepts.length == 0 ? "LA" : "FA";
            this.insertMeta.setString(5, visualAttr);
            this.insertMeta.setString(6, conceptIds[0]);
        } else if (subConcepts.length == 0) {
            this.insertMeta.setString(5, "LA");
            this.insertMeta.setString(6, conceptIds[0]);
        } else {
            this.insertMeta.setString(5, "FA");
            this.insertMeta.setString(6, conceptIds[0]);
            this.showWarning("Ignoring ids other than '" + conceptIds[0] + "' of concept " + concept);
        }
        if (conceptIds.length != 0) {
            this.insertConceptDimension(path, label, conceptIds[0]);
        }
        if ((vr = concept.getValueRestriction()) == null) {
            this.insertMeta.setString(7, null);
        } else {
            try {
                this.insertMeta.setString(7, this.generateMetadataXML(vr));
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                this.insertMeta.setString(7, null);
            }
        }
        this.insertMeta.setString(8, path);
        String descr = concept.getDescription(this.locale);
        if (descr == null) {
            descr = this.readableConceptPath(path);
        }
        this.insertMeta.setString(9, descr);
        this.insertMeta.setString(10, "@");
        this.insertMeta.setTimestamp(11, this.sourceTimestamp);
        this.insertMeta.setString(12, this.sourceId);
        this.insertMeta.executeUpdate();
        ++this.insertMetaCount;
        if (accessRoot) {
            this.insertAccess.setString(1, this.sourceId + "_" + Integer.toHexString(concept.hashCode()));
            this.insertAccess.setInt(2, level);
            this.insertAccess.setString(3, path);
            this.insertAccess.setString(4, label);
            this.insertAccess.setString(5, synonymCd);
            this.insertAccess.setString(6, "FA");
            this.insertAccess.setString(7, path);
            this.insertAccess.setString(8, descr);
            this.insertAccess.executeUpdate();
            ++this.insertAccessCount;
        }
        for (Concept sub : subConcepts) {
            this.insertMeta(level + 1, path, sub, false);
        }
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
        this.sourceTimestamp = new Timestamp(ontology.lastModified());
    }

    private void openDatabase(Map<String, String> props) throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        this.dbMeta = PostgresUtil.getConnection(props, new String[]{"jdbc.", "meta.jdbc."});
        this.dbMeta.setAutoCommit(true);
        this.dbData = PostgresUtil.getConnection(props, new String[]{"jdbc.", "data.jdbc."});
        this.dbData.setAutoCommit(true);
    }

    @Override
    public void close() {
        try {
            this.dbMeta.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Error closing database connection", e);
        }
        try {
            this.dbData.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Error closing database connection", e);
        }
    }
}

