/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.i2b2;

import de.sekmi.histream.AbnormalFlag;
import de.sekmi.histream.DateTimeAccuracy;
import de.sekmi.histream.Observation;
import de.sekmi.histream.ObservationSupplier;
import de.sekmi.histream.Value;
import de.sekmi.histream.ext.ExternalSourceType;
import de.sekmi.histream.ext.Patient;
import de.sekmi.histream.ext.Visit;
import de.sekmi.histream.i2b2.I2b2ExtractorFactory;
import de.sekmi.histream.i2b2.UncheckedSQLException;
import de.sekmi.histream.impl.ExternalSourceImpl;
import de.sekmi.histream.impl.NumericValue;
import de.sekmi.histream.impl.StringValue;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class I2b2Extractor
implements ObservationSupplier {
    private static final Logger log = Logger.getLogger(I2b2Extractor.class.getName());
    private I2b2ExtractorFactory factory;
    private Connection dbc;
    private ResultSet rs;
    private boolean finished;

    I2b2Extractor(I2b2ExtractorFactory factory, Connection dbc, ResultSet rs) throws SQLException {
        this.factory = factory;
        this.dbc = dbc;
        this.rs = rs;
        if (!rs.next()) {
            this.finished = true;
        }
    }

    protected void errorHandler(SQLException exception) {
        throw new UncheckedSQLException(exception);
    }

    private Row loadRow() throws SQLException {
        Row row = new Row();
        row.pid = this.rs.getInt(1);
        row.eid = this.rs.getInt(2);
        row.inst = this.rs.getInt(3);
        if (this.rs.wasNull()) {
            row.inst = null;
        }
        row.cid = this.rs.getString(4);
        row.mid = this.factory.dialect.decodeModifierCd(this.rs.getString(5));
        row.lid = this.factory.dialect.decodeLocationCd(this.rs.getString(7));
        row.start = this.rs.getTimestamp(8);
        row.end = this.rs.getTimestamp(9);
        row.vt = this.factory.dialect.decodeValueTypeCd(this.rs.getString(10));
        row.vc = this.rs.getString(11);
        row.vn = this.rs.getBigDecimal(12);
        row.vf = this.factory.dialect.decodeValueFlagCd(this.rs.getString(13));
        row.vu = this.factory.dialect.decodeUnitCd(this.rs.getString(14));
        row.source_ts = this.rs.getTimestamp(15);
        row.source_cd = this.rs.getString(16);
        return row;
    }

    private Value createValue(Row row) {
        if (row.vt == null) {
            return null;
        }
        if (row.vt.equals("T")) {
            StringValue v = new StringValue(row.vc);
            v.setAbnormalFlag(row.vf);
            return v;
        }
        if (row.vt.equals("N")) {
            NumericValue v = new NumericValue(row.vn, row.vu);
            v.setAbnormalFlag(row.vf);
            return v;
        }
        log.severe("Ignoring unsupported value type '" + row.vt + "' for concept " + row.cid);
        return null;
    }

    private Observation createObservation(Row row) {
        Patient patient = null;
        String patientId = null;
        if (this.factory.lookupPatientNum != null && (patient = this.factory.lookupPatientNum.apply(row.pid)) == null) {
            log.severe("Unable to find patient with patient_num=" + row.pid);
        }
        patientId = patient != null ? patient.getId() : Integer.toString(row.pid);
        Observation o = this.factory.getObservationFactory().createObservation(patientId, row.cid, new DateTimeAccuracy(row.start.toLocalDateTime()));
        if (patient != null) {
            o.setExtension(Patient.class, (Object)patient);
        }
        Visit visit = null;
        if (this.factory.lookupVisitNum != null && (visit = this.factory.lookupVisitNum.apply(row.eid)) == null) {
            log.severe("Unable to find visit with encounter_num=" + row.eid);
        }
        if (visit != null) {
            o.setEncounterId(visit.getId());
            o.setExtension(Visit.class, (Object)visit);
        } else {
            o.setEncounterId(Integer.toString(row.eid));
        }
        if (row.end != null) {
            o.setEndTime(new DateTimeAccuracy(row.end.toLocalDateTime()));
        }
        o.setValue(this.createValue(row));
        if (row.lid != null) {
            o.setLocationId(row.lid);
        }
        o.setSource((ExternalSourceType)new ExternalSourceImpl(row.source_cd, row.source_ts.toInstant()));
        return o;
    }

    private boolean isModifier(Row fact, Row modifier) {
        return fact.pid == modifier.pid && fact.eid == modifier.eid && fact.inst != null && modifier.inst != null && fact.inst.equals(modifier.inst) && modifier.mid != null;
    }

    public Observation get() {
        if (this.finished) {
            return null;
        }
        Observation o = null;
        try {
            Row r = this.loadRow();
            if (r.mid != null) {
                throw new SQLException("Null modifier expected for first fact in group");
            }
            o = this.createObservation(r);
            while (true) {
                if (!this.rs.next()) {
                    this.finished = true;
                } else {
                    Row m = this.loadRow();
                    if (this.isModifier(r, m)) {
                        o.addModifier(m.mid, this.createValue(m));
                        continue;
                    }
                }
                break;
            }
        }
        catch (SQLException e) {
            this.errorHandler(e);
        }
        return o;
    }

    public String getMeta(String key) {
        return null;
    }

    public void close() {
        log.info("Closing extractor " + this.toString());
        try {
            this.rs.close();
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Failed to close recortset", e);
        }
        try {
            this.dbc.close();
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Failed to close connection", e);
        }
    }

    public void dump() throws SQLException {
        int count = 0;
        if (this.finished) {
            return;
        }
        do {
            StringBuilder b = new StringBuilder(200);
            b.append("row(");
            b.append(++count);
            b.append("): ");
            b.append(this.rs.getInt(1));
            b.append(", ");
            b.append(this.rs.getInt(2));
            b.append(", ");
            b.append(this.rs.getInt(3));
            b.append(", ");
            b.append(this.rs.getString(4));
            b.append(", ");
            b.append(this.rs.getString(5));
            b.append(", tval=");
            b.append(this.rs.getString(12));
            System.out.println(b.toString());
        } while (this.rs.next());
        this.finished = true;
        System.out.println("Count:" + count);
    }

    private static class Row {
        int pid;
        int eid;
        Integer inst;
        String cid;
        String mid;
        String lid;
        Timestamp start;
        Timestamp end;
        Timestamp source_ts;
        String source_cd;
        String vt;
        String vc;
        BigDecimal vn;
        AbnormalFlag vf;
        String vu;

        private Row() {
        }
    }
}

