/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export.config;

import de.sekmi.histream.export.config.Column;
import de.sekmi.histream.export.config.Concept;
import de.sekmi.histream.export.config.ConceptGroup;
import de.sekmi.histream.export.config.Concepts;
import de.sekmi.histream.export.config.ExportDescriptor;
import de.sekmi.histream.export.config.PatientTable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.stream.StreamSupport;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.junit.Assert;
import org.junit.Test;

public class TestMarshal {
    private ExportDescriptor createDescriptor() {
        ExportDescriptor e = new ExportDescriptor();
        e.concepts = new Concepts();
        e.concepts.concepts = new ArrayList();
        e.concepts.concepts.add(Concept.newNotation((String)"ABC"));
        e.concepts.concepts.add(Concept.newWildcard((String)"CEDIS:*"));
        e.concepts.groups = new ArrayList();
        ConceptGroup d = new ConceptGroup("diag");
        d.concepts.add(Concept.newWildcard((String)"ICD10:*"));
        e.concepts.groups.add(d);
        e.patient = new PatientTable();
        e.patient.columns = new Column[2];
        e.patient.columns[0] = new Column("pid", "@id");
        e.patient.columns[1] = new Column("dob", "birthdate");
        return e;
    }

    @Test
    public void verifyMarshal() throws JAXBException {
        ExportDescriptor e = this.createDescriptor();
        JAXBContext j = JAXBContext.newInstance((Class[])new Class[]{ExportDescriptor.class});
        Marshaller m = j.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)e, (OutputStream)System.out);
    }

    @Test
    public void verifyIterableIterable() {
        ExportDescriptor e = this.createDescriptor();
        long count = StreamSupport.stream(e.concepts.allConcepts().spliterator(), false).count();
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void verifyUnmarshall() {
        ExportDescriptor e = (ExportDescriptor)JAXB.unmarshal((InputStream)this.getClass().getResourceAsStream("/export1.xml"), ExportDescriptor.class);
        Assert.assertEquals((long)3L, (long)StreamSupport.stream(e.concepts.allConcepts().spliterator(), false).count());
        e = (ExportDescriptor)JAXB.unmarshal((InputStream)this.getClass().getResourceAsStream("/export2.xml"), ExportDescriptor.class);
        Assert.assertEquals((long)5L, (long)StreamSupport.stream(e.concepts.allConcepts().spliterator(), false).count());
    }
}

