/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import de.sekmi.histream.export.ExportWriter;
import de.sekmi.histream.export.TableWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MemoryExportWriter
implements ExportWriter {
    List<MemoryTable> tables = new LinkedList<MemoryTable>();

    public TableWriter openPatientTable() {
        MemoryTable t = new MemoryTable("patients");
        this.tables.add(t);
        return t;
    }

    public TableWriter openVisitTable() {
        MemoryTable t = new MemoryTable("visits");
        this.tables.add(t);
        return t;
    }

    public TableWriter openEAVTable(String id) {
        MemoryTable t = new MemoryTable(id);
        this.tables.add(t);
        return t;
    }

    public void dump() {
        for (MemoryTable t : this.tables) {
            t.dump();
            System.out.println();
        }
    }

    public static class MemoryTable
    implements TableWriter {
        List<String[]> rows;
        String[] headers;
        String id;

        public MemoryTable(String id) {
            this.id = id;
            this.rows = new ArrayList<String[]>();
        }

        public void header(String[] headers) {
            this.headers = headers;
        }

        public void row(String[] columns) throws IOException {
            this.rows.add(columns);
        }

        public void close() throws IOException {
        }

        private void dumpRow(String[] row) {
            for (int i = 0; i < row.length; ++i) {
                if (i != 0) {
                    System.out.print("\t");
                }
                System.out.print(row[i]);
            }
            System.out.println();
        }

        public void dump() {
            System.out.println("Table " + this.id + ":");
            this.dumpRow(this.headers);
            for (String[] row : this.rows) {
                this.dumpRow(row);
            }
        }
    }
}

