/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export.csv;

import de.sekmi.histream.export.TableWriter;
import de.sekmi.histream.export.csv.CSVWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

class Table
implements TableWriter {
    private final CSVWriter export;
    private PrintWriter out;

    Table(CSVWriter csvWriter, String filename) throws IOException {
        this.export = csvWriter;
        Path file = this.export.getDirectory().resolve(filename);
        OutputStream os = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        this.out = new PrintWriter(new OutputStreamWriter(os, this.export.getCharset()));
    }

    private void printRow(String[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                this.out.print(this.export.getFieldSeparator());
            }
            this.out.print(this.export.escapeData(data[i]));
        }
        this.out.println();
    }

    @Override
    public void header(String[] headers) {
        this.printRow(headers);
    }

    @Override
    public void row(String[] columns) throws IOException {
        this.printRow(columns);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

