/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export.csv;

import de.sekmi.histream.export.ExportWriter;
import de.sekmi.histream.export.TableWriter;
import de.sekmi.histream.export.csv.Table;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Objects;

public class CSVWriter
implements ExportWriter {
    private char fieldSeparator;
    private Charset charset;
    private Path directory;
    private String filenameExtension;
    private String patientTableName;
    private String visitTableName;

    public CSVWriter(Path directory, char fieldSeparator, String fileSuffix) {
        Objects.requireNonNull(directory, "Directory path required");
        this.charset = Charset.forName("UTF-8");
        this.directory = directory;
        this.fieldSeparator = fieldSeparator;
        this.filenameExtension = fileSuffix;
        this.patientTableName = "patients";
        this.visitTableName = "visits";
        if (fieldSeparator == ' ' || fieldSeparator == '\n') {
            throw new IllegalArgumentException("Single space and line separator not allowed as field separator");
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public String fileNameForTable(String tableName) {
        return tableName + this.getFileExtension();
    }

    public void setFileExtension(String suffix) {
        this.filenameExtension = suffix;
    }

    public String getFileExtension() {
        return this.filenameExtension;
    }

    public void setVisitTableName(String tableName) {
        this.visitTableName = tableName;
    }

    public void setPatientTableName(String tableName) {
        this.patientTableName = tableName;
    }

    public String getPatientTableName() {
        return this.patientTableName;
    }

    public String getVisitTableName() {
        return this.visitTableName;
    }

    protected String escapeData(String data) {
        return data.replace(this.fieldSeparator, ' ').replace('\n', ' ').replace('\r', ' ');
    }

    @Override
    public TableWriter openPatientTable() throws IOException {
        return new Table(this, this.fileNameForTable(this.getPatientTableName()));
    }

    @Override
    public TableWriter openVisitTable() throws IOException {
        return new Table(this, this.fileNameForTable(this.getVisitTableName()));
    }

    @Override
    public TableWriter openEAVTable(String id) throws IOException {
        return new Table(this, this.fileNameForTable(id));
    }

    @Override
    public void close() {
    }
}

