/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import de.sekmi.histream.Observation;
import de.sekmi.histream.ObservationSupplier;
import de.sekmi.histream.export.VisitFragmentParser;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VisitFragmentSupplier
implements Supplier<Node> {
    private ObservationSupplier supplier;
    private Node visit;
    private VisitFragmentParser parser;
    private boolean closed;

    public VisitFragmentSupplier(ObservationSupplier supplier) throws XMLStreamException, ParserConfigurationException {
        this.supplier = supplier;
        this.parser = new VisitFragmentParser(){

            @Override
            protected void visitFragment(Element visit) {
                VisitFragmentSupplier.this.visit = visit;
            }
        };
    }

    @Override
    public Node get() {
        if (this.closed) {
            return null;
        }
        while (this.visit == null) {
            Observation o = (Observation)this.supplier.get();
            if (o == null) {
                this.parser.close();
                this.closed = true;
                break;
            }
            this.parser.accept(o);
        }
        if (this.visit == null) {
            // empty if block
        }
        Node local = this.visit;
        this.visit = null;
        return local;
    }
}

