/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import de.sekmi.histream.ObservationException;
import de.sekmi.histream.export.NoOpStreamWriter;
import de.sekmi.histream.ext.Patient;
import de.sekmi.histream.ext.Visit;
import de.sekmi.histream.io.GroupedXMLWriter;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class VisitFragmentParser
extends GroupedXMLWriter {
    private XMLOutputFactory factory;
    private Document doc;
    private DocumentFragment currentPatient;
    private DocumentFragment currentVisit;
    private boolean firstVisit;

    protected VisitFragmentParser() throws XMLStreamException, ParserConfigurationException {
        this(XMLOutputFactory.newInstance());
    }

    protected VisitFragmentParser(XMLOutputFactory factory) throws XMLStreamException, ParserConfigurationException {
        this.setFormatted(false);
        this.factory = factory;
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        this.createDocument();
        this.setDOMWriter(this.doc);
    }

    private void fixNamespaces(DocumentFragment fragment) {
    }

    private void setDOMWriter(Node node) throws XMLStreamException {
        DOMResult result = new DOMResult(node);
        this.writer = this.factory.createXMLStreamWriter(result);
    }

    private void createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setIgnoringComments(true);
        f.setCoalescing(true);
        f.setIgnoringElementContentWhitespace(true);
        f.setNamespaceAware(true);
        DocumentBuilder builder = f.newDocumentBuilder();
        this.doc = builder.newDocument();
        this.doc.getDomConfig().setParameter("namespaces", true);
        this.doc.getDomConfig().setParameter("namespace-declarations", true);
    }

    protected void endPatient(Patient patient) throws ObservationException {
        this.writer = NoOpStreamWriter.INSTANCE;
        super.endPatient(patient);
        if (this.firstVisit) {
            this.firstVisit = false;
        } else {
            this.patientFragment((Element)this.currentPatient.getFirstChild());
        }
    }

    protected void beginPatient(Patient patient) throws ObservationException {
        this.currentPatient = this.doc.createDocumentFragment();
        try {
            this.setDOMWriter(this.currentPatient);
        }
        catch (XMLStreamException e) {
            throw new ObservationException((Throwable)e);
        }
        super.beginPatient(patient);
    }

    protected void beginEncounter(Visit visit) throws ObservationException {
        if (!this.firstVisit) {
            this.fixNamespaces(this.currentPatient);
            try {
                this.writer.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new ObservationException((Throwable)e);
            }
            this.patientFragment((Element)this.currentPatient.getFirstChild());
            this.firstVisit = true;
        }
        this.currentVisit = this.doc.createDocumentFragment();
        try {
            this.setDOMWriter(this.currentVisit);
        }
        catch (XMLStreamException e) {
            throw new ObservationException((Throwable)e);
        }
        super.beginEncounter(visit);
    }

    protected void endEncounter(Visit visit) throws ObservationException {
        super.endEncounter(visit);
        this.fixNamespaces(this.currentVisit);
        Node node = this.currentVisit.getFirstChild();
        Objects.requireNonNull(node);
        this.visitFragment((Element)this.currentVisit.getFirstChild());
    }

    protected void patientFragment(Element patient) throws ObservationException {
    }

    protected abstract void visitFragment(Element var1) throws ObservationException;
}

