/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import de.sekmi.histream.export.TableWriter;
import de.sekmi.histream.export.config.AbstractTable;
import de.sekmi.histream.export.config.Column;
import de.sekmi.histream.export.config.ExportException;
import java.io.IOException;
import java.util.Objects;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;

public class TableParser
implements AutoCloseable {
    private AbstractTable table;
    private XPath xpath;
    private XPathExpression[] xpaths;
    private TableWriter writer;
    private int rowCount;

    public TableParser(AbstractTable table, TableWriter writer, XPath xpath) throws ExportException, IOException {
        this.table = table;
        this.writer = writer;
        this.xpath = xpath;
        this.rowCount = 0;
        Objects.requireNonNull(table);
        Objects.requireNonNull(writer);
        this.compileXPaths();
        this.writeHeaders();
    }

    protected AbstractTable getTable() {
        return this.table;
    }

    private void compileXPaths() throws ExportException {
        Column[] columns = this.table.getColumns();
        this.xpaths = new XPathExpression[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String expr = columns[i].getXPath();
            try {
                Objects.requireNonNull(expr, "xpath required for column " + this.table.getId() + "." + columns[i].getHeader());
                this.xpaths[i] = this.xpath.compile(expr);
                continue;
            }
            catch (XPathExpressionException e) {
                throw new ExportException("Unable to compile XPath expression for " + this.table.getId() + "." + columns[i].getHeader(), e);
            }
        }
    }

    private void writeHeaders() throws IOException {
        this.writer.header(this.table.getHeaders());
    }

    public void processNode(Node node) throws ExportException, IOException {
        this.writer.row(this.valuesForFragment(node));
        ++this.rowCount;
    }

    private String[] valuesForFragment(Node node) throws ExportException {
        Column[] columns = this.table.getColumns();
        String[] values = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            try {
                values[i] = (String)this.xpaths[i].evaluate(node, XPathConstants.STRING);
                continue;
            }
            catch (XPathExpressionException e) {
                throw new ExportException("XPath evaluation failed for " + this.table.getId() + "." + columns[i].getHeader(), e);
            }
        }
        return values;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public int getRowCount() {
        return this.rowCount;
    }
}

