/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import de.sekmi.histream.ObservationException;
import de.sekmi.histream.ObservationSupplier;
import de.sekmi.histream.export.ExportErrorHandler;
import de.sekmi.histream.export.ExportSummary;
import de.sekmi.histream.export.ExportWriter;
import de.sekmi.histream.export.FragmentExporter;
import de.sekmi.histream.export.UncheckedExportException;
import de.sekmi.histream.export.config.Concept;
import de.sekmi.histream.export.config.ExportDescriptor;
import de.sekmi.histream.export.config.ExportException;
import de.sekmi.histream.io.Streams;
import de.sekmi.histream.xml.NamespaceResolver;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;

public class TableExport {
    private ExportDescriptor desc;
    private XPathFactory factory;
    private NamespaceContext ns;
    private ExportErrorHandler errorHandler;
    private int patientCount;
    private int visitCount;
    private ZoneId zoneId;

    public TableExport(ExportDescriptor desc) {
        this.desc = desc;
        this.factory = XPathFactory.newInstance();
        this.ns = new NamespaceResolver();
        this.errorHandler = new ExportErrorHandler();
    }

    public void setErrorHandler(Consumer<ObservationException> handler) {
        this.errorHandler.setErrorHandler(handler);
    }

    private XPath createXPath() {
        XPath xpath = this.factory.newXPath();
        xpath.setNamespaceContext(this.ns);
        return xpath;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    private void requireDisjointConcepts() throws ExportException {
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayList<String> notations = new ArrayList<String>();
        for (Concept concept : this.desc.allConcepts()) {
            String s = concept.getNotation();
            if (s != null) {
                notations.add(s);
            }
            if ((s = concept.getWildcardNotation()) == null) continue;
            if (s.indexOf(42) != s.length() - 1) {
                throw new ExportException("Illegal wildcard notation: " + s);
            }
            prefixes.add(s.substring(0, s.length() - 1));
        }
        prefixes.sort((a, b) -> a.length() - b.length());
        for (int i = 0; i < prefixes.size(); ++i) {
            String a2 = (String)prefixes.get(i);
            for (int j = i + 1; j < prefixes.size(); ++j) {
                String b2 = (String)prefixes.get(j);
                if (!b2.startsWith(a2)) continue;
                throw new ExportException("Illegal overlapping of wildcard notations '" + a2 + "*' and '" + b2 + "*");
            }
        }
        for (String prefix : prefixes) {
            for (String notation : notations) {
                if (!notation.startsWith(prefix)) continue;
                throw new ExportException("Concepts not unique: wildcard '" + prefix + "*' matches notation '" + notation + "'");
            }
        }
    }

    public ExportSummary export(ObservationSupplier supplier, ExportWriter writer) throws ExportException, IOException {
        this.requireDisjointConcepts();
        FragmentExporter fe = null;
        try {
            fe = new FragmentExporter(this.createXPath(), this.desc, writer);
            fe.setZoneId(this.zoneId);
            fe.setErrorHandler(new ExportErrorHandler());
            Streams.transfer((Supplier)supplier, (Consumer)((Object)fe));
        }
        catch (ParserConfigurationException | XMLStreamException e) {
            throw new ExportException("Unable to create exporter", e);
        }
        catch (UncheckedExportException e) {
            throw e.getCause();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        finally {
            if (fe != null) {
                try {
                    fe.close();
                }
                catch (UncheckedExportException e) {
                    throw e.getCause();
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
            }
        }
        return new ExportSummary(fe.getPatientCount(), fe.getVisitCount(), fe.getObservationCount());
    }

    public int getPatientCount() {
        return this.patientCount;
    }

    public int getVisitCount() {
        return this.visitCount;
    }
}

