/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import de.sekmi.histream.ObservationException;
import de.sekmi.histream.export.EavTableParser;
import de.sekmi.histream.export.ExportWriter;
import de.sekmi.histream.export.FactClassAnnotator;
import de.sekmi.histream.export.TableParser;
import de.sekmi.histream.export.VisitFragmentParser;
import de.sekmi.histream.export.config.Concept;
import de.sekmi.histream.export.config.ConceptGroup;
import de.sekmi.histream.export.config.EavTable;
import de.sekmi.histream.export.config.ExportDescriptor;
import de.sekmi.histream.export.config.ExportException;
import java.io.IOException;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPath;
import org.w3c.dom.Element;

class FragmentExporter
extends VisitFragmentParser {
    private TableParser patientParser;
    private TableParser visitParser;
    private EavTableParser[] eavParsers;
    private Element currentPatient;
    private FactClassAnnotator factAnnotator;

    private void openEavTables(EavTable[] tables, ExportWriter writer, XPath xpath) throws ExportException, IOException {
        this.eavParsers = new EavTableParser[tables.length];
        for (int i = 0; i < this.eavParsers.length; ++i) {
            this.eavParsers[i] = tables[i].createParser(writer.openEAVTable(tables[i].getId()), xpath);
        }
    }

    protected FragmentExporter(XPath xpath, ExportDescriptor desc, ExportWriter writer) throws ExportException, XMLStreamException, ParserConfigurationException {
        try {
            this.patientParser = desc.getPatientTable().createParser(writer.openPatientTable(), xpath);
            this.visitParser = desc.getVisitTable().createParser(writer.openVisitTable(), xpath);
            this.openEavTables(desc.getEAVTables(), writer, xpath);
        }
        catch (IOException e) {
            this.close(e::addSuppressed);
            throw new ExportException("Unable to open table for writing", e);
        }
        catch (ExportException e) {
            this.close(e::addSuppressed);
            throw e;
        }
        this.factAnnotator = new FactClassAnnotator();
        for (ConceptGroup group : desc.getConcepts().getGroups()) {
            String clazz = group.getClazz();
            for (Concept concept : group.getConcepts()) {
                String s = concept.getNotation();
                if (s != null) {
                    this.factAnnotator.addMapRule(s, clazz);
                    continue;
                }
                s = concept.getWildcardNotation();
                if (s != null) {
                    if (s.indexOf(42) < s.length() - 1) {
                        throw new ExportException("Wildcard notation '" + s + "' must contain exactly one * at the end");
                    }
                    this.factAnnotator.addWildcardRule(s.substring(0, s.length() - 1), clazz);
                    continue;
                }
                throw new ExportException("Group concepts must have one of 'notation' or 'wildcard-notation' defined. Concept IRI not supported yet");
            }
        }
    }

    @Override
    protected void patientFragment(Element patient) throws ObservationException {
        this.currentPatient = patient;
        try {
            this.patientParser.processNode(patient);
        }
        catch (ExportException | IOException e) {
            throw new ObservationException((Throwable)e);
        }
    }

    private void writeEavFacts(Element visit) throws ExportException, IOException {
        for (int i = 0; i < this.eavParsers.length; ++i) {
            this.eavParsers[i].processNode(visit);
        }
    }

    @Override
    protected void visitFragment(Element visit) throws ObservationException {
        this.factAnnotator.annotateFacts(visit.getChildNodes());
        this.currentPatient.appendChild(visit);
        try {
            this.visitParser.processNode(visit);
            this.writeEavFacts(visit);
        }
        catch (ExportException | IOException e) {
            throw new ObservationException((Throwable)e);
        }
        finally {
            this.currentPatient.removeChild(visit);
        }
    }

    public void close() {
        super.close();
        this.close(e -> this.reportError(new ObservationException((Throwable)e)));
    }

    private void close(Consumer<IOException> errorAction) {
        if (this.patientParser != null) {
            try {
                this.patientParser.close();
            }
            catch (IOException e) {
                errorAction.accept(e);
            }
        }
        if (this.visitParser != null) {
            try {
                this.visitParser.close();
            }
            catch (IOException e) {
                errorAction.accept(e);
            }
        }
        if (this.eavParsers != null) {
            for (int i = 0; i < this.eavParsers.length; ++i) {
                if (this.eavParsers[i] == null) continue;
                try {
                    this.eavParsers[i].close();
                    continue;
                }
                catch (IOException e) {
                    errorAction.accept(e);
                }
            }
        }
    }

    public int getPatientCount() {
        return this.patientParser.getRowCount();
    }

    public int getVisitCount() {
        return this.visitParser.getRowCount();
    }
}

