/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FactClassAnnotator {
    private Map<String, String> conceptMap = new HashMap<String, String>();
    private List<WildcardRule> wildcardRules = new ArrayList<WildcardRule>();

    public void addMapRule(String concept, String classId) {
        this.conceptMap.put(concept, classId);
    }

    public void addWildcardRule(String prefix, String classId) {
        this.wildcardRules.add(new WildcardRule(prefix, classId));
    }

    public void annotateFact(Node fact) throws IllegalArgumentException {
        if (fact.getNodeType() != 1) {
            throw new IllegalArgumentException("Fact node must be of type element");
        }
        if (!fact.getLocalName().equals("fact")) {
            throw new IllegalArgumentException("Local name of node '" + fact.getLocalName() + "' must be 'fact'");
        }
        String concept = ((Element)fact).getAttribute("concept");
        String clazz = this.conceptMap.get(concept);
        if (clazz == null) {
            for (WildcardRule rule : this.wildcardRules) {
                if (!concept.startsWith(rule.prefix)) continue;
                clazz = rule.classId;
                break;
            }
        }
        if (clazz != null) {
            ((Element)fact).setAttribute("class", clazz);
        }
    }

    public void annotateFacts(NodeList facts) {
        for (int i = 0; i < facts.getLength(); ++i) {
            Node next = facts.item(i);
            if (next.getNodeType() != 1 || !next.getLocalName().equals("fact")) continue;
            this.annotateFact(next);
        }
    }

    public void annotateFactSiblings(Node first) {
        this.annotateFact(first);
        for (Node next = first.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (next.getNodeType() != 1 || !next.getLocalName().equals("fact")) continue;
            this.annotateFact(next);
        }
    }

    private class WildcardRule {
        String prefix;
        String classId;

        public WildcardRule(String prefix, String classId) {
            this.prefix = prefix;
            this.classId = classId;
        }
    }
}

