/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import de.sekmi.histream.ObservationException;
import de.sekmi.histream.export.UncheckedExportException;
import de.sekmi.histream.export.config.ExportException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;

class ExportErrorHandler
implements Consumer<ObservationException> {
    private Consumer<ObservationException> parentHandler;

    ExportErrorHandler() {
    }

    public void setErrorHandler(Consumer<ObservationException> parentHandler) {
        this.parentHandler = parentHandler;
    }

    @Override
    public void accept(ObservationException t) {
        Throwable cause = t.getCause();
        if (cause != null) {
            if (cause.getClass() == ExportException.class) {
                throw new UncheckedExportException((ExportException)cause);
            }
            if (cause.getClass() == IOException.class) {
                throw new UncheckedIOException((IOException)cause);
            }
        }
        if (this.parentHandler == null) {
            throw new RuntimeException((Throwable)t);
        }
        this.parentHandler.accept(t);
    }
}

