/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import de.sekmi.histream.export.TableParser;
import de.sekmi.histream.export.TableWriter;
import de.sekmi.histream.export.config.EavTable;
import de.sekmi.histream.export.config.ExportException;
import java.io.IOException;
import java.util.Objects;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EavTableParser
extends TableParser {
    private XPathExpression factSelector;

    public EavTableParser(EavTable table, TableWriter writer, XPath xpath) throws ExportException, IOException {
        super(table, writer, xpath);
        Objects.requireNonNull(table.getXPath(), "xpath expression required for eav-table[id='" + table.getId() + "']/@xpath");
        try {
            this.factSelector = xpath.compile(table.getXPath());
        }
        catch (XPathExpressionException e) {
            throw new ExportException("Unable to compile xpath attribute '" + table.getXPath() + "' for table " + table.getId());
        }
    }

    @Override
    public void processNode(Node visit) throws ExportException, IOException {
        NodeList nl;
        try {
            nl = (NodeList)this.factSelector.evaluate(visit, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ExportException("XPath evaluation failed for eav-table[@id='" + this.getTable().getId() + "']/@xpath", e);
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !n.getLocalName().equals("fact")) {
                throw new ExportException("xpath for eav table '" + this.getTable().getId() + " must select only 'fact' elements. instead found " + n.toString());
            }
            super.processNode(n);
        }
    }
}

