/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import de.sekmi.histream.ObservationSupplier;
import de.sekmi.histream.export.ExceptionCausingWriter;
import de.sekmi.histream.export.ExportWriter;
import de.sekmi.histream.export.MemoryExportWriter;
import de.sekmi.histream.export.TableExport;
import de.sekmi.histream.export.config.ExportDescriptor;
import de.sekmi.histream.io.FileObservationProviderTest;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestExport {
    private ExportDescriptor descriptor;
    private TableExport export;

    @Before
    public void initialize() throws Exception {
        try (InputStream in = this.getClass().getResourceAsStream("/export1.xml");){
            this.descriptor = ExportDescriptor.parse((InputStream)in);
        }
        this.export = new TableExport(this.descriptor);
    }

    @Test
    public void verifyExport() throws Exception {
        MemoryExportWriter m = new MemoryExportWriter();
        FileObservationProviderTest t = new FileObservationProviderTest();
        t.initializeObservationFactory();
        try (ObservationSupplier s = t.getExampleSupplier();){
            this.export.export(s, (ExportWriter)m);
        }
        Assert.assertEquals((Object)"T:type:str", (Object)m.get("visits", "byclass", 0));
        m.dump();
        Assert.assertEquals((long)6L, (long)m.rowCount("eavtabletest"));
        Assert.assertEquals((Object)"T:date:month", (Object)m.get("eavtabletest", "code", 4));
    }

    @Test
    public void expectIOExceptionPassThrough() throws Exception {
        ExceptionCausingWriter w = new ExceptionCausingWriter(ExceptionCausingWriter.WhereToThrow.VisitTable, ExceptionCausingWriter.WhenToThrow.CloseTable);
        FileObservationProviderTest t = new FileObservationProviderTest();
        t.initializeObservationFactory();
        try (ObservationSupplier s = t.getExampleSupplier();){
            this.export.export(s, (ExportWriter)w);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

