/*
 * Decompiled with CFR 0.152.
 */
package de.sekmi.histream.export;

import de.sekmi.histream.export.ExportWriter;
import de.sekmi.histream.export.TableWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemoryExportWriter
implements ExportWriter {
    public static final String PATIENT_TABLE = "patients";
    public static final String VISIT_TABLE = "visits";
    Map<String, MemoryTable> tables = new HashMap<String, MemoryTable>();

    public TableWriter openPatientTable() {
        MemoryTable t = new MemoryTable(PATIENT_TABLE);
        this.tables.put(t.id, t);
        return t;
    }

    public TableWriter openVisitTable() {
        MemoryTable t = new MemoryTable(VISIT_TABLE);
        this.tables.put(t.id, t);
        return t;
    }

    public TableWriter openEAVTable(String id) {
        if (this.tables.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate table id: " + id);
        }
        MemoryTable t = new MemoryTable(id);
        this.tables.put(t.id, t);
        return t;
    }

    public void dump() {
        for (MemoryTable t : this.tables.values()) {
            t.dump();
            System.out.println();
        }
    }

    public String get(String table, String column, int row) throws IndexOutOfBoundsException {
        MemoryTable t = this.tables.get(table);
        if (t == null) {
            throw new IndexOutOfBoundsException("Non-existing table " + table);
        }
        int index = Arrays.asList(t.headers).indexOf(column);
        if (index == -1) {
            throw new IndexOutOfBoundsException("Table " + table + " does not contain column " + column);
        }
        if (row < 0 || row >= t.rows.size()) {
            throw new IndexOutOfBoundsException("Unable to access row " + row + " in table " + table + " (has only " + t.rows.size() + " rows)");
        }
        return t.rows.get(row)[index];
    }

    public int rowCount(String table) throws IndexOutOfBoundsException {
        MemoryTable t = this.tables.get(table);
        if (t == null) {
            throw new IndexOutOfBoundsException("Non-existing table " + table);
        }
        return t.rows.size();
    }

    public void close() {
    }

    public static class MemoryTable
    implements TableWriter {
        List<String[]> rows;
        String[] headers;
        String id;

        public MemoryTable(String id) {
            this.id = id;
            this.rows = new ArrayList<String[]>();
        }

        public void header(String[] headers) {
            this.headers = headers;
        }

        public void row(String[] columns) throws IOException {
            this.rows.add(columns);
        }

        public void close() throws IOException {
        }

        private void dumpRow(String[] row) {
            for (int i = 0; i < row.length; ++i) {
                if (i != 0) {
                    System.out.print("\t");
                }
                System.out.print(row[i]);
            }
            System.out.println();
        }

        public void dump() {
            System.out.println("Table " + this.id + ":");
            this.dumpRow(this.headers);
            for (String[] row : this.rows) {
                this.dumpRow(row);
            }
        }
    }
}

